/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.channel.DatagramChannelProxy;
import network.ycc.raknet.packet.NoFreeConnections;
import network.ycc.raknet.server.RakNetServer;
import network.ycc.raknet.server.channel.RakNetChildChannel;

public class RakNetServerChannel
extends DatagramChannelProxy
implements ServerChannel {
    protected final Map<SocketAddress, RakNetChildChannel> childMap = new HashMap<SocketAddress, RakNetChildChannel>();

    public RakNetServerChannel() {
        this(NioDatagramChannel.class);
    }

    public RakNetServerChannel(Supplier<? extends DatagramChannel> ioChannelSupplier) {
        super(ioChannelSupplier);
        this.addDefaultPipeline();
    }

    public RakNetServerChannel(Class<? extends DatagramChannel> ioChannelType) {
        super(ioChannelType);
        this.addDefaultPipeline();
    }

    public Channel getChildChannel(SocketAddress addr) {
        if (!this.eventLoop().inEventLoop()) {
            throw new IllegalStateException("Method must be called from the server eventLoop!");
        }
        return (Channel)this.childMap.get(addr);
    }

    @Override
    protected void gracefulClose(ChannelPromise promise) {
        PromiseCombiner combined = new PromiseCombiner();
        ChannelPromise childrenClosed = this.newPromise();
        this.childMap.values().forEach(child -> combined.add((Future)child.applicationChannel.close()));
        combined.finish((Promise)childrenClosed);
        childrenClosed.addListener(f -> this.listener.close(this.wrapPromise(promise)));
    }

    protected void addDefaultPipeline() {
        this.pipeline().addLast(new ChannelHandler[]{this.newServerHandler()}).addLast(new ChannelHandler[]{RakNetServer.DefaultDatagramInitializer.INSTANCE});
    }

    protected ChannelHandler newServerHandler() {
        return new ServerHandler();
    }

    protected RakNetChildChannel newChild(InetSocketAddress remoteAddress, InetSocketAddress localAddress, Consumer<Channel> registerChannel) {
        return new RakNetChildChannel(this, remoteAddress, localAddress, registerChannel);
    }

    protected void removeChild(SocketAddress remoteAddress, RakNetChildChannel child) {
        this.childMap.remove(remoteAddress, (Object)child);
    }

    protected void addChild(SocketAddress remoteAddress, RakNetChildChannel child) {
        this.childMap.put(remoteAddress, child);
    }

    protected class ServerHandler
    extends ChannelDuplexHandler {
        protected ServerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            block12: {
                try {
                    if (localAddress != null && !RakNetServerChannel.this.localAddress().equals(localAddress)) {
                        throw new IllegalArgumentException("Bound localAddress does not match provided " + localAddress);
                    }
                    if (!(remoteAddress instanceof InetSocketAddress)) {
                        throw new IllegalArgumentException("Provided remote address is not an InetSocketAddress");
                    }
                    if (!(localAddress instanceof InetSocketAddress)) {
                        throw new IllegalArgumentException("Provided local address is not an InetSocketAddress");
                    }
                    Channel existingChild = RakNetServerChannel.this.getChildChannel(remoteAddress);
                    if (RakNetServerChannel.this.childMap.size() > RakNetServerChannel.this.config.getMaxConnections() && existingChild == null) {
                        NoFreeConnections packet = new NoFreeConnections(RakNetServerChannel.this.config.getMagic(), RakNetServerChannel.this.config.getServerId());
                        ByteBuf buf = ctx.alloc().ioBuffer(packet.sizeHint());
                        try {
                            RakNetServerChannel.this.config.getCodec().encode(packet, buf);
                            ctx.writeAndFlush((Object)new DatagramPacket(buf.retain(), (InetSocketAddress)remoteAddress));
                        }
                        finally {
                            ReferenceCountUtil.safeRelease((Object)packet);
                            buf.release();
                        }
                        promise.tryFailure((Throwable)new IllegalStateException("Too many connections"));
                        break block12;
                    }
                    if (existingChild == null) {
                        RakNetChildChannel child = RakNetServerChannel.this.newChild((InetSocketAddress)remoteAddress, (InetSocketAddress)localAddress, channel -> RakNetServerChannel.this.pipeline().fireChannelRead(channel).fireChannelReadComplete());
                        child.closeFuture().addListener(v -> RakNetServerChannel.this.eventLoop().execute(() -> RakNetServerChannel.this.removeChild(remoteAddress, child)));
                        child.config().setOption(RakNet.SERVER_ID, RakNetServerChannel.this.config.getServerId());
                        this.initChildChannel((Channel)child);
                        RakNetServerChannel.this.addChild(remoteAddress, child);
                        promise.trySuccess();
                    } else {
                        promise.trySuccess();
                    }
                }
                catch (Exception e) {
                    promise.tryFailure((Throwable)e);
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof DatagramPacket) {
                DatagramPacket datagram = (DatagramPacket)msg;
                try {
                    Channel child = (Channel)RakNetServerChannel.this.childMap.get(datagram.sender());
                    if (child == null && datagram.recipient() != null) {
                        ctx.fireChannelRead((Object)datagram.retain());
                        return;
                    }
                    if (child == null || !child.isOpen() || !child.config().isAutoRead()) return;
                    ByteBuf retained = ((ByteBuf)datagram.content()).retain();
                    child.eventLoop().execute(() -> child.pipeline().fireChannelRead((Object)retained).fireChannelReadComplete());
                    return;
                }
                finally {
                    datagram.release();
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            RakNetServerChannel.this.childMap.values().forEach(ch -> ch.pipeline().fireChannelWritabilityChanged());
            ctx.fireChannelWritabilityChanged();
        }

        private ChannelFuture initChildChannel(Channel child) {
            try {
                Class<?> acceptorClass = Class.forName("io.netty.bootstrap.ServerBootstrap$ServerBootstrapAcceptor");
                Field childGroupField = acceptorClass.getDeclaredField("childGroup");
                childGroupField.setAccessible(true);
                EventLoopGroup childGroup = (EventLoopGroup)childGroupField.get(RakNetServerChannel.this.pipeline().get(acceptorClass));
                return childGroup.register(child);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

