/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.server.channel.RakNetChildChannel;

public class RakNetApplicationChannel
extends AbstractChannel {
    public static final String NAME_SERVER_THREADED_WRITE_HANDLER = "rn-server-threaded-write-handler";
    public static final String NAME_SERVER_PARENT_THREADED_READ_HANDLER = "rn-server-parent-threaded-read-handler";

    protected RakNetApplicationChannel(RakNetChildChannel parent) {
        super((Channel)parent);
        this.pipeline().addLast(NAME_SERVER_THREADED_WRITE_HANDLER, (ChannelHandler)new WriteHandler());
    }

    public boolean isWritable() {
        Boolean result = (Boolean)this.attr(RakNet.WRITABLE).get();
        return (result == null || result != false) && this.parent().isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.parent().bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.parent().bytesBeforeWritable();
    }

    public RakNetChildChannel parent() {
        return (RakNetChildChannel)super.parent();
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new AbstractChannel.AbstractUnsafe(){

            public void connect(SocketAddress addr1, SocketAddress addr2, ChannelPromise pr) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean isCompatible(EventLoop eventloop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return this.parent().localAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.parent().remoteAddress();
    }

    protected void doBind(SocketAddress addr) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() {
        this.close();
        this.parent().close();
    }

    protected void doClose() {
        this.close();
        this.parent().close();
    }

    protected void doBeginRead() {
    }

    protected void doWrite(ChannelOutboundBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public RakNet.Config config() {
        return this.parent().config();
    }

    public boolean isOpen() {
        return this.parent().isOpen();
    }

    public boolean isActive() {
        return this.isOpen() && this.parent().isActive();
    }

    public ChannelMetadata metadata() {
        return this.parent().metadata();
    }

    public ChannelFuture close() {
        if (this.isRegistered()) {
            ChannelFuture close = super.close();
            ChannelPromise promise = this.newPromise();
            close.addListener(future -> this.parent().close().addListener(future1 -> {
                if (future1.isSuccess()) {
                    promise.setSuccess();
                } else {
                    promise.setFailure(future1.cause());
                }
            }));
            return promise;
        }
        return this.parent().close();
    }

    protected class WriteHandler
    extends ChannelOutboundHandlerAdapter {
        protected WriteHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ChannelFuture future = RakNetApplicationChannel.this.parent().write(msg);
            future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            future.addListener(future1 -> {
                if (future1.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future1.cause());
                }
            });
        }

        public void flush(ChannelHandlerContext ctx) {
            RakNetApplicationChannel.this.parent().flush();
        }

        public void read(ChannelHandlerContext ctx) {
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            RakNetApplicationChannel.this.parent().close().addListener(future -> {
                if (future.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future.cause());
                }
            });
        }
    }
}

