/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.ArrayList;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.SimplePacket;
import network.ycc.raknet.utils.UINT;

public class Reliability
extends SimplePacket
implements Packet {
    private static final REntry[] EMPTY = new REntry[0];
    private REntry[] entries;

    private Reliability() {
    }

    private Reliability(int id) {
        this.entries = new REntry[]{new REntry(id)};
    }

    private Reliability(IntSortedSet ids) {
        this.entries = EMPTY;
        if (ids.isEmpty()) {
            return;
        }
        ArrayList<REntry> res = new ArrayList<REntry>();
        int startId = -1;
        int endId = -1;
        IntBidirectionalIterator intBidirectionalIterator = ids.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int i = (Integer)intBidirectionalIterator.next();
            if (startId == -1) {
                startId = i;
                endId = i;
                continue;
            }
            if (i == UINT.B3.plus(endId, 1)) {
                endId = i;
                continue;
            }
            res.add(new REntry(startId, endId));
            startId = i;
            endId = i;
        }
        res.add(new REntry(startId, endId));
        this.entries = res.toArray(this.entries);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeShort(this.entries.length);
        for (REntry entry : this.entries) {
            if (entry.idStart == entry.idFinish) {
                buf.writeBoolean(true);
                buf.writeMediumLE(entry.idStart);
                continue;
            }
            buf.writeBoolean(false);
            buf.writeMediumLE(entry.idStart);
            buf.writeMediumLE(entry.idFinish);
        }
    }

    @Override
    public void decode(ByteBuf buf) {
        this.entries = new REntry[buf.readUnsignedShort()];
        for (int i = 0; i < this.entries.length; ++i) {
            boolean single = buf.readBoolean();
            this.entries[i] = single ? new REntry(buf.readUnsignedMediumLE()) : new REntry(buf.readUnsignedMediumLE(), buf.readUnsignedMediumLE());
        }
    }

    public REntry[] getEntries() {
        return this.entries;
    }

    public static class NACK
    extends Reliability {
        public NACK() {
        }

        public NACK(int id) {
            super(id);
        }

        public NACK(IntSortedSet ids) {
            super(ids);
        }
    }

    public static class ACK
    extends Reliability {
        public ACK() {
        }

        public ACK(int id) {
            super(id);
        }

        public ACK(IntSortedSet ids) {
            super(ids);
        }
    }

    public static class REntry {
        public final int idStart;
        public final int idFinish;

        public REntry(int id) {
            this(id, id);
        }

        public REntry(int idstart, int idfinish) {
            this.idStart = idstart;
            this.idFinish = idfinish;
        }
    }
}

