/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.client.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.client.channel.RakNetClientChannel;

public class RakNetClientThreadedChannel
extends AbstractChannel {
    public static final String NAME_CLIENT_THREADED_WRITE_HANDLER = "rn-client-threaded-write-handler";
    public static final String NAME_CLIENT_PARENT_THREADED_READ_HANDLER = "rn-client-parent-threaded-read-handler";
    private EventLoop providedEventLoop = null;
    private EventLoop pendingEventLoop = null;

    public RakNetClientThreadedChannel() {
        super((Channel)new RakNetClientChannel());
        this.setupDefaultPipeline();
    }

    public RakNetClientThreadedChannel(Class<? extends DatagramChannel> ioChannelType) {
        super((Channel)new RakNetClientChannel(ioChannelType));
        this.setupDefaultPipeline();
    }

    public RakNetClientThreadedChannel(Supplier<? extends DatagramChannel> ioChannelSupplier) {
        super((Channel)new RakNetClientChannel(ioChannelSupplier));
        this.setupDefaultPipeline();
    }

    public void setProvidedEventLoop(EventLoop providedEventLoop) {
        this.providedEventLoop = providedEventLoop;
    }

    private void setupDefaultPipeline() {
        this.pipeline().addLast(NAME_CLIENT_THREADED_WRITE_HANDLER, (ChannelHandler)new WriteHandler());
        this.parent().pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(RakNetClientThreadedChannel.NAME_CLIENT_PARENT_THREADED_READ_HANDLER, (ChannelHandler)new ParentReadHandler());
            }
        }});
    }

    public boolean isWritable() {
        Boolean result = (Boolean)this.attr(RakNet.WRITABLE).get();
        return (result == null || result != false) && this.parent().isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.parent().bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.parent().bytesBeforeWritable();
    }

    public RakNetClientChannel parent() {
        return (RakNetClientChannel)super.parent();
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new AbstractChannel.AbstractUnsafe(){

            public void connect(SocketAddress addr1, SocketAddress addr2, ChannelPromise pr) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean isCompatible(EventLoop eventloop) {
        this.pendingEventLoop = eventloop;
        return true;
    }

    protected SocketAddress localAddress0() {
        return this.parent().localAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.parent().remoteAddress();
    }

    protected void doBind(SocketAddress addr) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() {
        this.close();
        this.parent().close();
    }

    protected void doClose() {
        this.close();
        this.parent().close();
    }

    protected void doBeginRead() {
    }

    protected void doWrite(ChannelOutboundBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public RakNet.Config config() {
        return this.parent().config();
    }

    public boolean isOpen() {
        return this.parent().isOpen();
    }

    public boolean isActive() {
        return this.isOpen() && this.parent().isActive();
    }

    public ChannelMetadata metadata() {
        return this.parent().metadata();
    }

    public ChannelFuture close() {
        ChannelFuture close = super.close();
        ChannelPromise promise = this.newPromise();
        close.addListener(future -> this.parent().close().addListener(future1 -> {
            if (future1.isSuccess()) {
                promise.setSuccess();
            } else {
                promise.setFailure(future1.cause());
            }
        }));
        return promise;
    }

    private void registerParent() {
        if (!this.parent().isRegistered()) {
            EventLoop loop;
            EventLoop eventLoop = loop = this.providedEventLoop != null ? this.providedEventLoop : this.pendingEventLoop;
            if (loop == null) {
                throw new IllegalStateException("channel not registered");
            }
            loop.register((Channel)this.parent());
        }
    }

    protected class ParentReadHandler
    extends ChannelInboundHandlerAdapter {
        protected ParentReadHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelInactive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelRead(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelReadComplete();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            RakNetClientThreadedChannel.this.pipeline().fireUserEventTriggered(evt);
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelWritabilityChanged();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            RakNetClientThreadedChannel.this.pipeline().fireExceptionCaught(cause);
        }
    }

    protected class WriteHandler
    extends ChannelOutboundHandlerAdapter {
        protected WriteHandler() {
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            RakNetClientThreadedChannel.this.registerParent();
            ChannelFuture future = RakNetClientThreadedChannel.this.parent().bind(localAddress);
            future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            future.addListener(future1 -> {
                if (future1.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future1.cause());
                }
            });
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            RakNetClientThreadedChannel.this.registerParent();
            ChannelFuture future = RakNetClientThreadedChannel.this.parent().connect(remoteAddress, localAddress);
            future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            future.addListener(future1 -> {
                if (future1.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future1.cause());
                }
            });
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ChannelFuture future = RakNetClientThreadedChannel.this.parent().write(msg);
            future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            future.addListener(future1 -> {
                if (future1.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future1.cause());
                }
            });
        }

        public void flush(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.parent().flush();
        }

        public void read(ChannelHandlerContext ctx) {
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            RakNetClientThreadedChannel.this.parent().close().addListener(future -> {
                if (future.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future.cause());
                }
            });
        }
    }
}

