/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultConfig;

public class DatagramChannelProxy
implements Channel {
    public static final String LISTENER_HANDLER_NAME = "rn-udp-listener-handler";
    protected final DefaultChannelPipeline pipeline;
    protected final DatagramChannel listener;
    protected final Config config;

    public DatagramChannelProxy(Supplier<? extends DatagramChannel> ioChannelSupplier) {
        this.listener = ioChannelSupplier.get();
        this.pipeline = this.newChannelPipeline();
        this.listener.pipeline().addLast(LISTENER_HANDLER_NAME, (ChannelHandler)new ListenerInboundProxy());
        this.pipeline().addLast(LISTENER_HANDLER_NAME, (ChannelHandler)new ListnerOutboundProxy()).addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true)});
        this.config = new Config();
    }

    public DatagramChannelProxy(Class<? extends DatagramChannel> ioChannelType) {
        this(() -> {
            try {
                return (DatagramChannel)ioChannelType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to create instance", e);
            }
        });
    }

    public ChannelId id() {
        return this.listener.id();
    }

    public EventLoop eventLoop() {
        return this.listener.eventLoop();
    }

    public Channel parent() {
        return this.listener;
    }

    public RakNet.Config config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.listener.isOpen();
    }

    public boolean isRegistered() {
        return this.listener.isRegistered();
    }

    public boolean isActive() {
        return this.listener.isActive();
    }

    public ChannelMetadata metadata() {
        return this.listener.metadata();
    }

    public SocketAddress localAddress() {
        return this.listener.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.listener.remoteAddress();
    }

    public ChannelFuture closeFuture() {
        return this.listener.closeFuture();
    }

    public boolean isWritable() {
        return this.listener.isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.listener.bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.listener.bytesBeforeWritable();
    }

    public Channel.Unsafe unsafe() {
        return this.listener.unsafe();
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    public Channel read() {
        return this;
    }

    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.pipeline.bind(localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.pipeline.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.pipeline.connect(remoteAddress, localAddress);
    }

    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    public ChannelFuture close() {
        return this.pipeline.close();
    }

    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline.bind(localAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.pipeline.connect(remoteAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline.connect(remoteAddress, localAddress, promise);
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.pipeline.disconnect(promise);
    }

    public ChannelFuture close(ChannelPromise promise) {
        return this.pipeline.close(promise);
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return this.pipeline.deregister(promise);
    }

    public ChannelFuture write(Object msg) {
        return this.pipeline.write(msg);
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.pipeline.write(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.pipeline.writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.pipeline.writeAndFlush(msg);
    }

    public ChannelPromise newPromise() {
        return this.pipeline.newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline.newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.pipeline.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.pipeline.newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.listener.attr(key);
    }

    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.listener.hasAttr(key);
    }

    public int compareTo(Channel o) {
        return this.listener.compareTo((Object)o);
    }

    protected void gracefulClose(ChannelPromise promise) {
        this.listener.close(this.wrapPromise(promise));
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this){

            protected void onUnhandledInboundException(Throwable cause) {
                if (cause instanceof ClosedChannelException) {
                    ReferenceCountUtil.safeRelease((Object)cause);
                    return;
                }
                super.onUnhandledInboundException(cause);
            }
        };
    }

    protected ChannelPromise wrapPromise(ChannelPromise in) {
        ChannelPromise out = this.listener.newPromise();
        out.addListener(res -> {
            if (res.isSuccess()) {
                in.trySuccess();
            } else {
                in.tryFailure(res.cause());
            }
        });
        return out;
    }

    protected class ListenerInboundProxy
    implements ChannelInboundHandler {
        protected ListenerInboundProxy() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            DatagramChannelProxy.this.pipeline.fireChannelRegistered();
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            DatagramChannelProxy.this.pipeline.fireChannelUnregistered();
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            assert (DatagramChannelProxy.this.listener.eventLoop().inEventLoop());
        }

        public void channelActive(ChannelHandlerContext ctx) {
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            DatagramChannelProxy.this.pipeline.fireChannelInactive();
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            DatagramChannelProxy.this.pipeline.fireChannelRead(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            DatagramChannelProxy.this.pipeline.fireChannelReadComplete();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            DatagramChannelProxy.this.pipeline.fireChannelWritabilityChanged();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof ClosedChannelException) {
                return;
            }
            DatagramChannelProxy.this.pipeline.fireExceptionCaught(cause);
        }
    }

    protected class ListnerOutboundProxy
    implements ChannelOutboundHandler {
        protected ListnerOutboundProxy() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            assert (DatagramChannelProxy.this.listener.eventLoop().inEventLoop());
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            DatagramChannelProxy.this.listener.bind(localAddress, DatagramChannelProxy.this.wrapPromise(promise));
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            DatagramChannelProxy.this.listener.connect(remoteAddress, localAddress, DatagramChannelProxy.this.wrapPromise(promise));
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            DatagramChannelProxy.this.listener.disconnect(DatagramChannelProxy.this.wrapPromise(promise));
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            DatagramChannelProxy.this.gracefulClose(promise);
        }

        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            DatagramChannelProxy.this.listener.deregister(DatagramChannelProxy.this.wrapPromise(promise));
        }

        public void read(ChannelHandlerContext ctx) {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            DatagramChannelProxy.this.listener.write(msg, DatagramChannelProxy.this.wrapPromise(promise));
        }

        public void flush(ChannelHandlerContext ctx) {
            DatagramChannelProxy.this.listener.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof NoRouteToHostException) {
                return;
            }
            ctx.fireExceptionCaught(cause);
        }
    }

    protected class Config
    extends DefaultConfig {
        protected Config() {
            super(DatagramChannelProxy.this);
        }

        @Override
        public <T> T getOption(ChannelOption<T> option) {
            T thisOption = super.getOption(option);
            if (thisOption == null) {
                return (T)DatagramChannelProxy.this.listener.config().getOption(option);
            }
            return thisOption;
        }

        @Override
        public <T> boolean setOption(ChannelOption<T> option, T value) {
            boolean thisOption = super.setOption(option, value);
            boolean listenOption = DatagramChannelProxy.this.listener.config().setOption(option, value);
            return thisOption || listenOption;
        }
    }
}

