/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.fabric.common.connection;

import com.ishland.raknetify.common.connection.RakNetConnectionUtil;
import com.ishland.raknetify.common.connection.RakNetSimpleMultiChannelCodec;
import com.ishland.raknetify.fabric.common.compat.viafabric.ViaFabricCompatInjector;
import com.ishland.raknetify.fabric.common.connection.MultiChannellingPacketCapture;
import com.ishland.raknetify.fabric.common.connection.RakNetCompressionCompatibilityHandler;
import com.ishland.raknetify.fabric.common.connection.RakNetFabricChannelEventListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import network.ycc.raknet.RakNet;

public class RakNetFabricConnectionUtil {
    private RakNetFabricConnectionUtil() {
    }

    public static void initChannel(Channel channel) {
        if (channel.config() instanceof RakNet.Config) {
            RakNetConnectionUtil.initChannel(channel);
            channel.pipeline().addAfter("raknetify-multichannel-streaming-compression", "raknetify-simple-multi-channel-data-codec", (ChannelHandler)new RakNetSimpleMultiChannelCodec(253));
        }
    }

    public static void postInitChannel(Channel channel, boolean isClientSide) {
        if (channel.config() instanceof RakNet.Config) {
            ViaFabricCompatInjector.inject(channel, isClientSide);
            channel.pipeline().replace("timeout", "timeout", (ChannelHandler)new ChannelDuplexHandler());
            channel.pipeline().replace("splitter", "splitter", (ChannelHandler)new ChannelDuplexHandler());
            channel.pipeline().replace("prepender", "prepender", (ChannelHandler)new ChannelDuplexHandler());
            MultiChannellingPacketCapture handler = new MultiChannellingPacketCapture();
            if (channel.pipeline().names().contains("unbundler")) {
                channel.pipeline().addBefore("unbundler", "raknetify-multi-channel-packet-cature", (ChannelHandler)handler);
            } else {
                channel.pipeline().addLast("raknetify-multi-channel-packet-cature", (ChannelHandler)handler);
            }
            ((RakNetSimpleMultiChannelCodec)channel.pipeline().get(RakNetSimpleMultiChannelCodec.class)).addHandler(handler.getCustomPayloadHandler()).addHandler(handler.getCaptureBasedHandler());
            channel.pipeline().addLast("raknetify-handle-compression-compatibility", (ChannelHandler)new RakNetCompressionCompatibilityHandler());
            channel.pipeline().addBefore("packet_handler", "raknetify-fabric-event-listener", (ChannelHandler)new RakNetFabricChannelEventListener());
        }
    }
}

