/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.fabric.common.compat.viafabric;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.lang.reflect.Constructor;
import net.fabricmc.loader.api.FabricLoader;

public class ViaFabricCompatInjector {
    public static void inject(Channel channel, boolean isClientSide) {
        Preconditions.checkNotNull((Object)channel);
        if (FabricLoader.getInstance().isModLoaded("viafabric")) {
            try {
                Class<?> userConnectionImplClass = Class.forName("com.viaversion.viaversion.connection.UserConnectionImpl");
                Constructor<?> userConnectionImplConstructor = userConnectionImplClass.getConstructor(Channel.class, Boolean.TYPE);
                Object user = userConnectionImplConstructor.newInstance(channel, isClientSide);
                Class<?> userConnectionClass = Class.forName("com.viaversion.viaversion.api.connection.UserConnection");
                Class<?> protocolPipelineImplClass = Class.forName("com.viaversion.viaversion.protocol.ProtocolPipelineImpl");
                protocolPipelineImplClass.getConstructor(userConnectionClass).newInstance(user);
                Class<?> commonTransformerClass = Class.forName("com.viaversion.fabric.common.handler.CommonTransformer");
                String handlerEncoderName = (String)commonTransformerClass.getField("HANDLER_ENCODER_NAME").get(null);
                String handlerDecoderName = (String)commonTransformerClass.getField("HANDLER_DECODER_NAME").get(null);
                Class<?> fabricEncodeHandlerClass = Class.forName("com.viaversion.fabric.common.handler.FabricEncodeHandler");
                MessageToMessageEncoder fabricEncodeHandler = (MessageToMessageEncoder)fabricEncodeHandlerClass.getConstructor(userConnectionClass).newInstance(user);
                Class<?> fabricDecodeHandlerClass = Class.forName("com.viaversion.fabric.common.handler.FabricDecodeHandler");
                MessageToMessageDecoder fabricDecodeHandler = (MessageToMessageDecoder)fabricDecodeHandlerClass.getConstructor(userConnectionClass).newInstance(user);
                channel.pipeline().addBefore("encoder", handlerEncoderName, (ChannelHandler)fabricEncodeHandler);
                channel.pipeline().addBefore("decoder", handlerDecoderName, (ChannelHandler)fabricDecodeHandler);
            }
            catch (Throwable t) {
                System.err.println(String.format("Raknetify: Could not inject ViaVersion compatibility into RakNet channel %s: %s", channel, t));
                t.printStackTrace();
            }
        }
    }
}

