/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ishland.raknetify.common.data.ProtocolMultiChannelMappings;
import com.ishland.raknetify.common.util.NetworkInterfaceListener;
import com.ishland.raknetify.fabric.common.connection.RakNetMultiChannel;
import com.ishland.raknetify.fabric.common.util.FieldSignatureParser;
import com.ishland.raknetify.fabric.common.util.MultiVersionUtil;
import com.ishland.raknetify.fabric.mixin.RaknetifyFabricMixinPlugin;
import com.ishland.raknetify.fabric.mixin.access.INetworkState1_20_4;
import com.ishland.raknetify.fabric.mixin.access.INetworkStateInternalPacketHandler;
import com.ishland.raknetify.fabric.mixin.access.IPacketCodecDispatcher;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.SystemPropertyUtil;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.minecraft.class_155;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_9089;
import net.minecraft.class_9094;
import net.minecraft.class_9095;
import net.minecraft.class_9100;
import net.minecraft.class_9129;
import net.minecraft.class_9145;
import net.minecraft.class_9152;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.service.MixinService;

public class RaknetifyFabric
implements ModInitializer,
PreLaunchEntrypoint {
    private static final boolean SAVE_CHANNEL_MAPPINGS = Boolean.getBoolean("raknetify.saveChannelMappings");
    private static final boolean EXIT_AFTER_SAVE_CHANNEL_MAPPINGS = Boolean.getBoolean("raknetify.saveChannelMappings.exit");
    private static final boolean HANDLE_MAPPINGS_ON_PRELAUNCH = Boolean.getBoolean("raknetify.handleMappingsOnPreLaunch");

    public void onPreLaunch() {
        MultiVersionUtil.init();
        if (HANDLE_MAPPINGS_ON_PRELAUNCH) {
            RaknetifyFabric.handleMappings();
        }
    }

    public void onInitialize() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            RaknetifyFabric.auditMixins();
        }
        if (!HANDLE_MAPPINGS_ON_PRELAUNCH) {
            RaknetifyFabric.handleMappings();
        }
        String levelStr = SystemPropertyUtil.get((String)"io.netty.leakDetection.level", (String)ResourceLeakDetector.Level.SIMPLE.name());
        ResourceLeakDetector.Level level = ResourceLeakDetector.Level.SIMPLE;
        try {
            level = ResourceLeakDetector.Level.valueOf((String)levelStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.out.println("Raknetify: Using leak detector level %s".formatted(level));
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
    }

    private static void handleMappings() {
        RakNetMultiChannel.init();
        NetworkInterfaceListener.init();
        Int2IntArrayMap s2c = new Int2IntArrayMap();
        Int2IntArrayMap c2s = new Int2IntArrayMap();
        if (!RaknetifyFabricMixinPlugin.POST_1_20_5) {
            for (Map.Entry<class_2598, ?> entry2 : ((INetworkState1_20_4)class_2539.field_20591).getPacketHandlers().entrySet()) {
                Object value = entry2.getValue();
                Object2IntMap<Class<? extends class_2596<?>>> packetIds = RaknetifyFabric.getPacketIdsFromPacketHandler(value);
                for (Object2IntMap.Entry type : packetIds.object2IntEntrySet()) {
                    if (entry2.getKey() == class_2598.field_11942) {
                        s2c.put(type.getIntValue(), RakNetMultiChannel.getPacketChannelOverride((Class)type.getKey()));
                        continue;
                    }
                    if (entry2.getKey() != class_2598.field_11941) continue;
                    c2s.put(type.getIntValue(), RakNetMultiChannel.getPacketChannelOverride((Class)type.getKey()));
                }
            }
        } else {
            Class clazz2;
            int i;
            List<class_9145> c2sPacketTypes = ((IPacketCodecDispatcher)class_9095.field_48172.bind(class_9129.method_56350(null)).comp_2236()).getPacketTypes().stream().map(byteBufPacketPacketTypePacketType -> (class_9145)byteBufPacketPacketTypePacketType.comp_2229()).toList();
            List<class_9145> s2cPacketTypes = ((IPacketCodecDispatcher)class_9095.field_48173.bind(class_9129.method_56350(null)).comp_2236()).getPacketTypes().stream().map(byteBufPacketPacketTypePacketType -> (class_9145)byteBufPacketPacketTypePacketType.comp_2229()).toList();
            Object2ObjectOpenHashMap vanillaPacketTypes = new Object2ObjectOpenHashMap();
            record FieldNodeClazzPair(FieldNode fieldNode, Class<?> clazz) {
            }
            for (FieldNodeClazzPair fieldNodeClazzPair : Stream.of(class_9094.class, class_9152.class, class_9089.class, class_9100.class).flatMap(clazz -> {
                try {
                    return MixinService.getService().getBytecodeProvider().getClassNode((String)Type.getInternalName((Class)clazz)).fields.stream().map(fieldNode -> new FieldNodeClazzPair((FieldNode)fieldNode, (Class<?>)clazz));
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).toList()) {
                FieldNode field = fieldNodeClazzPair.fieldNode();
                List<Type> parameterGenerics = FieldSignatureParser.parse(field.signature);
                for (Type type : parameterGenerics) {
                    try {
                        class_9145 actualType;
                        Class<?> clazz3 = Class.forName(type.getClassName());
                        if (!class_2596.class.isAssignableFrom(clazz3)) continue;
                        try {
                            actualType = (class_9145)fieldNodeClazzPair.clazz().getField(field.name).get(null);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                        vanillaPacketTypes.put(actualType, clazz3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            int s2cPacketTypesSize = s2cPacketTypes.size();
            for (i = 0; i < s2cPacketTypesSize; ++i) {
                class_9145 s2cPacketType = s2cPacketTypes.get(i);
                clazz2 = (Class)vanillaPacketTypes.get(s2cPacketType);
                if (clazz2 == null) {
                    System.out.println("Skipping unmapped packet type: " + String.valueOf(s2cPacketType));
                    continue;
                }
                s2c.put(i, RakNetMultiChannel.getPacketChannelOverride(clazz2));
            }
            int c2sPacketTypesSize = c2sPacketTypes.size();
            for (i = 0; i < c2sPacketTypesSize; ++i) {
                class_9145 c2sPacketType = c2sPacketTypes.get(i);
                clazz2 = (Class)vanillaPacketTypes.get(c2sPacketType);
                if (clazz2 == null) {
                    System.out.println("Skipping unmapped packet type: " + String.valueOf(c2sPacketType));
                    continue;
                }
                c2s.put(i, RakNetMultiChannel.getPacketChannelOverride(clazz2));
            }
        }
        if (SAVE_CHANNEL_MAPPINGS) {
            RaknetifyFabric.auditMixins();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            ProtocolMultiChannelMappings mappings = new ProtocolMultiChannelMappings();
            Path path = Path.of("channelMappings.json", new String[0]);
            try {
                mappings = (ProtocolMultiChannelMappings)gson.fromJson(Files.readString(path), ProtocolMultiChannelMappings.class);
            }
            catch (IOException e) {
                System.out.println("Error reading previously generated mappings: " + e.toString());
            }
            ProtocolMultiChannelMappings.VersionMapping versionMapping = new ProtocolMultiChannelMappings.VersionMapping();
            versionMapping.c2s = c2s;
            versionMapping.s2c = s2c;
            mappings.mappings.put(class_155.method_31372(), (Object)versionMapping);
            mappings.mappings = mappings.mappings.int2ObjectEntrySet().stream().map(entry -> {
                ProtocolMultiChannelMappings.VersionMapping value = (ProtocolMultiChannelMappings.VersionMapping)entry.getValue();
                value.s2c = value.s2c.int2IntEntrySet().stream().sorted(Comparator.comparingInt(Int2IntMap.Entry::getIntKey)).collect(Collectors.toMap(Int2IntMap.Entry::getIntKey, Int2IntMap.Entry::getIntValue, (o, o2) -> {
                    throw new RuntimeException("Unresolvable conflicts");
                }, Int2IntArrayMap::new));
                value.c2s = value.c2s.int2IntEntrySet().stream().sorted(Comparator.comparingInt(Int2IntMap.Entry::getIntKey)).collect(Collectors.toMap(Int2IntMap.Entry::getIntKey, Int2IntMap.Entry::getIntValue, (o, o2) -> {
                    throw new RuntimeException("Unresolvable conflicts");
                }, Int2IntArrayMap::new));
                return new AbstractInt2ObjectMap.BasicEntry(entry.getIntKey(), (Object)value);
            }).sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).collect(Collectors.toMap(Int2ObjectMap.Entry::getIntKey, Map.Entry::getValue, (o, o2) -> {
                throw new RuntimeException("Unresolvable conflicts");
            }, Int2ObjectArrayMap::new));
            try {
                Files.writeString(path, (CharSequence)gson.toJson((Object)mappings), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                System.out.println("Error writing generated mappings: " + e.toString());
            }
            if (EXIT_AFTER_SAVE_CHANNEL_MAPPINGS) {
                System.exit(0);
            }
        }
    }

    public static Object2IntMap<Class<? extends class_2596<?>>> getPacketIdsFromPacketHandler(Object value) {
        Object2IntMap<Class<? extends class_2596<?>>> packetIds;
        if (value instanceof INetworkStateInternalPacketHandler) {
            packetIds = ((INetworkStateInternalPacketHandler)value).getPacketIds();
        } else if (MultiVersionUtil.clazzNetworkStatePacketHandler.isInstance(value)) {
            packetIds = MultiVersionUtil.NetworkStatePacketHandler$backingHandler1_20_2.get(value).getPacketIds();
        } else {
            throw new IllegalStateException("Unknown packet handler type: " + String.valueOf(value.getClass()));
        }
        return packetIds;
    }

    private static void auditMixins() {
        Logger auditLogger = LoggerFactory.getLogger((String)"Raknetify Mixin Audit");
        try {
            Class<?> transformerClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinTransformer");
            if (transformerClazz.isInstance(MixinEnvironment.getCurrentEnvironment().getActiveTransformer())) {
                Field processorField = transformerClazz.getDeclaredField("processor");
                processorField.setAccessible(true);
                Object processor = processorField.get(MixinEnvironment.getCurrentEnvironment().getActiveTransformer());
                Class<?> processorClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinProcessor");
                Field configsField = processorClazz.getDeclaredField("configs");
                configsField.setAccessible(true);
                List configs = (List)configsField.get(processor);
                Class<?> configClazz = Class.forName("org.spongepowered.asm.mixin.transformer.MixinConfig");
                Method getUnhandledTargetsMethod = configClazz.getDeclaredMethod("getUnhandledTargets", new Class[0]);
                getUnhandledTargetsMethod.setAccessible(true);
                HashSet unhandled = new HashSet();
                for (Object config : configs) {
                    Set unhandledTargets = (Set)getUnhandledTargetsMethod.invoke(config, new Object[0]);
                    unhandled.addAll(unhandledTargets);
                }
                for (String s : unhandled) {
                    auditLogger.info("Loading class {}", (Object)s);
                    MixinService.getService().getClassProvider().findClass(s, false);
                }
                for (Object config : configs) {
                    for (String unhandledTarget : (Set)getUnhandledTargetsMethod.invoke(config, new Object[0])) {
                        auditLogger.error("{} is already classloaded", (Object)unhandledTarget);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to audit mixins", t);
        }
    }
}

