/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection.multichannel;

import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.RakNetSimpleMultiChannelCodec;
import com.ishland.raknetify.common.util.MathUtil;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.function.IntPredicate;

public class CustomPayloadChannel {
    public static final Object2IntOpenHashMap<String> identifier2channel = new Object2IntOpenHashMap();

    static {
        identifier2channel.defaultReturnValue(0);
        identifier2channel.put((Object)"porting_lib:extra_data_entity_spawn", 2);
    }

    public static class OverrideHandler
    implements RakNetSimpleMultiChannelCodec.OverrideHandler {
        private final IntPredicate isCustomPayload;

        public OverrideHandler(IntPredicate isCustomPayload) {
            this.isCustomPayload = Objects.requireNonNull(isCustomPayload);
        }

        @Override
        public int getChannelOverride(ByteBuf origBuf) {
            ByteBuf buf = origBuf.slice();
            int packetId = MathUtil.readVarInt(buf);
            if (this.isCustomPayload.test(packetId)) {
                String identifier = MathUtil.readString(buf);
                if (Constants.DEBUG) {
                    System.out.println("Raknetify: Handling custom payload: " + identifier);
                }
                return identifier2channel.getInt((Object)identifier);
            }
            return 0;
        }
    }
}

