/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.util.ReflectionUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.FrameSet;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.pipeline.FrameJoiner;
import network.ycc.raknet.pipeline.FrameOrderIn;
import network.ycc.raknet.pipeline.FrameOrderOut;
import network.ycc.raknet.pipeline.ReliabilityHandler;

public class SynchronizationLayer
extends ChannelDuplexHandler {
    public static final Object SYNC_REQUEST_OBJECT = new Object();
    static final Class<?> CLASS_QUEUE;
    static final Class<?> CLASS_FRAME_JOINER_BUILDER;
    static final Field FIELD_QUEUE_LAST_ORDER_INDEX;
    static final Method METHOD_QUEUE_BUILDER_RELEASE;
    static final Method METHOD_QUEUE_CLEAR;
    static final Field FIELD_RELIABILITY_NEXT_SEND_SEQ_ID;
    static final Field FIELD_RELIABILITY_LAST_RECEIVED_SEQ_ID;
    static final Field FIELD_RELIABILITY_QUEUED_BYTES;
    static final Field FIELD_FRAME_JOINER_BUILDER_SAMPLE_PACKET;
    private final IntSet channelToIgnore = new IntOpenHashSet();
    private FrameOrderIn frameOrderIn;
    private Object[] frameOrderInQueues;
    private FrameOrderOut frameOrderOut;
    private int[] frameOrderOutNextOrderIndex;
    private ReliabilityHandler reliabilityHandler;
    private PriorityQueue<Frame> reliabilityHandlerFrameQueue;
    private Int2ObjectMap<FrameSet> reliabilityHandlerPendingFrameSets;
    private FrameJoiner frameJoiner;
    private Int2ObjectOpenHashMap<?> frameJoinerPendingPackets;
    private int channelsLength;
    private boolean initialized = false;
    private final Reference2ReferenceLinkedOpenHashMap<ChannelPromise, Object> queue = new Reference2ReferenceLinkedOpenHashMap();
    private final ObjectArrayList<Frame> queuedFrames = new ObjectArrayList();
    private boolean isWaitingForResponse = false;

    public SynchronizationLayer(int ... channelsToIgnore) {
        for (int ch : channelsToIgnore) {
            this.channelToIgnore.add(ch);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.initializeIfNecessary(ctx);
    }

    private void initializeIfNecessary(ChannelHandlerContext ctx) {
        if (this.initialized) {
            return;
        }
        try {
            this.frameOrderIn = (FrameOrderIn)ctx.pipeline().get(FrameOrderIn.class);
            Object frameOrderInQueueArray = ReflectionUtil.accessible(FrameOrderIn.class.getDeclaredField("channels")).get((Object)this.frameOrderIn);
            this.frameOrderInQueues = new Object[Array.getLength(frameOrderInQueueArray)];
            for (int i = 0; i < this.frameOrderInQueues.length; ++i) {
                this.frameOrderInQueues[i] = Array.get(frameOrderInQueueArray, i);
            }
            this.frameOrderOut = (FrameOrderOut)ctx.pipeline().get(FrameOrderOut.class);
            this.frameOrderOutNextOrderIndex = (int[])ReflectionUtil.accessible(FrameOrderOut.class.getDeclaredField("nextOrderIndex")).get((Object)this.frameOrderOut);
            this.reliabilityHandler = (ReliabilityHandler)ctx.pipeline().get(ReliabilityHandler.class);
            this.reliabilityHandlerFrameQueue = (PriorityQueue)ReflectionUtil.accessible(ReliabilityHandler.class.getDeclaredField("frameQueue")).get((Object)this.reliabilityHandler);
            this.reliabilityHandlerPendingFrameSets = (Int2ObjectMap)ReflectionUtil.accessible(ReliabilityHandler.class.getDeclaredField("pendingFrameSets")).get((Object)this.reliabilityHandler);
            int originalChannelsLength = this.frameOrderOutNextOrderIndex.length;
            this.channelsLength = (int)((long)originalChannelsLength - this.channelToIgnore.stream().filter(value -> value < originalChannelsLength).count());
            this.frameJoiner = (FrameJoiner)ctx.pipeline().get(FrameJoiner.class);
            this.frameJoinerPendingPackets = (Int2ObjectOpenHashMap)ReflectionUtil.accessible(FrameJoiner.class.getDeclaredField("pendingPackets")).get((Object)this.frameJoiner);
            this.initialized = true;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FrameData packet;
        this.initializeIfNecessary(ctx);
        if (msg instanceof FrameData && (packet = (FrameData)msg).getPacketId() == 252) {
            if (Constants.DEBUG) {
                System.out.println("Raknetify: Received sync packet");
            }
            ctx.fireChannelRead(SYNC_REQUEST_OBJECT);
            ByteBuf byteBuf = packet.createData().skipBytes(1);
            try {
                int count = byteBuf.readByte();
                for (int i = 0; i < count; ++i) {
                    byte channel = byteBuf.readByte();
                    int orderIndex = byteBuf.readInt();
                    if (Constants.DEBUG) {
                        System.out.println("Raknetify: Channel %d: %d -> %d".formatted(channel, (Integer)FIELD_QUEUE_LAST_ORDER_INDEX.get(this.frameOrderInQueues[channel]), orderIndex));
                    }
                    FIELD_QUEUE_LAST_ORDER_INDEX.set(this.frameOrderInQueues[channel], orderIndex);
                    ObjectIterator iterator = this.frameJoinerPendingPackets.values().iterator();
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        try {
                            Frame frame = (Frame)((Object)FIELD_FRAME_JOINER_BUILDER_SAMPLE_PACKET.get(next));
                            if (!frame.getReliability().isOrdered || frame.getOrderChannel() != channel) continue;
                            METHOD_QUEUE_BUILDER_RELEASE.invoke(next, new Object[0]);
                            iterator.remove();
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                int seqId = byteBuf.readInt();
                if (Constants.DEBUG) {
                    System.out.println("Raknetify: ReliabilityHandler: %d -> %d".formatted((int)((Integer)FIELD_RELIABILITY_LAST_RECEIVED_SEQ_ID.get((Object)this.reliabilityHandler)), seqId));
                }
                FIELD_RELIABILITY_LAST_RECEIVED_SEQ_ID.set((Object)this.reliabilityHandler, seqId);
            }
            finally {
                byteBuf.release();
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.initializeIfNecessary(ctx);
        if (msg == SYNC_REQUEST_OBJECT) {
            if (this.isWaitingForResponse) {
                return;
            }
            this.dropSenderPackets();
            ByteBuf byteBuf = ctx.alloc().buffer(1 + this.channelsLength * 5 + 4);
            byteBuf.writeByte(this.channelsLength);
            int frameOrderOutNextOrderIndexLength = this.frameOrderOutNextOrderIndex.length;
            for (int channel = 0; channel < frameOrderOutNextOrderIndexLength; ++channel) {
                if (this.channelToIgnore.contains(channel)) continue;
                int orderOutNextOrderIndex = this.frameOrderOutNextOrderIndex[channel];
                if (Constants.DEBUG) {
                    System.out.println("Raknetify: Writing sync packet: Channel %d: %d".formatted(channel, orderOutNextOrderIndex - 1));
                }
                byteBuf.writeByte(channel);
                byteBuf.writeInt(orderOutNextOrderIndex - 1);
            }
            int seqId = (Integer)FIELD_RELIABILITY_NEXT_SEND_SEQ_ID.get((Object)this.reliabilityHandler);
            if (Constants.DEBUG) {
                System.out.println("Raknetify: Writing sync packet: ReliabilityHandler: %d".formatted(seqId));
            }
            byteBuf.writeInt(seqId);
            FrameData frameData = FrameData.create(ctx.alloc(), 252, byteBuf);
            frameData.setReliability(FramedPacket.Reliability.RELIABLE);
            this.isWaitingForResponse = true;
            ctx.write((Object)frameData, promise).addListener(future -> this.flushQueue(ctx));
            byteBuf.release();
            return;
        }
        if (this.isWaitingForResponse) {
            this.queue.put((Object)promise, msg);
            return;
        }
        super.write(ctx, msg, promise);
    }

    private void dropSenderPackets() {
        int droppedFrames = 0;
        ArrayList<Frame> retainedFrameList = new ArrayList<Frame>();
        retainedFrameList.addAll(this.reliabilityHandlerFrameQueue);
        this.reliabilityHandlerFrameQueue.clear();
        for (FrameSet frameSet : this.reliabilityHandlerPendingFrameSets.values()) {
            frameSet.createFrames(retainedFrameList::add);
            frameSet.release();
        }
        this.reliabilityHandlerPendingFrameSets.clear();
        int byteSize = 0;
        Iterator iterator = retainedFrameList.iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)((Object)iterator.next());
            if (frame.getReliability().isOrdered && !this.channelToIgnore.contains(frame.getOrderChannel())) {
                ChannelPromise promise1 = frame.getPromise();
                if (promise1 != null) {
                    promise1.trySuccess();
                }
                iterator.remove();
                frame.release();
                ++droppedFrames;
                continue;
            }
            byteSize += frame.getRoughPacketSize();
        }
        this.queuedFrames.addAll(retainedFrameList);
        if (Constants.DEBUG) {
            System.out.println("Raknetify: Dropping %d frames".formatted(droppedFrames));
        }
        try {
            FIELD_RELIABILITY_QUEUED_BYTES.set((Object)this.reliabilityHandler, byteSize);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.reliabilityHandlerPendingFrameSets.clear();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.flush(ctx);
        super.exceptionCaught(ctx, cause);
    }

    private void flushQueue(ChannelHandlerContext ctx) {
        if (!this.isWaitingForResponse) {
            if (Constants.DEBUG) {
                System.out.println("Raknetify: Ignoring duplicate call to flushQueue()");
            }
            return;
        }
        if (!ctx.channel().eventLoop().inEventLoop()) {
            ctx.channel().eventLoop().execute(() -> this.flushQueue(ctx));
            return;
        }
        this.isWaitingForResponse = false;
        if (Constants.DEBUG) {
            System.out.println("Raknetify: Picking up %d queued frames".formatted(this.queuedFrames.size()));
        }
        this.reliabilityHandlerFrameQueue.addAll((Collection<Frame>)this.queuedFrames);
        this.queuedFrames.clear();
        if (Constants.DEBUG) {
            System.out.println("Raknetify: Flushing %d queued packets as synchronization finished".formatted(this.queue.size()));
        }
        while (!this.queue.isEmpty()) {
            ChannelPromise promise = (ChannelPromise)this.queue.firstKey();
            Object msg = this.queue.removeFirst();
            ctx.write(msg, promise);
        }
    }

    static {
        try {
            CLASS_QUEUE = Class.forName("network.ycc.raknet.pipeline.FrameOrderIn$OrderedChannelPacketQueue");
            CLASS_FRAME_JOINER_BUILDER = Class.forName("network.ycc.raknet.pipeline.FrameJoiner$Builder");
            FIELD_QUEUE_LAST_ORDER_INDEX = ReflectionUtil.accessible(CLASS_QUEUE.getDeclaredField("lastOrderIndex"));
            FIELD_RELIABILITY_NEXT_SEND_SEQ_ID = ReflectionUtil.accessible(ReliabilityHandler.class.getDeclaredField("nextSendSeqId"));
            FIELD_RELIABILITY_LAST_RECEIVED_SEQ_ID = ReflectionUtil.accessible(ReliabilityHandler.class.getDeclaredField("lastReceivedSeqId"));
            FIELD_RELIABILITY_QUEUED_BYTES = ReflectionUtil.accessible(ReliabilityHandler.class.getDeclaredField("queuedBytes"));
            FIELD_FRAME_JOINER_BUILDER_SAMPLE_PACKET = ReflectionUtil.accessible(CLASS_FRAME_JOINER_BUILDER.getDeclaredField("samplePacket"));
            METHOD_QUEUE_BUILDER_RELEASE = ReflectionUtil.accessible(CLASS_FRAME_JOINER_BUILDER.getDeclaredMethod("release", new Class[0]));
            METHOD_QUEUE_CLEAR = ReflectionUtil.accessible(CLASS_QUEUE.getDeclaredMethod("clear", new Class[0]));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

