/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.connection.MetricsSynchronizationHandler;
import com.ishland.raknetify.common.util.MathUtil;
import network.ycc.raknet.RakNet;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class SimpleMetricsLogger
implements RakNet.MetricsLogger {
    private volatile long packetsIn = 0L;
    private volatile long framesIn = 0L;
    private volatile long framesError = 0L;
    private volatile long bytesIn = 0L;
    private volatile long packetsOut = 0L;
    private volatile long framesOut = 0L;
    private volatile long bytesOut = 0L;
    private volatile long bytesRecalled = 0L;
    private volatile long bytesACKd = 0L;
    private volatile long bytesNACKd = 0L;
    private volatile long acksSent = 0L;
    private volatile long nacksSent = 0L;
    private volatile long measureRTTns = 0L;
    private volatile long measureRTTnsStdDev = 0L;
    private volatile long measureBurstTokens = 0L;
    private volatile int currentQueuedBytes = 0;
    private long lastMeasureMillis = System.currentTimeMillis();
    private final DescriptiveStatistics errorStats = new DescriptiveStatistics(16);
    private long lastBytesTotal = 0L;
    private long lastBytesRecalled = 0L;
    private volatile double measureErrorRate = 0.0;
    private final DescriptiveStatistics rxStats = new DescriptiveStatistics(8);
    private final DescriptiveStatistics txStats = new DescriptiveStatistics(8);
    private long lastPacketsIn = 0L;
    private long lastPacketsOut = 0L;
    private long lastBytesIn = 0L;
    private long lastBytesOut = 0L;
    private volatile int measureRX = 0;
    private volatile int measureTX = 0;
    private volatile long measureBytesInRate = 0L;
    private volatile long measureBytesOutRate = 0L;
    private volatile String measureTrafficInFormatted = "...";
    private volatile String measureTrafficOutFormatted = "...";
    private MetricsSynchronizationHandler metricsSynchronizationHandler;

    @Override
    public void packetsIn(int delta) {
        this.packetsIn += (long)delta;
    }

    @Override
    public void framesIn(int delta) {
        this.framesIn += (long)delta;
    }

    @Override
    public void frameError(int delta) {
        this.framesError += (long)delta;
    }

    @Override
    public void bytesIn(int delta) {
        this.bytesIn += (long)delta;
    }

    @Override
    public void packetsOut(int delta) {
        this.packetsOut += (long)delta;
    }

    @Override
    public void framesOut(int delta) {
        this.framesOut += (long)delta;
    }

    @Override
    public void bytesOut(int delta) {
        this.bytesOut += (long)delta;
        this.tick();
    }

    @Override
    public void bytesRecalled(int delta) {
        this.bytesRecalled += (long)delta;
    }

    @Override
    public void bytesACKd(int delta) {
        this.bytesACKd += (long)delta;
    }

    @Override
    public void bytesNACKd(int delta) {
        this.bytesNACKd += (long)delta;
    }

    @Override
    public void acksSent(int delta) {
        this.acksSent += (long)delta;
    }

    @Override
    public void nacksSent(int delta) {
        this.nacksSent += (long)delta;
    }

    @Override
    public void measureRTTns(long n) {
        this.measureRTTns = n;
    }

    @Override
    public void measureRTTnsStdDev(long n) {
        this.measureRTTnsStdDev = n;
        this.tick();
    }

    @Override
    public void measureBurstTokens(int n) {
        this.measureBurstTokens = n;
    }

    @Override
    public void currentQueuedBytes(int bytes) {
        this.currentQueuedBytes = bytes;
    }

    private synchronized void tick() {
        long measureMillis = System.currentTimeMillis();
        long deltaTime = measureMillis - this.lastMeasureMillis;
        if (deltaTime < 990L) {
            return;
        }
        this.lastMeasureMillis = measureMillis;
        this.tickErrorRate();
        this.tickRXTX(deltaTime);
    }

    private void tickErrorRate() {
        long bytesTotal = this.bytesIn + this.bytesOut;
        long bytesRecalled = this.bytesRecalled;
        long bytesTotalDelta = bytesTotal - this.lastBytesTotal;
        long bytesRecalledDelta = bytesRecalled - this.lastBytesRecalled;
        if (bytesTotalDelta != 0L) {
            this.errorStats.addValue((double)bytesRecalledDelta / (double)bytesTotalDelta);
            this.measureErrorRate = this.errorStats.getMean();
        }
        this.lastBytesTotal = bytesTotal;
        this.lastBytesRecalled = bytesRecalled;
    }

    private void tickRXTX(long deltaTime) {
        long packetsIn = this.packetsIn;
        long packetsOut = this.packetsOut;
        long bytesIn = this.bytesIn;
        long bytesOut = this.bytesOut;
        double timeDeltaS = (double)deltaTime / 1000.0;
        this.rxStats.addValue((double)(packetsIn - this.lastPacketsIn) / timeDeltaS);
        this.txStats.addValue((double)(packetsOut - this.lastPacketsOut) / timeDeltaS);
        this.measureRX = (int)this.rxStats.getMean();
        this.measureTX = (int)this.txStats.getMean();
        this.measureBytesInRate = (long)((double)(bytesIn - this.lastBytesIn) / timeDeltaS);
        this.measureBytesOutRate = (long)((double)(bytesOut - this.lastBytesOut) / timeDeltaS);
        this.measureTrafficInFormatted = MathUtil.humanReadableByteCountBin(this.measureBytesInRate) + "/s";
        this.measureTrafficOutFormatted = MathUtil.humanReadableByteCountBin(this.measureBytesOutRate) + "/s";
        this.lastPacketsIn = packetsIn;
        this.lastPacketsOut = packetsOut;
        this.lastBytesIn = bytesIn;
        this.lastBytesOut = bytesOut;
    }

    public long getMeasureRTTns() {
        return this.measureRTTns;
    }

    public long getMeasureRTTnsStdDev() {
        return this.measureRTTnsStdDev;
    }

    public double getMeasureErrorRate() {
        return this.measureErrorRate;
    }

    public int getMeasureRX() {
        return this.measureRX;
    }

    public int getMeasureTX() {
        return this.measureTX;
    }

    public int getCurrentQueuedBytes() {
        return this.currentQueuedBytes;
    }

    public long getMeasureBurstTokens() {
        return this.measureBurstTokens;
    }

    public long getMeasureBytesInRate() {
        return this.measureBytesInRate;
    }

    public long getMeasureBytesOutRate() {
        return this.measureBytesOutRate;
    }

    public String getMeasureTrafficInFormatted() {
        return this.measureTrafficInFormatted;
    }

    public String getMeasureTrafficOutFormatted() {
        return this.measureTrafficOutFormatted;
    }

    public MetricsSynchronizationHandler getMetricsSynchronizationHandler() {
        return this.metricsSynchronizationHandler;
    }

    public void setMetricsSynchronizationHandler(MetricsSynchronizationHandler metricsSynchronizationHandler) {
        this.metricsSynchronizationHandler = metricsSynchronizationHandler;
    }
}

