/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import com.ishland.raknetify.common.util.MathUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.FramedPacket;

public class RakNetSimpleMultiChannelCodec
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-simple-multi-channel-data-codec";
    public static final Object SIGNAL_START_MULTICHANNEL = new Object();
    private final int packetId;
    private final ObjectArrayList<OverrideHandler> handlers = new ObjectArrayList();
    private boolean isMultichannelEnabled;
    private boolean queuePendingWrites = false;
    private final Queue<PendingWrite> pendingWrites = new LinkedList<PendingWrite>();

    public RakNetSimpleMultiChannelCodec(int packetId) {
        this.packetId = packetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RakNetSimpleMultiChannelCodec addHandler(OverrideHandler handler) {
        ObjectArrayList<OverrideHandler> objectArrayList = this.handlers;
        synchronized (objectArrayList) {
            this.handlers.add((Object)handler);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(OverrideHandler handler) {
        ObjectArrayList<OverrideHandler> objectArrayList = this.handlers;
        synchronized (objectArrayList) {
            this.handlers.remove((Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getHandler(Class<T> clazz) {
        ObjectArrayList<OverrideHandler> objectArrayList = this.handlers;
        synchronized (objectArrayList) {
            for (OverrideHandler handler : this.handlers) {
                if (!clazz.isInstance(handler)) continue;
                return clazz.cast(handler);
            }
        }
        return null;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        for (PendingWrite pendingWrite : this.pendingWrites) {
            pendingWrite.promise.setFailure((Throwable)new IllegalStateException("Channel closed"));
            pendingWrite.frameData.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buf;
        if (this.queuePendingWrites && msg instanceof ByteBuf) {
            ByteBuf buf2 = (ByteBuf)msg;
            FrameData data = this.encode0(ctx, buf2);
            if (data != null) {
                this.pendingWrites.add(new PendingWrite(data, promise));
                buf2.release();
            }
            return;
        }
        if (msg == SIGNAL_START_MULTICHANNEL) {
            if (this.isMultichannelEnabled) {
                return;
            }
            if (!this.isMultichannelAvailable()) {
                System.out.println("Raknetify: [MultiChannellingDataCodec] Failed to start multichannel: not available");
                return;
            }
            ByteBuf buf3 = ctx.alloc().buffer(1).writeByte(0);
            try {
                FrameData frameData = FrameData.create(ctx.alloc(), 250, buf3);
                frameData.setOrderChannel(7);
                this.queuePendingWrites = true;
                ctx.write((Object)frameData).addListener(future -> {
                    this.isMultichannelEnabled = true;
                    if (Constants.DEBUG) {
                        System.out.println("Raknetify: [MultiChannellingDataCodec] Started multichannel");
                    }
                    this.flushPendingWrites(ctx);
                });
            }
            finally {
                buf3.release();
            }
            promise.trySuccess();
            return;
        }
        if (msg == SynchronizationLayer.SYNC_REQUEST_OBJECT) {
            if (this.isMultichannelEnabled) {
                if (Constants.DEBUG) {
                    System.out.println("Raknetify: [MultiChannellingDataCodec] Stopped multichannel");
                }
                this.isMultichannelEnabled = false;
                super.write(ctx, msg, promise);
            }
            return;
        }
        if (msg instanceof ByteBuf && (buf = (ByteBuf)msg).isReadable()) {
            FrameData frameData = this.encode0(ctx, buf);
            if (frameData != null) {
                ctx.write((Object)frameData, promise);
            }
            buf.release();
            return;
        }
        super.write(ctx, msg, promise);
    }

    private FrameData encode0(ChannelHandlerContext ctx, ByteBuf buf) {
        if (buf.isReadable()) {
            int packetChannelOverride;
            int n = packetChannelOverride = this.isMultichannelEnabled ? this.getChannelOverride(buf) : 0;
            if (packetChannelOverride == Integer.MIN_VALUE) {
                return null;
            }
            FrameData frameData = FrameData.create(ctx.alloc(), this.packetId, buf);
            if (packetChannelOverride >= 0) {
                frameData.setOrderChannel(packetChannelOverride);
            } else if (packetChannelOverride == -1) {
                frameData.setReliability(FramedPacket.Reliability.RELIABLE);
            } else if (packetChannelOverride == -2) {
                frameData.setReliability(FramedPacket.Reliability.UNRELIABLE);
            }
            return frameData;
        }
        return null;
    }

    private void flushPendingWrites(ChannelHandlerContext ctx) {
        PendingWrite pendingWrite;
        this.queuePendingWrites = false;
        while ((pendingWrite = this.pendingWrites.poll()) != null) {
            try {
                super.write(ctx, (Object)pendingWrite.frameData, pendingWrite.promise);
            }
            catch (Throwable t) {
                ctx.fireExceptionCaught(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isMultichannelAvailable() {
        ObjectArrayList<OverrideHandler> objectArrayList = this.handlers;
        synchronized (objectArrayList) {
            return !this.handlers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getChannelOverride(ByteBuf buf) {
        ObjectArrayList<OverrideHandler> objectArrayList = this.handlers;
        synchronized (objectArrayList) {
            for (OverrideHandler handler : this.handlers) {
                int override = handler.getChannelOverride(buf);
                if (override == 0) continue;
                return override;
            }
        }
        return 0;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FrameData packet;
        if (msg instanceof FrameData && !(packet = (FrameData)msg).isFragment() && packet.getDataSize() > 0) {
            if (this.packetId == packet.getPacketId()) {
                ctx.fireChannelRead((Object)packet.createData().skipBytes(1));
            } else {
                if (packet.getPacketId() == 250) {
                    return;
                }
                ctx.fireChannelRead((Object)packet.retain());
            }
            packet.release();
            return;
        }
        super.channelRead(ctx, msg);
    }

    protected void decode(ChannelHandlerContext ctx, FrameData packet, List<Object> out) {
        assert (!packet.isFragment());
        if (packet.getDataSize() > 0) {
            if (this.packetId == packet.getPacketId()) {
                out.add(packet.createData().skipBytes(1));
            } else {
                if (packet.getPacketId() == 250) {
                    return;
                }
                out.add(packet.retain());
            }
        }
    }

    public static interface OverrideHandler {
        public int getChannelOverride(ByteBuf var1);
    }

    private record PendingWrite(FrameData frameData, ChannelPromise promise) {
    }

    public static class PacketIdBasedOverrideHandler
    implements OverrideHandler {
        private final IntOpenHashSet unknownPacketIds = new IntOpenHashSet();
        private final Int2IntOpenHashMap channelMapping;
        private final String descriptiveProtocolStatus;

        public PacketIdBasedOverrideHandler(Int2IntMap channelMapping, String descriptiveProtocolStatus) {
            this.channelMapping = new Int2IntOpenHashMap(channelMapping);
            this.descriptiveProtocolStatus = descriptiveProtocolStatus;
        }

        @Override
        public int getChannelOverride(ByteBuf buf) {
            ByteBuf slice = buf.slice();
            int packetId = MathUtil.readVarInt(slice);
            int override = this.channelMapping.get(packetId);
            if (override == Integer.MAX_VALUE) {
                if (this.unknownPacketIds.add(packetId)) {
                    System.err.println("Raknetify: Unknown packet id %d for %s".formatted(packetId, this.descriptiveProtocolStatus));
                }
                return 7;
            }
            return override;
        }
    }
}

