/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.util.HttpUtil;
import com.terraformersmc.modmenu.util.JsonUtil;
import com.terraformersmc.modmenu.util.OptionalUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricLoaderUpdateChecker
implements UpdateChecker {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu/Fabric Update Checker");
    private static final URI LOADER_VERSIONS = URI.create("https://meta.fabricmc.net/v2/versions/loader");

    @Override
    public UpdateInfo checkForUpdates() {
        UpdateInfo result = null;
        try {
            result = FabricLoaderUpdateChecker.checkForUpdates0();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOGGER.error("Failed Fabric Loader update check!", (Throwable)e);
        }
        return result;
    }

    private static UpdateInfo checkForUpdates0() throws IOException, InterruptedException {
        UpdateChannel preferredChannel = UpdateChannel.getUserPreference();
        HttpRequest.Builder request = HttpRequest.newBuilder().GET().uri(LOADER_VERSIONS);
        HttpResponse<String> response = HttpUtil.request(request, HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status != 200) {
            LOGGER.warn("Fabric Meta responded with a non-200 status: {}!", (Object)status);
            return null;
        }
        Optional<String> contentType = response.headers().firstValue("Content-Type");
        if (contentType.isEmpty() || !contentType.get().contains("application/json")) {
            LOGGER.warn("Fabric Meta responded with a non-json content type, aborting loader update check!");
            return null;
        }
        JsonElement data = JsonParser.parseString((String)response.body());
        if (!data.isJsonArray()) {
            LOGGER.warn("Received invalid data from Fabric Meta, aborting loader update check!");
            return null;
        }
        SemanticVersion match = null;
        boolean stableVersion = true;
        for (JsonElement child : data.getAsJsonArray()) {
            SemanticVersion parsed;
            JsonObject object;
            Optional<String> version;
            if (!child.isJsonObject() || (version = JsonUtil.getString(object = child.getAsJsonObject(), "version")).isEmpty()) continue;
            try {
                parsed = SemanticVersion.parse((String)version.get());
            }
            catch (VersionParsingException e) {
                continue;
            }
            boolean stable = OptionalUtil.isPresentAndTrue(JsonUtil.getBoolean(object, "stable"));
            if (preferredChannel == UpdateChannel.RELEASE && !stable || match != null && !FabricLoaderUpdateChecker.isNewer((Version)parsed, (Version)match)) continue;
            match = parsed;
            stableVersion = stable;
        }
        Version current = FabricLoaderUpdateChecker.getCurrentVersion();
        if (match == null || !FabricLoaderUpdateChecker.isNewer(match, current)) {
            LOGGER.debug("Fabric Loader is up to date.");
            return null;
        }
        LOGGER.debug("Fabric Loader has a matching update available!");
        return new FabricLoaderUpdateInfo(stableVersion);
    }

    private static boolean isNewer(Version self, Version other) {
        return self.compareTo((Object)other) > 0;
    }

    private static Version getCurrentVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").get()).getMetadata().getVersion();
    }

    private static class FabricLoaderUpdateInfo
    implements UpdateInfo {
        private final boolean isStable;

        private FabricLoaderUpdateInfo(boolean isStable) {
            this.isStable = isStable;
        }

        @Override
        public boolean isUpdateAvailable() {
            return true;
        }

        @Override
        public String getDownloadLink() {
            return "https://fabricmc.net/use/installer";
        }

        @Override
        public UpdateChannel getUpdateChannel() {
            return this.isStable ? UpdateChannel.RELEASE : UpdateChannel.BETA;
        }
    }
}

