/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.LegacyTexturedButtonWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.ModMenuScreenTexts;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsScreen
extends class_437 {
    private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/filters_button.png");
    private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/configure_button.png");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | ModsScreen");
    private final class_437 previousScreen;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean keepFilterOptionsShown = false;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    private class_342 searchBox;
    @Nullable
    private class_339 filtersButton;
    private class_339 sortingButton;
    private class_339 librariesButton;
    private ModListWidget modList;
    @Nullable
    private class_339 configureButton;
    private class_339 websiteButton;
    private class_339 issuesButton;
    private DescriptionListWidget descriptionListWidget;
    private class_339 modsFolderButton;
    private class_339 doneButton;
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();

    public ModsScreen(class_437 previousScreen) {
        super(ModMenuScreenTexts.TITLE);
        this.previousScreen = previousScreen;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.modList.method_25405(mouseX, mouseY)) {
            return this.modList.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.descriptionListWidget.method_25405(mouseX, mouseY)) {
            return this.descriptionListWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    protected void method_25426() {
        for (Mod mod : ModMenu.MODS.values()) {
            String id = mod.getId();
            if (this.modHasConfigScreen.containsKey(id)) continue;
            try {
                class_437 configScreen = ModMenu.getConfigScreen(id, this);
                this.modHasConfigScreen.put(id, configScreen != null);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("The '" + id + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
            catch (Throwable e) {
                LOGGER.error("Error from mod '" + id + "'", e);
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
        }
        int paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 67;
        this.paneWidth = this.field_22789 / 2 - 8;
        this.rightPaneX = this.field_22789 - this.paneWidth;
        this.modList = new ModListWidget(this.field_22787, this.paneWidth, this.field_22790 - paneY - 36, paneY, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.modList, this);
        this.modList.method_46421(0);
        int filtersButtonSize = ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new class_342(this.field_22793, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, ModMenuScreenTexts.SEARCH);
        this.searchBox.method_1863(text -> this.modList.filter((String)text, false));
        class_2561 sortingText = ModMenuConfig.SORTING.getButtonText();
        class_2561 librariesText = ModMenuConfig.SHOW_LIBRARIES.getButtonText();
        int sortingWidth = this.field_22793.method_27525((class_5348)sortingText) + 20;
        int librariesWidth = this.field_22793.method_27525((class_5348)librariesText) + 20;
        this.filtersWidth = librariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            this.filtersButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(ModMenuScreenTexts.TOGGLE_FILTER_OPTIONS, button -> this.setFilterOptionsShown(!this.filterOptionsShown)).position(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22).size(20, 20).uv(0, 0, 20).texture(FILTERS_BUTTON_LOCATION, 32, 64).build();
            this.filtersButton.method_47400(class_7919.method_47407((class_2561)ModMenuScreenTexts.TOGGLE_FILTER_OPTIONS));
        }
        this.sortingButton = class_4185.method_46430((class_2561)sortingText, button -> {
            ModMenuConfig.SORTING.cycleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
            button.method_25355(ModMenuConfig.SORTING.getButtonText());
        }).method_46433(this.filtersX, 45).method_46437(sortingWidth, 20).method_46431();
        this.librariesButton = class_4185.method_46430((class_2561)librariesText, button -> {
            ModMenuConfig.SHOW_LIBRARIES.toggleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
            button.method_25355(ModMenuConfig.SHOW_LIBRARIES.getButtonText());
        }).method_46433(this.filtersX + sortingWidth + 2, 45).method_46437(librariesWidth, 20).method_46431();
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.configureButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(class_5244.field_39003, button -> {
                String id = Objects.requireNonNull(this.selected).getMod().getId();
                if (this.modHasConfigScreen.get(id).booleanValue()) {
                    class_437 configScreen = ModMenu.getConfigScreen(id, this);
                    this.field_22787.method_1507(configScreen);
                } else {
                    button.field_22763 = false;
                }
            }).position(this.field_22789 - 24, 48).size(20, 20).uv(0, 0, 20).texture(CONFIGURE_BUTTON_LOCATION, 32, 64).build();
        }
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        this.websiteButton = class_4185.method_46430((class_2561)ModMenuScreenTexts.WEBSITE, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.field_22787.method_1507((class_437)new class_407(confirmed -> {
                if (confirmed) {
                    class_156.method_668().method_670(mod.getWebsite());
                }
                this.field_22787.method_1507((class_437)this);
            }, mod.getWebsite(), false));
        }).method_46433(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, 84).method_46437(Math.min(urlButtonWidths, 200), 20).method_46431();
        this.issuesButton = class_4185.method_46430((class_2561)ModMenuScreenTexts.ISSUES, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.field_22787.method_1507((class_437)new class_407(confirmed -> {
                if (confirmed) {
                    class_156.method_668().method_670(mod.getIssueTracker());
                }
                this.field_22787.method_1507((class_437)this);
            }, mod.getIssueTracker(), false));
        }).method_46433(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, 84).method_46437(Math.min(urlButtonWidths, 200), 20).method_46431();
        Objects.requireNonNull(this.field_22793);
        this.descriptionListWidget = new DescriptionListWidget(this.field_22787, this.paneWidth, this.field_22790 - 48 - 96, 108, 9 + 1, this);
        this.descriptionListWidget.method_46421(this.rightPaneX);
        this.modsFolderButton = class_4185.method_46430((class_2561)ModMenuScreenTexts.MODS_FOLDER, button -> class_156.method_668().method_673(FabricLoader.getInstance().getGameDir().resolve("mods").toUri())).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 28).method_46437(150, 20).method_46431();
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.field_22787.method_1507(this.previousScreen)).method_46433(this.field_22789 / 2 + 4, this.field_22790 - 28).method_46437(150, 20).method_46431();
        this.modList.reloadFilters();
        this.setFilterOptionsShown(this.keepFilterOptionsShown ? this.filterOptionsShown : false);
        this.method_25429((class_364)this.searchBox);
        this.method_48265((class_364)this.searchBox);
        if (this.filtersButton != null) {
            this.method_37063((class_364)this.filtersButton);
        }
        this.method_37063((class_364)this.sortingButton);
        this.method_37063((class_364)this.librariesButton);
        this.method_25429((class_364)this.modList);
        if (this.configureButton != null) {
            this.method_37063((class_364)this.configureButton);
        }
        this.method_37063((class_364)this.websiteButton);
        this.method_37063((class_364)this.issuesButton);
        this.method_25429((class_364)this.descriptionListWidget);
        this.method_37063((class_364)this.modsFolderButton);
        this.method_37063((class_364)this.doneButton);
        this.init = true;
        this.keepFilterOptionsShown = true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers) || this.searchBox.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int keyCode) {
        return this.searchBox.method_25400(chr, keyCode);
    }

    public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(DrawContext, mouseX, mouseY, delta);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.method_25394(DrawContext, mouseX, mouseY, delta);
        }
        this.modList.method_25394(DrawContext, mouseX, mouseY, delta);
        this.searchBox.method_25394(DrawContext, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        DrawContext.method_27534(this.field_22793, this.field_22785, this.modList.method_25368() / 2, 8, 0xFFFFFF);
        if (!ModMenuConfig.DISABLE_DRAG_AND_DROP.getValue()) {
            int n = this.field_22789 - this.modList.method_25368() / 2;
            Objects.requireNonNull(this.field_22787.field_1772);
            DrawContext.method_27534(this.field_22793, ModMenuScreenTexts.DROP_INFO_LINE_1, n, 24 - 9 - 1, class_124.field_1080.method_532().intValue());
            DrawContext.method_27534(this.field_22793, ModMenuScreenTexts.DROP_INFO_LINE_2, this.field_22789 - this.modList.method_25368() / 2, 25, class_124.field_1080.method_532().intValue());
        }
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            class_2561 fullModCount = this.computeModCountText(true);
            if (!ModMenuConfig.CONFIG_MODE.getValue() && this.updateFiltersX()) {
                if (this.filterOptionsShown) {
                    if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_22793.method_27525((class_5348)fullModCount) <= this.filtersX - 5) {
                        DrawContext.method_51430(this.field_22793, fullModCount.method_30937(), this.searchBoxX, 52, 0xFFFFFF, false);
                    } else {
                        DrawContext.method_51430(this.field_22793, this.computeModCountText(false).method_30937(), this.searchBoxX, 46, 0xFFFFFF, false);
                        DrawContext.method_51430(this.field_22793, this.computeLibraryCountText().method_30937(), this.searchBoxX, 57, 0xFFFFFF, false);
                    }
                } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_22793.method_27525((class_5348)fullModCount) <= this.modList.method_25368() - 5) {
                    DrawContext.method_51430(this.field_22793, fullModCount.method_30937(), this.searchBoxX, 52, 0xFFFFFF, false);
                } else {
                    DrawContext.method_51430(this.field_22793, this.computeModCountText(false).method_30937(), this.searchBoxX, 46, 0xFFFFFF, false);
                    DrawContext.method_51430(this.field_22793, this.computeLibraryCountText().method_30937(), this.searchBoxX, 57, 0xFFFFFF, false);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            class_5250 name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, DrawContext, x, 48, 32, 32);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            DrawContext.method_25290(this.selected.getIconTexture(), x, 48, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            Objects.requireNonNull(this.field_22793);
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            class_5250 trimmedName = name = class_2561.method_43470((String)mod.getTranslatedName());
            int maxNameWidth = this.field_22789 - (x + imageOffset);
            if (this.field_22793.method_27525((class_5348)name) > maxNameWidth) {
                class_5348 ellipsis = class_5348.method_29430((String)"...");
                trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{this.field_22793.method_1714((class_5348)name, maxNameWidth - this.field_22793.method_27525(ellipsis)), ellipsis});
            }
            DrawContext.method_51430(this.field_22793, class_2477.method_10517().method_30934((class_5348)trimmedName), x + imageOffset, 49, 0xFFFFFF, false);
            if (mouseX > x + imageOffset && mouseY > 49) {
                Objects.requireNonNull(this.field_22793);
                if (mouseY < 49 + 9 && mouseX < x + imageOffset + this.field_22793.method_27525((class_5348)trimmedName)) {
                    this.method_47415(ModMenuScreenTexts.modIdTooltip(mod.getId()));
                }
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_22787.field_1772.method_27525((class_5348)trimmedName) + 2, 48, this.field_22789 - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(DrawContext, mouseX, mouseY);
            }
            if (mod.isReal()) {
                DrawContext.method_51433(this.field_22793, mod.getPrefixedVersion(), x + imageOffset, 50 + lineSpacing, 0x808080, false);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(DrawContext, class_1074.method_4662((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, 50 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
    }

    private class_2561 computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private class_2561 computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return class_2561.method_43470(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void method_25419() {
        this.modList.close();
        this.field_22787.method_1507(this.previousScreen);
    }

    private void setFilterOptionsShown(boolean filterOptionsShown) {
        this.filterOptionsShown = filterOptionsShown;
        this.sortingButton.field_22764 = filterOptionsShown;
        this.librariesButton.field_22764 = filterOptionsShown;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
            if (this.configureButton != null) {
                String modId = this.selected.getMod().getId();
                this.configureButton.field_22763 = this.modHasConfigScreen.get(modId);
                boolean bl = this.configureButton.field_22764 = this.selected != null && this.modHasConfigScreen.get(modId) != false || this.modScreenErrors.containsKey(modId);
                if (this.modScreenErrors.containsKey(modId)) {
                    Throwable e = this.modScreenErrors.get(modId);
                    this.configureButton.method_47400(class_7919.method_47407((class_2561)ModMenuScreenTexts.configureError(modId, e)));
                } else {
                    this.configureButton.method_47400(class_7919.method_47407((class_2561)ModMenuScreenTexts.CONFIGURE));
                }
            }
            this.websiteButton.field_22764 = true;
            this.websiteButton.field_22763 = this.selected.getMod().getWebsite() != null;
            this.issuesButton.field_22764 = true;
            this.issuesButton.field_22763 = this.selected.getMod().getIssueTracker() != null;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1882();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void method_29638(List<Path> paths) {
        Path modsDirectory = FabricLoader.getInstance().getGameDir().resolve("mods");
        List mods = paths.stream().filter(ModsScreen::isFabricMod).collect(Collectors.toList());
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        class_370.method_29627((class_310)this.field_22787, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    class_370.method_27024((class_374)this.field_22787.method_1566(), (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)ModMenuScreenTexts.DROP_SUCCESSFUL_LINE_1, (class_2561)ModMenuScreenTexts.DROP_SUCCESSFUL_LINE_1);
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, ModMenuScreenTexts.DROP_CONFIRM, (class_2561)class_2561.method_43470((String)modList)));
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public Map<String, Boolean> getModHasConfigScreen() {
        return this.modHasConfigScreen;
    }
}

