/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin.vertices;

import java.nio.ByteBuffer;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.vertices.BlockSensitiveBufferBuilder;
import net.irisshaders.iris.vertices.BufferBuilderPolygonView;
import net.irisshaders.iris.vertices.ExtendedDataHelper;
import net.irisshaders.iris.vertices.ExtendingBufferBuilder;
import net.irisshaders.iris.vertices.IrisExtendedBufferBuilder;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import net.irisshaders.iris.vertices.NormI8;
import net.irisshaders.iris.vertices.NormalHelper;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4584;
import net.minecraft.class_4585;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
extends class_4585
implements class_4584,
BlockSensitiveBufferBuilder,
ExtendingBufferBuilder,
IrisExtendedBufferBuilder {
    @Unique
    private final BufferBuilderPolygonView polygon = new BufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Unique
    private boolean iris$shouldNotExtend;
    @Unique
    private boolean extending;
    @Unique
    private boolean iris$isTerrain;
    @Unique
    private boolean injectNormalAndUV1;
    @Unique
    private int vertexCount;
    @Unique
    private short currentBlock = (short)-1;
    @Unique
    private short currentRenderType = (short)-1;
    @Unique
    private int currentLocalPosX;
    @Unique
    private int currentLocalPosY;
    @Unique
    private int currentLocalPosZ;
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private class_293.class_5596 field_1567;
    @Shadow
    private class_293 field_1565;
    @Shadow
    private int field_20884;
    @Shadow
    @Nullable
    private class_296 field_1558;

    @Shadow
    public abstract void method_1328(class_293.class_5596 var1, class_293 var2);

    @Shadow
    public abstract void method_22898(int var1, short var2);

    @Shadow
    public abstract void method_1325();

    @Override
    public void iris$beginWithoutExtending(class_293.class_5596 drawMode, class_293 vertexFormat) {
        this.iris$shouldNotExtend = true;
        this.method_1328(drawMode, vertexFormat);
        this.iris$shouldNotExtend = false;
    }

    @NotNull
    public class_4588 method_22921(int pBufferVertexConsumer0, int pInt1) {
        return super.method_22921(pBufferVertexConsumer0, pInt1);
    }

    @ModifyVariable(method={"method_1328(Lnet/minecraft/class_293$class_5596;Lnet/minecraft/class_293;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private class_293 iris$extendFormat(class_293 format) {
        this.extending = false;
        this.iris$isTerrain = false;
        this.injectNormalAndUV1 = false;
        if (this.iris$shouldNotExtend || !WorldRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat()) {
            return format;
        }
        if (format == class_290.field_1590) {
            this.extending = true;
            this.iris$isTerrain = true;
            this.injectNormalAndUV1 = false;
            return IrisVertexFormats.TERRAIN;
        }
        if (format == class_290.field_1580) {
            this.extending = true;
            this.iris$isTerrain = false;
            this.injectNormalAndUV1 = false;
            return IrisVertexFormats.ENTITY;
        }
        if (format == class_290.field_20888) {
            this.extending = true;
            this.iris$isTerrain = false;
            this.injectNormalAndUV1 = true;
            return IrisVertexFormats.GLYPH;
        }
        return format;
    }

    @Inject(method={"method_43579()V"}, at={@At(value="HEAD")})
    private void iris$onReset(CallbackInfo ci) {
        this.vertexCount = 0;
    }

    @Inject(method={"method_1344()V"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        if (this.injectNormalAndUV1 && this.field_1558 == class_290.field_1579) {
            this.putInt(0, 0);
            this.method_1325();
        }
        if (this.iris$isTerrain) {
            this.method_22898(0, this.currentBlock);
            this.method_22898(2, this.currentRenderType);
        } else {
            this.method_22898(0, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity());
            this.method_22898(2, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity());
            this.method_22898(4, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem());
        }
        this.method_1325();
        this.method_22897(0, 0.0f);
        this.method_22897(4, 0.0f);
        this.method_1325();
        this.putInt(0, 0);
        this.method_1325();
        if (this.iris$isTerrain) {
            int posIndex = this.field_20884 - 48;
            float x = this.field_1555.getFloat(posIndex);
            float y = this.field_1555.getFloat(posIndex + 4);
            float z = this.field_1555.getFloat(posIndex + 8);
            this.putInt(0, ExtendedDataHelper.computeMidBlock(x, y, z, this.currentLocalPosX, this.currentLocalPosY, this.currentLocalPosZ));
            this.method_1325();
        }
        ++this.vertexCount;
        if (this.field_1567 == class_293.class_5596.field_27382 && this.vertexCount == 4 || this.field_1567 == class_293.class_5596.field_27379 && this.vertexCount == 3) {
            this.fillExtendedData(this.vertexCount);
        }
    }

    @Unique
    private void fillExtendedData(int vertexAmount) {
        int tangentOffset;
        int normalOffset;
        int midVOffset;
        int midUOffset;
        this.vertexCount = 0;
        int stride = this.field_1565.method_1362();
        this.polygon.setup(this.field_1555, this.field_20884, stride, vertexAmount);
        float midU = 0.0f;
        float midV = 0.0f;
        for (int vertex = 0; vertex < vertexAmount; ++vertex) {
            midU += this.polygon.u(vertex);
            midV += this.polygon.v(vertex);
        }
        midU /= (float)vertexAmount;
        midV /= (float)vertexAmount;
        if (this.iris$isTerrain) {
            midUOffset = 16;
            midVOffset = 12;
            normalOffset = 24;
            tangentOffset = 8;
        } else {
            midUOffset = 14;
            midVOffset = 10;
            normalOffset = 24;
            tangentOffset = 6;
        }
        if (vertexAmount == 3) {
            for (int vertex = 0; vertex < vertexAmount; ++vertex) {
                int packedNormal = this.field_1555.getInt(this.field_20884 - normalOffset - stride * vertex);
                int tangent = NormalHelper.computeTangentSmooth(NormI8.unpackX(packedNormal), NormI8.unpackY(packedNormal), NormI8.unpackZ(packedNormal), this.polygon);
                this.field_1555.putFloat(this.field_20884 - midUOffset - stride * vertex, midU);
                this.field_1555.putFloat(this.field_20884 - midVOffset - stride * vertex, midV);
                this.field_1555.putInt(this.field_20884 - tangentOffset - stride * vertex, tangent);
            }
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
            int packedNormal = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
            for (int vertex = 0; vertex < vertexAmount; ++vertex) {
                this.field_1555.putFloat(this.field_20884 - midUOffset - stride * vertex, midU);
                this.field_1555.putFloat(this.field_20884 - midVOffset - stride * vertex, midV);
                this.field_1555.putInt(this.field_20884 - normalOffset - stride * vertex, packedNormal);
                this.field_1555.putInt(this.field_20884 - tangentOffset - stride * vertex, tangent);
            }
        }
    }

    @Unique
    private void putInt(int i, int value) {
        this.field_1555.putInt(this.field_20884 + i, value);
    }

    @Override
    public void beginBlock(short block, short renderType, int localPosX, int localPosY, int localPosZ) {
        this.currentBlock = block;
        this.currentRenderType = renderType;
        this.currentLocalPosX = localPosX;
        this.currentLocalPosY = localPosY;
        this.currentLocalPosZ = localPosZ;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
        this.currentLocalPosX = 0;
        this.currentLocalPosY = 0;
        this.currentLocalPosZ = 0;
    }

    @Override
    public class_293 iris$format() {
        return this.field_1565;
    }

    @Override
    public class_293.class_5596 iris$mode() {
        return this.field_1567;
    }

    @Override
    public boolean iris$extending() {
        return this.extending;
    }

    @Override
    public boolean iris$isTerrain() {
        return this.iris$isTerrain;
    }

    @Override
    public boolean iris$injectNormalAndUV1() {
        return this.injectNormalAndUV1;
    }

    @Override
    public int iris$vertexCount() {
        return this.vertexCount;
    }

    @Override
    public void iris$incrementVertexCount() {
        ++this.vertexCount;
    }

    @Override
    public void iris$resetVertexCount() {
        this.vertexCount = 0;
    }

    @Override
    public short iris$currentBlock() {
        return this.currentBlock;
    }

    @Override
    public short iris$currentRenderType() {
        return this.currentRenderType;
    }

    @Override
    public int iris$currentLocalPosX() {
        return this.currentLocalPosX;
    }

    @Override
    public int iris$currentLocalPosY() {
        return this.currentLocalPosY;
    }

    @Override
    public int iris$currentLocalPosZ() {
        return this.currentLocalPosZ;
    }
}

