/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elementa.elements;

import dev.dediamondpro.resourcify.libs.elementa.components.UIBlock;
import dev.dediamondpro.resourcify.libs.elementa.font.FontProvider;
import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elementa.style.MarkdownStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.TextElement;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import java.awt.Color;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BG\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ?\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJO\u0010 \u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b \u0010!J!\u0010$\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010&\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b(\u0010'J'\u0010)\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Ldev/dediamondpro/resourcify/libs/minemark/elementa/elements/MarkdownTextComponent;", "Ldev/dediamondpro/resourcify/libs/minemark/elements/impl/TextElement;", "Ldev/dediamondpro/resourcify/libs/minemark/elementa/style/MarkdownStyle;", "Lgg/essential/universal/UMatrixStack;", "", "text", "style", "Ldev/dediamondpro/resourcify/libs/minemark/LayoutStyle;", "layoutStyle", "Ldev/dediamondpro/resourcify/libs/minemark/elements/Element;", "parent", "qName", "Lorg/xml/sax/Attributes;", "attributes", "<init>", "(Ljava/lang/String;Ldev/dediamondpro/minemark/elementa/style/MarkdownStyle;Ldev/dediamondpro/minemark/LayoutStyle;Ldev/dediamondpro/minemark/elements/Element;Ljava/lang/String;Lorg/xml/sax/Attributes;)V", "", "x", "y", "width", "height", "Ljava/awt/Color;", "color", "matrixStack", "", "drawInlineCodeBlock", "(FFFFLjava/awt/Color;Lgg/essential/universal/UMatrixStack;)V", "fontSize", "", "hovered", "Ldev/dediamondpro/resourcify/libs/minemark/LayoutData$MarkDownElementPosition;", "position", "drawText", "(Ljava/lang/String;FFFLjava/awt/Color;ZLdev/dediamondpro/resourcify/libs/minemark/LayoutData$MarkDownElementPosition;Lgg/essential/universal/UMatrixStack;)V", "Ldev/dediamondpro/resourcify/libs/minemark/LayoutData;", "layoutData", "generateLayout", "(Ldev/dediamondpro/resourcify/libs/minemark/LayoutData;Lgg/essential/universal/UMatrixStack;)V", "getBaselineHeight", "(FLgg/essential/universal/UMatrixStack;)F", "getDescender", "getTextWidth", "(Ljava/lang/String;FLgg/essential/universal/UMatrixStack;)F", "Ldev/dediamondpro/resourcify/libs/elementa/font/FontProvider;", "font", "Ldev/dediamondpro/resourcify/libs/elementa/font/FontProvider;", "prefix", "Ljava/lang/String;", "scale", "F", "elementa"})
public final class MarkdownTextComponent
extends TextElement<MarkdownStyle, UMatrixStack> {
    @NotNull
    private final FontProvider font;
    private float scale;
    @NotNull
    private String prefix;

    /*
     * WARNING - void declaration
     */
    public MarkdownTextComponent(@NotNull String text, @NotNull MarkdownStyle style, @NotNull LayoutStyle layoutStyle, @Nullable Element<MarkdownStyle, UMatrixStack> parent, @NotNull String qName, @Nullable Attributes attributes) {
        void $this$prefix_u24lambda_u2d0;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)layoutStyle, (String)"layoutStyle");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        super(text, (Style)style, layoutStyle, parent, qName, attributes);
        this.font = style.getTextStyle().getFont();
        this.scale = layoutStyle.getFontSize();
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        MarkdownTextComponent markdownTextComponent = this;
        boolean bl = false;
        if (layoutStyle.isBold()) {
            $this$prefix_u24lambda_u2d0.append("\u00a7l");
        }
        if (layoutStyle.isItalic()) {
            $this$prefix_u24lambda_u2d0.append("\u00a7o");
        }
        if (layoutStyle.isUnderlined()) {
            $this$prefix_u24lambda_u2d0.append("\u00a7n");
        }
        if (layoutStyle.isStrikethrough()) {
            $this$prefix_u24lambda_u2d0.append("\u00a7m");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        markdownTextComponent.prefix = string;
    }

    @Override
    public void generateLayout(@Nullable LayoutData layoutData, @NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        float mcScale = (float)UResolution.getScaleFactor();
        this.scale = (float)Math.rint(this.layoutStyle.getFontSize() * mcScale) / mcScale;
        super.generateLayout(layoutData, matrixStack);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void drawText(@NotNull String text, float x, float y, float fontSize, @NotNull Color color, boolean hovered, @NotNull LayoutData.MarkDownElementPosition position, @NotNull UMatrixStack matrixStack) {
        void $this$drawText_u24lambda_u2d1;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        StringBuilder stringBuilder = serializable = new StringBuilder();
        MarkdownTextComponent markdownTextComponent = this;
        boolean bl = false;
        if (this.layoutStyle.isBold()) {
            $this$drawText_u24lambda_u2d1.append("\u00a7l");
        }
        if (this.layoutStyle.isItalic()) {
            $this$drawText_u24lambda_u2d1.append("\u00a7o");
        }
        if (this.layoutStyle.isStrikethrough()) {
            $this$drawText_u24lambda_u2d1.append("\u00a7m");
        }
        if (this.layoutStyle.isUnderlined() || this.layoutStyle.isPartOfLink() && hovered) {
            $this$drawText_u24lambda_u2d1.append("\u00a7n");
        }
        String string = serializable.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        markdownTextComponent.prefix = string;
        matrixStack.push();
        matrixStack.scale(this.scale, this.scale, 1.0f);
        String string2 = Intrinsics.stringPlus((String)this.prefix, (Object)text);
        serializable = this.layoutStyle.getTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"layoutStyle.textColor");
        FontProvider.drawString$default(this.font, matrixStack, string2, (Color)serializable, x / this.scale, y / this.scale, 1.0f, 1.0f, false, null, 384, null);
        matrixStack.pop();
    }

    @Override
    protected void drawInlineCodeBlock(float x, float y, float width, float height, @NotNull Color color, @NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        UIBlock.Companion.drawBlockSized(matrixStack, color, x, y, width, height);
    }

    @Override
    protected float getTextWidth(@NotNull String text, float fontSize, @NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        return this.font.getStringWidth(Intrinsics.stringPlus((String)this.prefix, (Object)text), 1.0f) * this.scale;
    }

    @Override
    protected float getBaselineHeight(float fontSize, @NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        return (this.font.getBaseLineHeight() + this.font.getShadowHeight()) * this.scale;
    }

    @Override
    protected float getDescender(float fontSize, @NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        return this.font.getBelowLineHeight() * this.scale;
    }
}

