/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.MineMarkElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.loaders.ElementLoader;
import dev.dediamondpro.resourcify.libs.minemark.elements.loaders.TextElementLoader;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MineMarkHtmlParser<S extends Style, R>
extends DefaultHandler {
    private final Map<List<String>, ElementLoader<S, R>> elements;
    private final TextElementLoader<S, R> textElement;
    private MineMarkElement<S, R> markDown;
    private Element<S, R> currentElement;
    private LayoutStyle layoutStyle;
    private S style;
    private StringBuilder textBuilder = new StringBuilder();
    private boolean isPreFormatted = false;

    protected MineMarkHtmlParser(TextElementLoader<S, R> textElement, Map<List<String>, ElementLoader<S, R>> elements) {
        this.textElement = textElement;
        this.elements = elements;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "minemark": {
                this.markDown = new MineMarkElement(this.style, this.layoutStyle, attributes);
                this.currentElement = this.markDown;
                return;
            }
            case "br": {
                this.textBuilder.append("\n");
                return;
            }
            case "pre": {
                this.isPreFormatted = true;
            }
        }
        this.addText();
        ElementLoader<S, R> elementCreator = this.findElement(qName);
        if (elementCreator == null) {
            return;
        }
        this.currentElement = elementCreator.get(this.style, this.currentElement.getLayoutStyle(), this.currentElement, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (qName) {
            case "minemark": 
            case "br": {
                return;
            }
            case "pre": {
                this.isPreFormatted = false;
            }
        }
        this.addText();
        if (!this.hasElement(qName)) {
            return;
        }
        this.currentElement = this.currentElement.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        int newLength = length;
        if (this.isPreFormatted) {
            if (ch[start] == '\n') {
                --newLength;
            }
            if (ch[start + length - 1] == '\n') {
                --newLength;
            }
        } else {
            for (int i2 = start; i2 < start + length; ++i2) {
                if (ch[i2] != '\n') continue;
                --newLength;
            }
        }
        char[] modifiedCh = new char[newLength];
        int index = 0;
        for (int i3 = start; i3 < start + length; ++i3) {
            if (ch[i3] == '\n' && (!this.isPreFormatted || i3 == start || i3 == start + length - 1)) continue;
            modifiedCh[index++] = ch[i3];
        }
        this.textBuilder.append(modifiedCh);
    }

    private void addText() {
        String text = this.textBuilder.toString();
        if (text.isEmpty()) {
            return;
        }
        this.textElement.get(this.textBuilder.toString(), this.style, this.currentElement.getLayoutStyle(), this.currentElement, "text", null);
        this.textBuilder = new StringBuilder();
    }

    private ElementLoader<S, R> findElement(String qName) {
        for (Map.Entry<List<String>, ElementLoader<S, R>> element : this.elements.entrySet()) {
            if (!element.getKey().contains(qName)) continue;
            return element.getValue();
        }
        return null;
    }

    private boolean hasElement(String qName) {
        return this.findElement(qName) != null;
    }

    protected void setStyle(S style, LayoutStyle layoutStyle) {
        this.style = style;
        this.layoutStyle = layoutStyle;
    }

    protected MineMarkElement<S, R> getParsedResult() {
        return this.markDown;
    }

    protected void cleanUp() {
        this.markDown = null;
        this.currentElement = null;
        this.layoutStyle = null;
        this.style = null;
        this.textBuilder = new StringBuilder();
        this.isPreFormatted = false;
    }
}

