/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.commonmark.Extension;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.html.UrlSanitizer;
import dev.dediamondpro.resourcify.libs.minemark.MineMarkCore;
import dev.dediamondpro.resourcify.libs.minemark.elements.Elements;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.LinkElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.ParagraphElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting.AlignmentElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting.FormattingElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.list.ListHolderElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.table.TableHolderElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.table.TableRowElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.loaders.ElementLoader;
import dev.dediamondpro.resourcify.libs.minemark.elements.loaders.TextElementLoader;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MineMarkCoreBuilder<S extends Style, R> {
    private final HashMap<List<String>, ElementLoader<S, R>> elements = new HashMap();
    private final ArrayList<Extension> extensions = new ArrayList();
    private TextElementLoader<S, R> textElement = null;
    private boolean withDefaultElements = true;
    private UrlSanitizer urlSanitizer = null;

    protected MineMarkCoreBuilder() {
    }

    public MineMarkCoreBuilder<S, R> setTextElement(@NotNull TextElementLoader<S, R> textElement) {
        this.textElement = textElement;
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull Elements elementName, @NotNull ElementLoader<S, R> element) {
        this.elements.put(elementName.tags, element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull List<String> tags, @NotNull ElementLoader<S, R> element) {
        this.elements.put(tags, element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElements(@NotNull Map<Elements, ElementLoader<S, R>> elements) {
        for (Map.Entry<Elements, ElementLoader<S, R>> element : elements.entrySet()) {
            this.addElement(element.getKey(), element.getValue());
        }
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElementsString(@NotNull Map<List<String>, ElementLoader<S, R>> elements) {
        this.elements.putAll(elements);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addExtension(Extension extension) {
        this.extensions.add(extension);
        return this;
    }

    public MineMarkCoreBuilder<S, R> withoutDefaultElements() {
        this.withDefaultElements = false;
        return this;
    }

    public void setUrlSanitizer(UrlSanitizer urlSanitizer) {
        this.urlSanitizer = urlSanitizer;
    }

    public MineMarkCore<S, R> build() {
        if (this.textElement == null) {
            throw new IllegalArgumentException("A text element has to be provided by using \"setTextElement(textElement\"");
        }
        if (this.withDefaultElements) {
            this.addElement(Elements.PARAGRAPH, ParagraphElement::new);
            this.addElement(Elements.FORMATTING, FormattingElement::new);
            this.addElement(Elements.ALIGNMENT, AlignmentElement::new);
            this.addElement(Elements.LINK, LinkElement::new);
            this.addElement(Elements.LIST_PARENT, ListHolderElement::new);
            this.addElement(Elements.TABLE, TableHolderElement::new);
            this.addElement(Elements.TABLE_ROW, TableRowElement::new);
        }
        return new MineMarkCore<S, R>(this.textElement, this.elements, this.extensions, this.urlSanitizer);
    }
}

