/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.effects;

import dev.dediamondpro.resourcify.libs.elementa.UIComponent;
import dev.dediamondpro.resourcify.libs.elementa.effects.Effect;
import dev.dediamondpro.resourcify.libs.elementa.utils.ExtensionsKt;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B3\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u001f\b\u0007\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0013\u0010\u0015\u001a\u00020\u0014*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0017R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001d\u00a8\u0006!"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect;", "Ldev/dediamondpro/resourcify/libs/elementa/effects/Effect;", "", "x1", "y1", "x2", "y2", "", "scissorIntersection", "<init>", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Z)V", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "customBoundingBox", "(Lgg/essential/elementa/UIComponent;Z)V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "afterDraw", "(Lgg/essential/universal/UMatrixStack;)V", "beforeDraw", "Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorBounds;", "getScissorBounds", "(Lgg/essential/elementa/UIComponent;)Lgg/essential/elementa/effects/ScissorEffect$ScissorBounds;", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorState;", "oldState", "Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorState;", "scissorBounds", "Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorBounds;", "Z", "Companion", "ScissorBounds", "ScissorState", "Elementa"})
public final class ScissorEffect
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final UIComponent customBoundingBox;
    private final boolean scissorIntersection;
    @Nullable
    private ScissorState oldState;
    @Nullable
    private ScissorBounds scissorBounds;
    @Nullable
    private static ScissorState currentScissorState;

    @JvmOverloads
    public ScissorEffect(@Nullable UIComponent customBoundingBox, boolean scissorIntersection) {
        this.customBoundingBox = customBoundingBox;
        this.scissorIntersection = scissorIntersection;
    }

    public /* synthetic */ ScissorEffect(UIComponent uIComponent, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uIComponent = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(uIComponent, bl);
    }

    @JvmOverloads
    public ScissorEffect(@NotNull Number x1, @NotNull Number y1, @NotNull Number x2, @NotNull Number y2, boolean scissorIntersection) {
        Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
        Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x2");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y2");
        this(null, scissorIntersection, 1, null);
        this.scissorBounds = new ScissorBounds(ExtensionsKt.roundToRealPixels(x1.floatValue()), ExtensionsKt.roundToRealPixels(y1.floatValue()), ExtensionsKt.roundToRealPixels(x2.floatValue()), ExtensionsKt.roundToRealPixels(y2.floatValue()));
    }

    public /* synthetic */ ScissorEffect(Number number, Number number2, Number number3, Number number4, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(number, number2, number3, number4, bl);
    }

    @Override
    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Object object = this.customBoundingBox;
        if ((object == null || (object = this.getScissorBounds((UIComponent)object)) == null) && (object = this.scissorBounds) == null) {
            object = this.getScissorBounds(this.getBoundComponent());
        }
        Object bounds = object;
        int scaleFactor = (int)UResolution.getScaleFactor();
        if (currentScissorState == null) {
            GL11.glEnable((int)3089);
        }
        ScissorState state = this.oldState = currentScissorState;
        int x = MathKt.roundToInt((float)(((ScissorBounds)bounds).getX1() * (float)scaleFactor));
        int y = UResolution.getViewportHeight() - MathKt.roundToInt((float)(((ScissorBounds)bounds).getY2() * (float)scaleFactor));
        int width = MathKt.roundToInt((float)(((ScissorBounds)bounds).getWidth() * (float)scaleFactor));
        int height = MathKt.roundToInt((float)(((ScissorBounds)bounds).getHeight() * (float)scaleFactor));
        if (state != null && this.scissorIntersection) {
            int x2 = x + width;
            int y2 = y + height;
            int oldX = state.getX();
            int oldY = state.getY();
            int oldX2 = state.getX() + state.getWidth();
            int oldY2 = state.getY() + state.getHeight();
            x = Math.max(x, oldX);
            y = Math.max(y, oldY);
            width = Math.min(x2, oldX2) - x;
            height = Math.min(y2, oldY2) - y;
        }
        GL11.glScissor((int)x, (int)y, (int)RangesKt.coerceAtLeast((int)width, (int)0), (int)RangesKt.coerceAtLeast((int)height, (int)0));
        currentScissorState = new ScissorState(x, y, RangesKt.coerceAtLeast((int)width, (int)0), RangesKt.coerceAtLeast((int)height, (int)0));
    }

    @Override
    public void afterDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        ScissorState state = this.oldState;
        if (state != null) {
            GL11.glScissor((int)state.getX(), (int)state.getY(), (int)state.getWidth(), (int)state.getHeight());
            this.oldState = null;
        } else {
            GL11.glDisable((int)3089);
        }
        currentScissorState = state;
    }

    private final ScissorBounds getScissorBounds(UIComponent $this$getScissorBounds) {
        return new ScissorBounds(ExtensionsKt.roundToRealPixels($this$getScissorBounds.getLeft()), ExtensionsKt.roundToRealPixels($this$getScissorBounds.getTop()), ExtensionsKt.roundToRealPixels($this$getScissorBounds.getRight()), ExtensionsKt.roundToRealPixels($this$getScissorBounds.getBottom()));
    }

    @JvmOverloads
    public ScissorEffect(@Nullable UIComponent customBoundingBox) {
        this(customBoundingBox, false, 2, null);
    }

    @JvmOverloads
    public ScissorEffect() {
        this(null, false, 3, null);
    }

    @JvmOverloads
    public ScissorEffect(@NotNull Number x1, @NotNull Number y1, @NotNull Number x2, @NotNull Number y2) {
        Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
        Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x2");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y2");
        this(x1, y1, x2, y2, false, 16, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$Companion;", "", "<init>", "()V", "Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorState;", "currentScissorState", "Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorState;", "getCurrentScissorState", "()Lgg/essential/elementa/effects/ScissorEffect$ScissorState;", "setCurrentScissorState", "(Lgg/essential/elementa/effects/ScissorEffect$ScissorState;)V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ScissorState getCurrentScissorState() {
            return currentScissorState;
        }

        public final void setCurrentScissorState(@Nullable ScissorState scissorState) {
            currentScissorState = scissorState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0011\u0010\u001d\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b \u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b!\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\"\u0010\n\u00a8\u0006#"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorBounds;", "", "", "x1", "y1", "x2", "y2", "<init>", "(FFFF)V", "component1", "()F", "component2", "component3", "component4", "copy", "(FFFF)Lgg/essential/elementa/effects/ScissorEffect$ScissorBounds;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "getHeight", "height", "getWidth", "width", "F", "getX1", "getX2", "getY1", "getY2", "Elementa"})
    private static final class ScissorBounds {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;

        public ScissorBounds(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public final float getX1() {
            return this.x1;
        }

        public final float getY1() {
            return this.y1;
        }

        public final float getX2() {
            return this.x2;
        }

        public final float getY2() {
            return this.y2;
        }

        public final float getWidth() {
            return this.x2 - this.x1;
        }

        public final float getHeight() {
            return this.y2 - this.y1;
        }

        public final float component1() {
            return this.x1;
        }

        public final float component2() {
            return this.y1;
        }

        public final float component3() {
            return this.x2;
        }

        public final float component4() {
            return this.y2;
        }

        @NotNull
        public final ScissorBounds copy(float x1, float y1, float x2, float y2) {
            return new ScissorBounds(x1, y1, x2, y2);
        }

        public static /* synthetic */ ScissorBounds copy$default(ScissorBounds scissorBounds, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = scissorBounds.x1;
            }
            if ((n & 2) != 0) {
                f2 = scissorBounds.y1;
            }
            if ((n & 4) != 0) {
                f3 = scissorBounds.x2;
            }
            if ((n & 8) != 0) {
                f4 = scissorBounds.y2;
            }
            return scissorBounds.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "ScissorBounds(x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.x1);
            result = result * 31 + Float.hashCode(this.y1);
            result = result * 31 + Float.hashCode(this.x2);
            result = result * 31 + Float.hashCode(this.y2);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScissorBounds)) {
                return false;
            }
            ScissorBounds scissorBounds = (ScissorBounds)other;
            if (Float.compare(this.x1, scissorBounds.x1) != 0) {
                return false;
            }
            if (Float.compare(this.y1, scissorBounds.y1) != 0) {
                return false;
            }
            if (Float.compare(this.x2, scissorBounds.x2) != 0) {
                return false;
            }
            return Float.compare(this.y2, scissorBounds.y2) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001c\u0010\n\u00a8\u0006\u001d"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/effects/ScissorEffect$ScissorState;", "", "", "x", "y", "width", "height", "<init>", "(IIII)V", "component1", "()I", "component2", "component3", "component4", "copy", "(IIII)Lgg/essential/elementa/effects/ScissorEffect$ScissorState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getHeight", "getWidth", "getX", "getY", "Elementa"})
    public static final class ScissorState {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public ScissorState(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        @NotNull
        public final ScissorState copy(int x, int y, int width, int height) {
            return new ScissorState(x, y, width, height);
        }

        public static /* synthetic */ ScissorState copy$default(ScissorState scissorState, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = scissorState.x;
            }
            if ((n5 & 2) != 0) {
                n2 = scissorState.y;
            }
            if ((n5 & 4) != 0) {
                n3 = scissorState.width;
            }
            if ((n5 & 8) != 0) {
                n4 = scissorState.height;
            }
            return scissorState.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "ScissorState(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScissorState)) {
                return false;
            }
            ScissorState scissorState = (ScissorState)other;
            if (this.x != scissorState.x) {
                return false;
            }
            if (this.y != scissorState.y) {
                return false;
            }
            if (this.width != scissorState.width) {
                return false;
            }
            return this.height == scissorState.height;
        }
    }
}

