/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.axieum.mcmod.authme.impl.AuthMe;
import me.axieum.mcmod.authme.mixin.AbuseReportContextAccessor;
import me.axieum.mcmod.authme.mixin.MinecraftClientAccessor;
import me.axieum.mcmod.authme.mixin.RealmsAvailabilityAccessor;
import me.axieum.mcmod.authme.mixin.SplashTextResourceSupplierAccessor;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_4341;
import net.minecraft.class_5520;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7578;
import net.minecraft.class_7853;

public final class SessionUtils {
    public static final String OFFLINE_TOKEN = "invalidtoken";
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static class_320 getSession() {
        return class_310.method_1551().method_1548();
    }

    public static void setSession(class_320 session) {
        class_310 client = class_310.method_1551();
        ((MinecraftClientAccessor)client).setSession(session);
        ((SplashTextResourceSupplierAccessor)client.method_18095()).setSession(session);
        UserApiService userApiService = UserApiService.OFFLINE;
        if (!OFFLINE_TOKEN.equals(session.method_1674())) {
            userApiService = SessionUtils.getAuthService().createUserApiService(session.method_1674());
        }
        ((MinecraftClientAccessor)client).setUserApiService(userApiService);
        ((MinecraftClientAccessor)client).setSocialInteractionsManager(new class_5520(client, userApiService));
        ((MinecraftClientAccessor)client).setProfileKeys(class_7853.method_46532((UserApiService)userApiService, (class_320)session, (Path)client.field_1697.toPath()));
        ((MinecraftClientAccessor)client).setAbuseReportContext(class_7574.method_44599((class_7569)((AbuseReportContextAccessor)client.method_44377()).getEnvironment(), (UserApiService)userApiService));
        class_4341 realmsClient = class_4341.method_20989((class_310)client);
        ((MinecraftClientAccessor)client).setRealmsPeriodicCheckers(new class_7578(realmsClient));
        RealmsAvailabilityAccessor.setCurrentFuture(null);
        lastStatus = SessionStatus.UNKNOWN;
        lastStatusCheck = 0L;
        AuthMe.LOGGER.info("Minecraft session for {} (uuid={}) has been applied", (Object)session.method_1676(), (Object)session.method_44717());
    }

    public static class_320 offline(String username) {
        return new class_320(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()), OFFLINE_TOKEN, Optional.empty(), Optional.empty(), class_320.class_321.field_1990);
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            class_320 session = SessionUtils.getSession();
            String serverId = UUID.randomUUID().toString();
            YggdrasilMinecraftSessionService sessionService = SessionUtils.getSessionService();
            try {
                AuthMe.LOGGER.info("Verifying Minecraft session...");
                sessionService.joinServer(session.method_44717(), session.method_1674(), serverId);
                if (sessionService.hasJoinedServer(session.method_1676(), serverId, null) != null) {
                    AuthMe.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    AuthMe.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                AuthMe.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static YggdrasilMinecraftSessionService getSessionService() {
        return (YggdrasilMinecraftSessionService)class_310.method_1551().method_1495();
    }

    public static YggdrasilAuthenticationService getAuthService() {
        return ((MinecraftClientAccessor)class_310.method_1551()).getAuthenticationService();
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

