/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.image.ImageRendererManager;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;

public class YACLImageReloadListener
implements class_3302,
IdentifiableResourceReloadListener {
    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Map imageResources = resourceManager.method_14488("textures", location -> ImageRendererManager.PRELOADED_IMAGE_FACTORIES.stream().anyMatch(factory -> factory.predicate().test((class_2960)location)));
        if (imageResources.isEmpty()) {
            preparationBarrier.method_18352(null);
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(imageResources.size());
        for (Map.Entry entry : imageResources.entrySet()) {
            class_2960 location2 = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            ImageRendererFactory imageFactory = ImageRendererManager.PRELOADED_IMAGE_FACTORIES.stream().filter(factory -> factory.predicate().test(location2)).map(factory -> factory.factory().apply(location2)).findAny().orElseThrow();
            CompletionStage imageFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> ImageRendererManager.safelyPrepareFactory(location2, imageFactory), backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenApplyAsync(imageSupplierOpt -> {
                ImageRenderer imageRenderer;
                if (imageSupplierOpt.isEmpty()) {
                    return Optional.empty();
                }
                ImageRendererFactory.ImageSupplier supplier = (ImageRendererFactory.ImageSupplier)imageSupplierOpt.get();
                try {
                    imageRenderer = supplier.completeImage();
                }
                catch (Exception e) {
                    YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)location2, (Object)e);
                    return Optional.empty();
                }
                ImageRendererManager.PRELOADED_IMAGE_CACHE.put(location2, imageRenderer);
                return Optional.of(imageRenderer);
            }, gameExecutor);
            futures.add(imageFuture);
            ((CompletableFuture)imageFuture).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Failed to load image");
                    class_129 category = crashReport.method_562("YACL Gui");
                    category.method_578("Image identifier", (Object)location2.toString());
                    throw new class_148(crashReport);
                }
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public class_2960 getFabricId() {
        return YACLPlatform.rl("image_reload_listener");
    }
}

