/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="gammautils")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private boolean nightVisionEnabled = false;
    @ConfigEntry.Gui.Tooltip
    private int defaultGamma = 100;
    @ConfigEntry.Gui.Tooltip
    private int toggledGamma = 1500;
    @ConfigEntry.Gui.Tooltip
    private boolean updateToggle = false;
    @ConfigEntry.Gui.Tooltip
    private boolean smoothTransition = false;
    @ConfigEntry.Gui.Tooltip
    private boolean showStatusEffect = false;
    @ConfigEntry.Gui.CollapsibleObject
    private AdvancedOptionsObj advancedOptions = new AdvancedOptionsObj();

    public boolean isNightVisionEnabled() {
        return this.nightVisionEnabled;
    }

    public void setNightVision(boolean status) {
        this.nightVisionEnabled = status;
    }

    public double getDefaultGamma() {
        return (double)this.defaultGamma / 100.0;
    }

    public double getToggledGamma() {
        return (double)this.toggledGamma / 100.0;
    }

    public void setToggledGamma(double gamma) {
        this.toggledGamma = (int)Math.round(gamma * 100.0);
    }

    public double getGammaStep() {
        return (double)this.advancedOptions.gammaStep / 100.0;
    }

    public boolean isUpdateToggleEnabled() {
        return this.updateToggle;
    }

    public boolean isSmoothTransitionEnabled() {
        return this.smoothTransition;
    }

    public double getTransitionSpeed() {
        return (double)this.advancedOptions.transitionSpeed / 100.0;
    }

    public boolean isLimitCheckEnabled() {
        return this.advancedOptions.limitCheck;
    }

    public double getMinGamma() {
        return (double)this.advancedOptions.minGamma / 100.0;
    }

    public double getMaxGamma() {
        return (double)this.advancedOptions.maxGamma / 100.0;
    }

    public boolean isGammaMessageEnabled() {
        return this.advancedOptions.showMessage;
    }

    public boolean isStatusEffectEnabled() {
        return this.showStatusEffect;
    }

    public boolean isNightVisionIconEnabled() {
        return this.advancedOptions.showNightVisionIcon;
    }

    public boolean isResetOnCloseEnabled() {
        return this.advancedOptions.resetOnClose;
    }

    static class AdvancedOptionsObj {
        @ConfigEntry.Gui.Tooltip
        private int transitionSpeed = 4500;
        @ConfigEntry.Gui.Tooltip
        private boolean limitCheck = true;
        @ConfigEntry.Gui.Tooltip
        private int minGamma = -750;
        @ConfigEntry.Gui.Tooltip
        private int maxGamma = 1500;
        @ConfigEntry.Gui.Tooltip
        private int gammaStep = 10;
        @ConfigEntry.Gui.Tooltip
        private boolean showMessage = true;
        @ConfigEntry.Gui.Tooltip
        private boolean showNightVisionIcon = false;
        @ConfigEntry.Gui.Tooltip
        private boolean resetOnClose = false;

        AdvancedOptionsObj() {
        }
    }
}

