/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiLog;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_6367;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class EmiScreenshotRecorder {
    private static final String SCREENSHOTS_DIRNAME = "screenshots";

    public static void saveScreenshot(String path, int width, int height, Runnable renderer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer));
        } else {
            EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer);
        }
    }

    private static void saveScreenshotInner(String path, int width, int height, Runnable renderer) {
        class_310 client = class_310.method_1551();
        int scale = EmiConfig.recipeScreenshotScale < 1 ? EmiPort.getGuiScale(client) : EmiConfig.recipeScreenshotScale;
        class_6367 framebuffer = new class_6367(width * scale, height * scale, true, class_310.field_1703);
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.method_1230(class_310.field_1703);
        framebuffer.method_1235(true);
        Matrix4fStack view = RenderSystem.getModelViewStack();
        view.pushMatrix();
        view.identity();
        view.translate(-1.0f, 1.0f, 0.0f);
        view.scale(2.0f / (float)width, -2.0f / (float)height, -0.001f);
        view.translate(0.0f, 0.0f, 10.0f);
        RenderSystem.applyModelViewMatrix();
        Matrix4f backupProj = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().identity(), (class_8251)class_8251.field_43361);
        renderer.run();
        RenderSystem.setProjectionMatrix((Matrix4f)backupProj, (class_8251)class_8251.field_43361);
        view.popMatrix();
        RenderSystem.applyModelViewMatrix();
        framebuffer.method_1240();
        client.method_1522().method_1235(true);
        EmiScreenshotRecorder.saveScreenshotInner(client.field_1697, path, (class_276)framebuffer, (class_2561 message) -> client.execute(() -> client.field_1705.method_1743().method_1812(message)));
    }

    private static void saveScreenshotInner(File gameDirectory, String suggestedPath, class_276 framebuffer, Consumer<class_2561> messageReceiver) {
        class_1011 nativeImage = EmiScreenshotRecorder.takeScreenshot(framebuffer);
        File screenshots = new File(gameDirectory, SCREENSHOTS_DIRNAME);
        screenshots.mkdir();
        String filename = EmiScreenshotRecorder.getScreenshotFilename(screenshots, suggestedPath);
        File file = new File(screenshots, filename);
        File parent = file.getParentFile();
        parent.mkdirs();
        class_156.method_27958().execute(() -> {
            try {
                nativeImage.method_4325(file);
                class_5250 text = EmiPort.literal(filename, class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath())));
                messageReceiver.accept((class_2561)EmiPort.translatable("screenshot.success", text));
            }
            catch (Throwable e) {
                EmiLog.error("Failed to write screenshot");
                e.printStackTrace();
                messageReceiver.accept((class_2561)EmiPort.translatable("screenshot.failure", e.getMessage()));
            }
            finally {
                nativeImage.close();
            }
        });
    }

    private static class_1011 takeScreenshot(class_276 framebuffer) {
        int i = framebuffer.field_1482;
        int j = framebuffer.field_1481;
        class_1011 nativeImage = new class_1011(i, j, false);
        RenderSystem.bindTexture((int)framebuffer.method_30277());
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        return nativeImage;
    }

    private static String getScreenshotFilename(File directory, String path) {
        int i = 1;
        while (new File(directory, path + (String)(i == 1 ? "" : "_" + i) + ".png").exists()) {
            ++i;
        }
        return path + (String)(i == 1 ? "" : "_" + i) + ".png";
    }
}

