/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.jemi.JemiPlugin;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiIngredientAcceptor;
import dev.emi.emi.jemi.impl.JemiRecipeLayoutBuilder;
import dev.emi.emi.jemi.impl.JemiRecipeSlot;
import dev.emi.emi.jemi.impl.JemiRecipeSlotBuilder;
import dev.emi.emi.jemi.widget.JemiSlotWidget;
import dev.emi.emi.jemi.widget.JemiTankWidget;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.focus.FocusGroup;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class JemiRecipe<T>
implements EmiRecipe {
    public List<EmiIngredient> inputs = Lists.newArrayList();
    public List<EmiIngredient> catalysts = Lists.newArrayList();
    public List<EmiStack> outputs = Lists.newArrayList();
    public EmiRecipeCategory recipeCategory;
    public class_2960 originalId;
    public class_2960 id;
    public IRecipeCategory<T> category;
    public T recipe;
    public JemiRecipeLayoutBuilder builder = new JemiRecipeLayoutBuilder();
    public boolean allowTree = true;

    public JemiRecipe(EmiRecipeCategory recipeCategory, IRecipeCategory<T> category, T recipe) {
        this.recipeCategory = recipeCategory;
        this.category = category;
        this.recipe = recipe;
        this.originalId = category.getRegistryName(recipe);
        if (this.originalId != null) {
            this.id = new class_2960("jei", "/" + EmiUtil.subId(this.originalId));
        }
        category.setRecipe((IRecipeLayoutBuilder)this.builder, recipe, JemiPlugin.runtime.getJeiHelpers().getFocusFactory().getEmptyFocusGroup());
        for (JemiRecipeSlotBuilder jrsb : this.builder.slots) {
            jrsb.acceptor.coerceStacks(jrsb.tooltipCallback, jrsb.renderers);
        }
        for (JemiIngredientAcceptor acceptor : this.builder.ingredients) {
            EmiIngredient stack = acceptor.build();
            if (acceptor.role == RecipeIngredientRole.INPUT) {
                this.inputs.add(stack);
                continue;
            }
            if (acceptor.role == RecipeIngredientRole.CATALYST) {
                this.catalysts.add(stack);
                continue;
            }
            if (acceptor.role != RecipeIngredientRole.OUTPUT) continue;
            if (stack.getEmiStacks().size() > 1) {
                this.allowTree = false;
            }
            this.outputs.addAll(stack.getEmiStacks());
        }
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return this.recipeCategory;
    }

    @Override
    @Nullable
    public class_8786<?> getBackingRecipe() {
        return EmiPort.getRecipe(this.originalId);
    }

    @Override
    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    @Override
    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    @Override
    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public int getDisplayWidth() {
        return this.category.getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.category.getHeight();
    }

    @Override
    public boolean supportsRecipeTree() {
        return this.allowTree && EmiRecipe.super.supportsRecipeTree();
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        Optional opt = JemiPlugin.runtime.getRecipeManager().createRecipeLayoutDrawable(this.category, this.recipe, FocusGroup.EMPTY);
        JemiRecipeLayoutBuilder builder = new JemiRecipeLayoutBuilder();
        this.category.setRecipe((IRecipeLayoutBuilder)builder, this.recipe, JemiPlugin.runtime.getJeiHelpers().getFocusFactory().getEmptyFocusGroup());
        for (JemiRecipeSlotBuilder jrsb : builder.slots) {
            jrsb.acceptor.coerceStacks(jrsb.tooltipCallback, jrsb.renderers);
        }
        if (opt.isPresent()) {
            widgets.add(new JemiWidget(0, 0, this.getDisplayWidth(), this.getDisplayHeight(), (IRecipeLayoutDrawable)opt.get()));
            for (JemiRecipeSlotBuilder sb : builder.slots) {
                JemiRecipeSlot slot = new JemiRecipeSlot(sb);
                if (slot.tankInfo != null && !slot.getIngredients(JemiUtil.getFluidType()).toList().isEmpty()) {
                    widgets.add(new JemiTankWidget(slot, this));
                    continue;
                }
                widgets.add(new JemiSlotWidget(slot, this));
            }
        }
    }

    public class JemiWidget
    extends Widget {
        private final IRecipeLayoutDrawable<T> recipeLayoutDrawable;
        private final Bounds bounds;
        private final int x;
        private final int y;

        public JemiWidget(int x, int y, int w, int h, IRecipeLayoutDrawable<T> recipeLayoutDrawable) {
            this.recipeLayoutDrawable = recipeLayoutDrawable;
            this.bounds = new Bounds(x, y, w, h);
            this.x = x;
            this.y = y;
        }

        @Override
        public Bounds getBounds() {
            return this.bounds;
        }

        @Override
        public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
            EmiDrawContext context = EmiDrawContext.wrap(draw);
            context.push();
            context.matrices().method_46416((float)this.x, (float)this.y, 0.0f);
            JemiRecipe.this.category.getBackground().draw(context.raw());
            JemiRecipe.this.category.draw(JemiRecipe.this.recipe, this.recipeLayoutDrawable.getRecipeSlotsView(), context.raw(), (double)mouseX, (double)mouseY);
            context.resetColor();
            context.pop();
        }

        @Override
        public List<class_5684> getTooltip(int mouseX, int mouseY) {
            return JemiRecipe.this.category.getTooltipStrings(JemiRecipe.this.recipe, this.recipeLayoutDrawable.getRecipeSlotsView(), (double)mouseX, (double)mouseY).stream().map(t -> class_5684.method_32662((class_5481)t.method_30937())).toList();
        }

        @Override
        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            return JemiRecipe.this.category.handleInput(JemiRecipe.this.recipe, (double)mouseX, (double)mouseY, class_3675.class_307.field_1672.method_1447(button));
        }

        @Override
        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return JemiRecipe.this.category.handleInput(JemiRecipe.this.recipe, (double)EmiScreenManager.lastMouseX, (double)EmiScreenManager.lastMouseY, class_3675.method_15985((int)keyCode, (int)scanCode));
        }
    }
}

