/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.data.RecipeDefaults;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class RecipeDefaultLoader
extends class_4080<RecipeDefaults>
implements EmiResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static final class_2960 ID = new class_2960("emi:recipe_defaults");

    protected RecipeDefaults prepare(class_3300 manager, class_3695 profiler) {
        RecipeDefaults defaults = new RecipeDefaults();
        for (class_2960 id : EmiPort.findResources(manager, "recipe/defaults", i -> i.endsWith(".json"))) {
            if (!id.method_12836().equals("emi")) continue;
            try {
                for (class_3298 resource : manager.method_14489(id)) {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                    JsonObject json = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    RecipeDefaultLoader.loadDefaults(defaults, json);
                }
            }
            catch (Exception e) {
                EmiLog.error("Error loading recipe default file " + String.valueOf(id));
                e.printStackTrace();
            }
        }
        return defaults;
    }

    protected void apply(RecipeDefaults prepared, class_3300 manager, class_3695 profiler) {
        BoM.setDefaults(prepared);
    }

    @Override
    public class_2960 getEmiId() {
        return ID;
    }

    public static void loadDefaults(RecipeDefaults defaults, JsonObject json) {
        if (class_3518.method_15258((JsonObject)json, (String)"replace", (boolean)false)) {
            defaults.clear();
        }
        JsonArray disabled = class_3518.method_15292((JsonObject)json, (String)"disabled", (JsonArray)new JsonArray());
        for (Object el : disabled) {
            class_2960 id = new class_2960(el.getAsString());
            defaults.remove(id);
        }
        JsonArray added = class_3518.method_15292((JsonObject)json, (String)"added", (JsonArray)new JsonArray());
        if (class_3518.method_15264((JsonObject)json, (String)"recipes")) {
            added.addAll(class_3518.method_15261((JsonObject)json, (String)"recipes"));
        }
        for (Object el : added) {
            class_2960 id = new class_2960(el.getAsString());
            defaults.add(id);
        }
        JsonObject resolutions = class_3518.method_15281((JsonObject)json, (String)"resolutions", (JsonObject)new JsonObject());
        for (String key : resolutions.keySet()) {
            class_2960 id = new class_2960(key);
            if (!class_3518.method_15264((JsonObject)resolutions, (String)key)) continue;
            defaults.add(id, class_3518.method_15261((JsonObject)resolutions, (String)key));
        }
        JsonObject addedTags = class_3518.method_15281((JsonObject)json, (String)"tags", (JsonObject)new JsonObject());
        for (String key : addedTags.keySet()) {
            defaults.addTag((JsonElement)new JsonPrimitive(key), addedTags.get(key));
        }
    }
}

