/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.StackBatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5684;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ItemEmiStack
extends EmiStack
implements StackBatcher.Batchable {
    private static final class_310 client = class_310.method_1551();
    private final class_1792 item;
    private final class_9326 componentChanges;
    private boolean unbatchable;

    public ItemEmiStack(class_1799 stack) {
        this(stack, stack.method_7947());
    }

    public ItemEmiStack(class_1799 stack, long amount) {
        this(stack.method_7909(), stack.method_57380(), amount);
    }

    public ItemEmiStack(class_1792 item, class_9326 components, long amount) {
        this.item = item;
        this.componentChanges = components;
        this.amount = amount;
    }

    @Override
    public class_1799 getItemStack() {
        return new class_1799(EmiPort.getItemRegistry().method_47983((Object)this.item), (int)this.amount, this.componentChanges);
    }

    @Override
    public EmiStack copy() {
        ItemEmiStack e = new ItemEmiStack(this.item, this.componentChanges, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L || this.item == class_1802.field_8162;
    }

    @Override
    public class_9326 getComponentChanges() {
        return this.componentChanges;
    }

    @Override
    @Nullable
    public <T> T get(class_9331<? extends T> type) {
        Optional changedOpt = this.componentChanges.method_57845(type);
        if (changedOpt != null) {
            return changedOpt.orElse(null);
        }
        return (T)this.item.method_57347().method_57829(type);
    }

    @Override
    public Object getKey() {
        return this.item;
    }

    @Override
    public class_2960 getId() {
        return EmiPort.getItemRegistry().method_10221((Object)this.item);
    }

    @Override
    public void render(class_332 draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        class_1799 stack = this.getItemStack();
        if ((flags & 1) != 0) {
            class_308.method_24211();
            draw.method_51445(stack, x, y);
            draw.method_51432(ItemEmiStack.client.field_1772, stack, x, y, "");
        }
        if ((flags & 2) != 0) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, (class_2561)EmiPort.literal((String)count));
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public boolean isSideLit() {
        return client.method_1480().method_4019(this.getItemStack(), null, null, 0).method_24304();
    }

    @Override
    public boolean isUnbatchable() {
        class_1799 stack = this.getItemStack();
        return this.unbatchable || stack.method_7958() || stack.method_7986() || !EmiAgnos.canBatch(stack) || client.method_1480().method_4019(this.getItemStack(), null, null, 0).method_4713();
    }

    @Override
    public void setUnbatchable() {
        this.unbatchable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderForBatch(class_4597 vcp, class_332 draw, int x, int y, int z, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        class_1799 stack = this.getItemStack();
        class_918 ir = client.method_1480();
        class_1087 model = ir.method_4019(stack, null, null, 0);
        context.push();
        try {
            context.matrices().method_46416((float)x, (float)y, 100.0f + (float)z + (float)(model.method_4712() ? 50 : 0));
            context.matrices().method_22904(8.0, 8.0, 0.0);
            context.matrices().method_22905(16.0f, -16.0f, 16.0f);
            ir.method_23179(stack, class_811.field_4317, false, context.matrices(), vcp, 0xF000F0, class_4608.field_21444, model);
        }
        finally {
            context.pop();
        }
    }

    @Override
    public List<class_2561> getTooltipText() {
        return this.getItemStack().method_7950(class_1792.class_9635.field_51353, (class_1657)ItemEmiStack.client.field_1724, (class_1836)class_1836.field_41070);
    }

    @Override
    public List<class_5684> getTooltip() {
        class_1799 stack = this.getItemStack();
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            list.addAll(EmiAgnos.getItemTooltip(stack));
            list.addAll(super.getTooltip());
        }
        return list;
    }

    @Override
    public class_2561 getName() {
        if (this.isEmpty()) {
            return EmiPort.literal("");
        }
        return this.getItemStack().method_7964();
    }

    static class ItemEntry {
        ItemEntry() {
        }
    }
}

