/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5684;
import net.minecraft.class_9326;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FluidEmiStack
extends EmiStack {
    private final class_3611 fluid;
    private final class_9326 componentChanges;

    public FluidEmiStack(class_3611 fluid) {
        this(fluid, class_9326.field_49588);
    }

    public FluidEmiStack(class_3611 fluid, class_9326 componentChanges) {
        this(fluid, componentChanges, 0L);
    }

    public FluidEmiStack(class_3611 fluid, class_9326 componentChanges, long amount) {
        this.fluid = fluid;
        this.componentChanges = componentChanges;
        this.amount = amount;
    }

    @Override
    public EmiStack copy() {
        FluidEmiStack e = new FluidEmiStack(this.fluid, this.componentChanges, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public class_9326 getComponentChanges() {
        return class_9326.field_49588;
    }

    @Override
    public Object getKey() {
        return this.fluid;
    }

    @Override
    public class_2960 getId() {
        return EmiPort.getFluidRegistry().method_10221((Object)this.fluid);
    }

    @Override
    public void render(class_332 raw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        if ((flags & 1) != 0) {
            context.push();
            context.matrices().method_46416(0.0f, 0.0f, 100.0f);
            EmiAgnos.renderFluid(this, context.matrices(), x, y, delta);
            context.pop();
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public List<class_2561> getTooltipText() {
        return EmiAgnos.getFluidTooltip(this.fluid, this.componentChanges);
    }

    @Override
    public List<class_5684> getTooltip() {
        List<class_5684> list = this.getTooltipText().stream().map(EmiTooltipComponents::of).collect(Collectors.toList());
        if (this.amount > 1L) {
            list.add(EmiTooltipComponents.getAmount(this));
        }
        String namespace = EmiPort.getFluidRegistry().method_10221((Object)this.fluid).method_12836();
        EmiTooltipComponents.appendModName(list, namespace);
        list.addAll(super.getTooltip());
        return list;
    }

    @Override
    public class_2561 getName() {
        return EmiAgnos.getFluidName(this.fluid, this.componentChanges);
    }

    static class FluidEntry {
        FluidEntry() {
        }
    }
}

