/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.player;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1046;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.player.ETFPlayerEntity;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.mixin.accessor.FileCacheAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinProviderAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinTextureAccessor;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFPlayerTexture {
    public static final String SKIN_NAMESPACE = "etf_skin";
    public static class_1011 clientPlayerOriginalSkinImageForTool = null;
    public class_2960 baseEnchantIdentifier = null;
    public class_2960 baseEnchantBlinkIdentifier = null;
    public class_2960 baseEnchantBlink2Identifier = null;
    public class_2960 texturedNoseIdentifier = null;
    public class_2960 texturedNoseIdentifierEmissive = null;
    public class_2960 texturedNoseIdentifierEnchanted = null;
    public boolean hasVillagerNose = false;
    public boolean hasFeatures = false;
    public int coatStyle = 0;
    public int coatLength = 1;
    public int blinkType = 0;
    public int blinkHeight = 1;
    public boolean hasEmissives = false;
    public boolean hasEnchant = false;
    public ETFTexture etfTextureOfFinalBaseSkin;
    public ETFConfigScreenSkinTool.NoseType noseType = ETFConfigScreenSkinTool.NoseType.NONE;
    public ETFPlayerEntity player;
    public boolean wasForcedSolid = false;
    class_2960 coatIdentifier = null;
    class_2960 coatEmissiveIdentifier = null;
    class_2960 coatEnchantedIdentifier = null;
    boolean hasFatCoat = false;
    private boolean isTextureReady = false;
    private class_1011 originalSkin;
    private class_2960 normalVanillaSkinIdentifier = null;
    public static boolean remappingETFSkin = false;

    public ETFPlayerTexture(ETFPlayerEntity player, class_2960 rendererGivenSkin) {
        this.player = player;
        this.normalVanillaSkinIdentifier = rendererGivenSkin;
        if (player instanceof class_1657) {
            this.checkTexture(false);
        } else {
            try {
                class_1046 skin = (class_1046)((FileCacheAccessor)((PlayerSkinProviderAccessor)class_310.method_1551().method_1582()).getSkinCache()).getTextureManager().method_34590(rendererGivenSkin, null);
                FileInputStream fileInputStream = new FileInputStream(((PlayerSkinTextureAccessor)skin).getCacheFile());
                class_1011 vanilla = class_1011.method_4309((InputStream)fileInputStream);
                fileInputStream.close();
                this.originalSkin = ETFUtils2.emptyNativeImage(64, 64);
                this.originalSkin.method_4317(vanilla);
                vanilla.close();
                this.checkTexture(true);
            }
            catch (Exception e) {
                this.skinFailed();
            }
        }
    }

    private ETFPlayerTexture(class_2960 rendererGivenSkin) {
        this.player = null;
        this.normalVanillaSkinIdentifier = rendererGivenSkin;
    }

    public ETFPlayerTexture() {
        this.player = (ETFPlayerEntity)class_310.method_1551().field_1724;
        assert (this.player != null);
        if (this.player.etf$getEntity() != null) {
            assert (class_310.method_1551().field_1724 != null);
            class_1011 skin = ETFUtils2.getNativeImageElseNull(class_310.method_1551().field_1724.method_52814().comp_1626());
            if (skin != null) {
                clientPlayerOriginalSkinImageForTool = skin;
                this.changeSkinToThisForTool(skin);
                return;
            }
        }
        ETFUtils2.logError("ETFPlayerTexture went wrong");
    }

    @Nullable
    private static class_1011 returnMatchPixels(class_1011 baseSkin, int[] boundsToCheck) {
        return ETFPlayerTexture.returnMatchPixels(baseSkin, boundsToCheck, null);
    }

    @Nullable
    private static class_1011 returnMatchPixels(class_1011 baseSkin, int[] boundsToCheck, @Nullable class_1011 second) {
        class_1011 texture;
        if (baseSkin == null || boundsToCheck == null) {
            return null;
        }
        boolean hasSecondImageToBeUsedAsBase = second != null;
        HashSet<Integer> matchColors = new HashSet<Integer>();
        for (int x = boundsToCheck[0]; x <= boundsToCheck[2]; ++x) {
            for (int y = boundsToCheck[1]; y <= boundsToCheck[3]; ++y) {
                if (baseSkin.method_4311(x, y) == 0) continue;
                matchColors.add(baseSkin.method_4315(x, y));
            }
        }
        if (matchColors.isEmpty()) {
            return null;
        }
        if (!hasSecondImageToBeUsedAsBase) {
            texture = new class_1011(baseSkin.method_4307(), baseSkin.method_4323(), false);
            texture.method_4317(baseSkin);
        } else {
            texture = new class_1011(second.method_4307(), second.method_4323(), false);
            texture.method_4317(second);
        }
        for (int x = 0; x < texture.method_4307(); ++x) {
            for (int y = 0; y < texture.method_4323(); ++y) {
                if (matchColors.contains(texture.method_4315(x, y))) continue;
                texture.method_4305(x, y, 0);
            }
        }
        return ETFPlayerTexture.returnNullIfEmptyImage(texture);
    }

    @Nullable
    private static class_1011 returnNullIfEmptyImage(class_1011 imageToCheck) {
        boolean foundAPixel = false;
        block0: for (int x = 0; x < imageToCheck.method_4307(); ++x) {
            for (int y = 0; y < imageToCheck.method_4323(); ++y) {
                if (imageToCheck.method_4315(x, y) == 0) continue;
                foundAPixel = true;
                break block0;
            }
        }
        return foundAPixel ? imageToCheck : null;
    }

    private static int[] getSkinPixelBounds(String choiceKey) {
        int[] nArray;
        switch (choiceKey) {
            case "marker1": {
                int[] nArray2 = new int[4];
                nArray2[0] = 56;
                nArray2[1] = 16;
                nArray2[2] = 63;
                nArray = nArray2;
                nArray2[3] = 23;
                break;
            }
            case "marker2": {
                int[] nArray3 = new int[4];
                nArray3[0] = 56;
                nArray3[1] = 24;
                nArray3[2] = 63;
                nArray = nArray3;
                nArray3[3] = 31;
                break;
            }
            case "marker3": {
                int[] nArray4 = new int[4];
                nArray4[0] = 56;
                nArray4[1] = 32;
                nArray4[2] = 63;
                nArray = nArray4;
                nArray4[3] = 39;
                break;
            }
            case "marker4": {
                int[] nArray5 = new int[4];
                nArray5[0] = 56;
                nArray5[1] = 40;
                nArray5[2] = 63;
                nArray = nArray5;
                nArray5[3] = 47;
                break;
            }
            case "optimizedEyeSmall": {
                int[] nArray6 = new int[4];
                nArray6[0] = 12;
                nArray6[1] = 16;
                nArray6[2] = 19;
                nArray = nArray6;
                nArray6[3] = 16;
                break;
            }
            case "optimizedEye2High": {
                int[] nArray7 = new int[4];
                nArray7[0] = 12;
                nArray7[1] = 16;
                nArray7[2] = 19;
                nArray = nArray7;
                nArray7[3] = 17;
                break;
            }
            case "optimizedEye2High_second": {
                int[] nArray8 = new int[4];
                nArray8[0] = 12;
                nArray8[1] = 18;
                nArray8[2] = 19;
                nArray = nArray8;
                nArray8[3] = 19;
                break;
            }
            case "optimizedEye4High": {
                int[] nArray9 = new int[4];
                nArray9[0] = 12;
                nArray9[1] = 16;
                nArray9[2] = 19;
                nArray = nArray9;
                nArray9[3] = 19;
                break;
            }
            case "optimizedEye4High_second": {
                int[] nArray10 = new int[4];
                nArray10[0] = 36;
                nArray10[1] = 16;
                nArray10[2] = 43;
                nArray = nArray10;
                nArray10[3] = 19;
                break;
            }
            case "face1": {
                int[] nArray11 = new int[4];
                nArray11[0] = 0;
                nArray11[1] = 0;
                nArray11[2] = 7;
                nArray = nArray11;
                nArray11[3] = 7;
                break;
            }
            case "face2": {
                int[] nArray12 = new int[4];
                nArray12[0] = 24;
                nArray12[1] = 0;
                nArray12[2] = 31;
                nArray = nArray12;
                nArray12[3] = 7;
                break;
            }
            case "face3": {
                int[] nArray13 = new int[4];
                nArray13[0] = 32;
                nArray13[1] = 0;
                nArray13[2] = 39;
                nArray = nArray13;
                nArray13[3] = 7;
                break;
            }
            case "face4": {
                int[] nArray14 = new int[4];
                nArray14[0] = 56;
                nArray14[1] = 0;
                nArray14[2] = 63;
                nArray = nArray14;
                nArray14[3] = 7;
                break;
            }
            case "cape1": {
                int[] nArray15 = new int[4];
                nArray15[0] = 12;
                nArray15[1] = 32;
                nArray15[2] = 19;
                nArray = nArray15;
                nArray15[3] = 35;
                break;
            }
            case "cape2": {
                int[] nArray16 = new int[4];
                nArray16[0] = 36;
                nArray16[1] = 32;
                nArray16[2] = 43;
                nArray = nArray16;
                nArray16[3] = 35;
                break;
            }
            case "cape3": {
                int[] nArray17 = new int[4];
                nArray17[0] = 12;
                nArray17[1] = 48;
                nArray17[2] = 19;
                nArray = nArray17;
                nArray17[3] = 51;
                break;
            }
            case "cape4": {
                int[] nArray18 = new int[4];
                nArray18[0] = 28;
                nArray18[1] = 48;
                nArray18[2] = 35;
                nArray = nArray18;
                nArray18[3] = 51;
                break;
            }
            case "cape5": {
                int[] nArray19 = new int[4];
                nArray19[0] = 44;
                nArray19[1] = 48;
                nArray19[2] = 51;
                nArray = nArray19;
                nArray19[3] = 51;
                break;
            }
            case "cape5.1": {
                int[] nArray20 = new int[4];
                nArray20[0] = 44;
                nArray20[1] = 48;
                nArray20[2] = 45;
                nArray = nArray20;
                nArray20[3] = 51;
                break;
            }
            case "cape5.2": {
                int[] nArray21 = new int[4];
                nArray21[0] = 46;
                nArray21[1] = 48;
                nArray21[2] = 47;
                nArray = nArray21;
                nArray21[3] = 51;
                break;
            }
            case "cape5.3": {
                int[] nArray22 = new int[4];
                nArray22[0] = 48;
                nArray22[1] = 48;
                nArray22[2] = 49;
                nArray = nArray22;
                nArray22[3] = 51;
                break;
            }
            case "cape5.4": {
                int[] nArray23 = new int[4];
                nArray23[0] = 50;
                nArray23[1] = 48;
                nArray23[2] = 51;
                nArray = nArray23;
                nArray23[3] = 51;
                break;
            }
            case "capeVertL": {
                int[] nArray24 = new int[4];
                nArray24[0] = 1;
                nArray24[1] = 1;
                nArray24[2] = 1;
                nArray = nArray24;
                nArray24[3] = 16;
                break;
            }
            case "capeVertR": {
                int[] nArray25 = new int[4];
                nArray25[0] = 10;
                nArray25[1] = 1;
                nArray25[2] = 10;
                nArray = nArray25;
                nArray25[3] = 16;
                break;
            }
            case "capeHorizL": {
                int[] nArray26 = new int[4];
                nArray26[0] = 1;
                nArray26[1] = 1;
                nArray26[2] = 10;
                nArray = nArray26;
                nArray26[3] = 1;
                break;
            }
            case "capeHorizR": {
                int[] nArray27 = new int[4];
                nArray27[0] = 1;
                nArray27[1] = 16;
                nArray27[2] = 10;
                nArray = nArray27;
                nArray27[3] = 16;
                break;
            }
            default: {
                int[] nArray28 = new int[4];
                nArray28[0] = 0;
                nArray28[1] = 0;
                nArray28[2] = 0;
                nArray = nArray28;
                nArray28[3] = 0;
            }
        }
        return nArray;
    }

    private static class_1011 returnOptimizedBlinkFace(class_1011 baseSkin, int[] eyeBounds, int eyeHeightFromTopDown) {
        return ETFPlayerTexture.returnOptimizedBlinkFace(baseSkin, eyeBounds, eyeHeightFromTopDown, null);
    }

    private static class_1011 returnOptimizedBlinkFace(class_1011 baseSkin, int[] eyeBounds, int eyeHeightFromTopDown, int[] secondLayerBounds) {
        class_1011 texture = new class_1011(64, 64, false);
        texture.method_4317(baseSkin);
        ETFPlayerTexture.copyToPixels(baseSkin, texture, eyeBounds, 8, 8 + (eyeHeightFromTopDown - 1));
        if (secondLayerBounds != null) {
            ETFPlayerTexture.copyToPixels(baseSkin, texture, secondLayerBounds, 40, 8 + (eyeHeightFromTopDown - 1));
        }
        return texture;
    }

    private static void forceSolidLowerSkin(class_1011 skin) {
        try {
            ETFPlayerTexture.stripAlpha(skin, 8, 0, 23, 15);
            ETFPlayerTexture.stripAlpha(skin, 0, 20, 55, 31);
            ETFPlayerTexture.stripAlpha(skin, 0, 8, 7, 15);
            ETFPlayerTexture.stripAlpha(skin, 24, 8, 31, 15);
            ETFPlayerTexture.stripAlpha(skin, 0, 16, 11, 19);
            ETFPlayerTexture.stripAlpha(skin, 20, 16, 35, 19);
            ETFPlayerTexture.stripAlpha(skin, 44, 16, 51, 19);
            ETFPlayerTexture.stripAlpha(skin, 20, 48, 27, 51);
            ETFPlayerTexture.stripAlpha(skin, 36, 48, 43, 51);
            ETFPlayerTexture.stripAlpha(skin, 16, 52, 47, 63);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class_1011 getCoatTexture(class_1011 skin, int lengthOfCoat, boolean ignoreTopTexture) {
        class_1011 coat = new class_1011(64, 64, false);
        coat.method_4326(0, 0, 64, 64, 0);
        if (!ignoreTopTexture) {
            ETFPlayerTexture.copyToPixels(skin, coat, 4, 32, 7, 35 + lengthOfCoat, 20, 32);
            ETFPlayerTexture.copyToPixels(skin, coat, 4, 48, 7, 51 + lengthOfCoat, 24, 32);
        }
        ETFPlayerTexture.copyToPixels(skin, coat, 0, 36, 7, 36 + lengthOfCoat, 16, 36);
        ETFPlayerTexture.copyToPixels(skin, coat, 12, 36, 15, 36 + lengthOfCoat, 36, 36);
        ETFPlayerTexture.copyToPixels(skin, coat, 4, 52, 15, 52 + lengthOfCoat, 24, 36);
        return coat;
    }

    private static void copyToPixels(class_1011 source, class_1011 dest, int[] bounds, int copyToX, int CopyToY) {
        ETFPlayerTexture.copyToPixels(source, dest, bounds[0], bounds[1], bounds[2], bounds[3], copyToX, CopyToY);
    }

    private static void copyToPixels(class_1011 source, class_1011 dest, int x1, int y1, int x2, int y2, int copyToX, int copyToY) {
        int copyToXRelative = copyToX - x1;
        int copyToYRelative = copyToY - y1;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                dest.method_4305(x + copyToXRelative, y + copyToYRelative, source.method_4315(x, y));
            }
        }
    }

    private static void deletePixels(class_1011 source, int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                source.method_4305(x, y, 0);
            }
        }
    }

    public static int getSkinPixelColourToNumber(int color) {
        return switch (color) {
            case -65281 -> 1;
            case -256 -> 2;
            case -16776961 -> 3;
            case -16711936 -> 4;
            case -16760705 -> 5;
            case -65536 -> 6;
            case -16744449 -> 7;
            case -14483457 -> 8;
            case -12362096 -> 666;
            default -> color;
        };
    }

    public static int getSkinNumberToPixelColour(int color) {
        return switch (color) {
            case 1 -> -65281;
            case 2 -> -256;
            case 3 -> -16776961;
            case 4 -> -16711936;
            case 5 -> -16760705;
            case 6 -> -65536;
            case 7 -> -16744449;
            case 8 -> -14483457;
            case 666 -> -12362096;
            default -> color;
        };
    }

    public boolean isCorrectObjectForThisSkin(class_2960 check) {
        return check.equals((Object)this.normalVanillaSkinIdentifier);
    }

    @Nullable
    public class_2960 getBaseTextureIdentifierOrNullForVanilla(class_1657 player) {
        return this.getBaseTextureIdentifierOrNullForVanilla((ETFPlayerEntity)player);
    }

    @Nullable
    public class_2960 getBaseTextureIdentifierOrNullForVanilla(ETFPlayerEntity player) {
        this.player = player;
        if (this.etfTextureOfFinalBaseSkin != null && this.canUseFeaturesForThisPlayer()) {
            return this.etfTextureOfFinalBaseSkin.getTextureIdentifier(player);
        }
        return null;
    }

    @Nullable
    public class_2960 getBaseHeadTextureIdentifierOrNullForVanilla() {
        if (this.etfTextureOfFinalBaseSkin != null && this.canUseFeaturesForThisPlayer()) {
            return this.etfTextureOfFinalBaseSkin.getTextureIdentifier(null);
        }
        return null;
    }

    @Nullable
    public class_2960 getBaseTextureEmissiveIdentifierOrNullForNone() {
        if (this.hasEmissives && this.canUseFeaturesForThisPlayer() && this.etfTextureOfFinalBaseSkin != null) {
            return this.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public boolean canUseFeaturesForThisPlayer() {
        return this.isTextureReady && this.hasFeatures && (ETF.config().getConfig().enableEnemyTeamPlayersSkinFeatures || this.player.etf$isTeammate((class_1657)class_310.method_1551().field_1724) || this.player.etf$getScoreboardTeam() == null);
    }

    private void skinFailed() {
        if (!(class_310.method_1551().field_1755 instanceof ETFConfigScreenSkinTool)) {
            ETFManager.getInstance().PLAYER_TEXTURE_MAP.put(this.player.etf$getUuid(), new ETFPlayerTexture(this.normalVanillaSkinIdentifier));
        } else {
            ETFUtils2.logError("something went wrong applying skin in tool, or skin features are not added");
        }
    }

    public void checkTexture(boolean skipSkinLoad) {
        if (!skipSkinLoad) {
            try {
                class_1046 skin = (class_1046)((FileCacheAccessor)((PlayerSkinProviderAccessor)class_310.method_1551().method_1582()).getSkinCache()).getTextureManager().method_34590(this.normalVanillaSkinIdentifier, null);
                FileInputStream fileInputStream = new FileInputStream(((PlayerSkinTextureAccessor)skin).getCacheFile());
                remappingETFSkin = true;
                this.originalSkin = skin.method_22798(class_1011.method_4309((InputStream)fileInputStream));
                remappingETFSkin = false;
                fileInputStream.close();
                if (class_310.method_1551().field_1724 != null && this.player.etf$getUuid().equals(class_310.method_1551().field_1724.method_5667())) {
                    clientPlayerOriginalSkinImageForTool = this.originalSkin;
                }
            }
            catch (Exception e) {
                this.skinFailed();
                return;
            }
        }
        UUID id = this.player.etf$getUuid();
        class_1011 modifiedSkin = ETFUtils2.emptyNativeImage(this.originalSkin.method_4307(), this.originalSkin.method_4323());
        modifiedSkin.method_4317(this.originalSkin);
        if (this.originalSkin != null) {
            if (this.originalSkin.method_4315(1, 16) == -16776961 && this.originalSkin.method_4315(0, 16) == -16777089 && this.originalSkin.method_4315(0, 17) == -16776961 && this.originalSkin.method_4315(2, 16) == -16711936 && this.originalSkin.method_4315(3, 16) == -16744704 && this.originalSkin.method_4315(3, 17) == -16711936 && this.originalSkin.method_4315(0, 18) == -65536 && this.originalSkin.method_4315(0, 19) == -8454144 && this.originalSkin.method_4315(1, 19) == -65536 && this.originalSkin.method_4315(3, 18) == -1 && this.originalSkin.method_4315(2, 19) == -1 && this.originalSkin.method_4315(3, 18) == -1) {
                int[] boxChosenBounds;
                int blinkChoice;
                this.hasFeatures = true;
                ETFUtils2.logMessage("Found Player {" + this.player.etf$getName().getString() + "} with ETF texture features in skin.", false);
                int[] choiceBoxChoices = new int[]{ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 16)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 17)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 18)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 19)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(53, 16)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(53, 17)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(53, 18))};
                if (choiceBoxChoices[2] < 1 || choiceBoxChoices[2] > 8) {
                    choiceBoxChoices[2] = 1;
                }
                boolean noseUpper = ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(43, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(44, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(43, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(44, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(43, 15)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(44, 15)) == 666;
                boolean noseLower = ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(11, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(12, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(11, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(12, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(11, 15)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(12, 15)) == 666;
                this.hasVillagerNose = noseLower || noseUpper;
                boolean removeNosePixels = noseUpper;
                if (noseUpper) {
                    ETFPlayerTexture.deletePixels(modifiedSkin, 43, 13, 44, 15);
                }
                class_1011 noseTexture = null;
                int noseChoice = choiceBoxChoices[5];
                if (noseChoice >= 1 && noseChoice <= 9) {
                    if (noseChoice == 1 || noseChoice == 7 || noseChoice == 8 || noseChoice == 9) {
                        this.hasVillagerNose = true;
                        this.noseType = ETFConfigScreenSkinTool.NoseType.NONE.getByColorId(noseChoice);
                        if (noseChoice > 7) {
                            removeNosePixels = true;
                            ETFPlayerTexture.deletePixels(modifiedSkin, 43, 13, 44, 15);
                        }
                    } else {
                        int y;
                        int x;
                        noseTexture = ETFUtils2.emptyNativeImage(8, 8);
                        int[] bounds = switch (noseChoice) {
                            case 3 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_2;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape2");
                            }
                            case 4 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_3;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape3");
                            }
                            case 5 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_4;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape4");
                            }
                            case 6 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_5;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape5");
                            }
                            default -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_1;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape1");
                            }
                        };
                        int noseY = 0;
                        for (x = bounds[0]; x <= bounds[2]; ++x) {
                            int noseX = 0;
                            for (int y2 = bounds[1]; y2 <= bounds[3]; ++y2) {
                                noseTexture.method_4305(noseX, noseY, this.originalSkin.method_4315(x, y2));
                                ++noseX;
                            }
                            ++noseY;
                        }
                        for (x = 4; x < 8; ++x) {
                            for (y = 0; y < 8; ++y) {
                                noseTexture.method_4305(x, y, noseTexture.method_4315(7 - x, y));
                            }
                        }
                        for (x = 0; x < 8; ++x) {
                            for (y = 0; y < 4; ++y) {
                                int lowerColour = noseTexture.method_4315(x, y + 4);
                                noseTexture.method_4305(x, y + 4, noseTexture.method_4315(x, y));
                                noseTexture.method_4305(x, y, lowerColour);
                            }
                        }
                        this.texturedNoseIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_nose.png");
                        ETFUtils2.registerNativeImageToIdentifier(noseTexture, this.texturedNoseIdentifier);
                    }
                }
                class_1011 coatSkin = null;
                int controllerCoat = choiceBoxChoices[1];
                if (controllerCoat >= 1 && controllerCoat <= 8) {
                    this.coatStyle = controllerCoat;
                    int lengthOfCoat = choiceBoxChoices[2] - 1;
                    this.coatLength = lengthOfCoat + 1;
                    this.coatIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_coat.png");
                    coatSkin = ETFPlayerTexture.getCoatTexture(this.originalSkin, lengthOfCoat, controllerCoat >= 5);
                    ETFUtils2.registerNativeImageToIdentifier(coatSkin, this.coatIdentifier);
                    if (controllerCoat == 2 || controllerCoat == 4 || controllerCoat == 6 || controllerCoat == 8) {
                        ETFPlayerTexture.deletePixels(modifiedSkin, 4, 32, 7, 35);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 4, 48, 7, 51);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 0, 36, 15, 36 + lengthOfCoat);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 0, 52, 15, 52 + lengthOfCoat);
                    }
                    this.hasFatCoat = controllerCoat == 3 || controllerCoat == 4 || controllerCoat == 7 || controllerCoat == 8;
                } else {
                    this.coatIdentifier = null;
                }
                boolean bl = this.wasForcedSolid = choiceBoxChoices[6] == 1;
                if (this.wasForcedSolid) {
                    ETFPlayerTexture.forceSolidLowerSkin(modifiedSkin);
                }
                class_1011 blinkSkinFile = null;
                class_1011 blinkSkinFile2 = null;
                class_2960 blinkIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink.png");
                class_2960 blink2Identifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink2.png");
                this.blinkType = blinkChoice = choiceBoxChoices[0];
                if (blinkChoice >= 1 && blinkChoice <= 5) {
                    if (blinkChoice <= 2) {
                        if (removeNosePixels) {
                            ETFPlayerTexture.deletePixels(modifiedSkin, 35, 5, 36, 7);
                        }
                        blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("face1"), 1, ETFPlayerTexture.getSkinPixelBounds("face3"));
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                        if (blinkChoice == 2) {
                            if (removeNosePixels) {
                                ETFPlayerTexture.deletePixels(modifiedSkin, 59, 5, 60, 7);
                            }
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("face2"), 1, ETFPlayerTexture.getSkinPixelBounds("face4"));
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        }
                    } else {
                        int eyeHeightTopDown;
                        this.blinkHeight = eyeHeightTopDown = choiceBoxChoices[3];
                        if (eyeHeightTopDown > 8 || eyeHeightTopDown < 1) {
                            eyeHeightTopDown = 1;
                        }
                        if (blinkChoice == 3) {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEyeSmall"), eyeHeightTopDown);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                        } else if (blinkChoice == 4) {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye2High"), eyeHeightTopDown);
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye2High_second"), eyeHeightTopDown);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        } else {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye4High"), eyeHeightTopDown);
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye4High_second"), eyeHeightTopDown);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        }
                    }
                }
                if (blinkSkinFile == null) {
                    blinkIdentifier = null;
                }
                if (blinkSkinFile2 == null) {
                    blink2Identifier = null;
                }
                List<Integer> markerChoices = List.of(Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(1, 17))), Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(1, 18))), Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(2, 17))), Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(2, 18))));
                class_1011 emissiveImage = null;
                class_1011 emissiveBlinkImage = null;
                class_1011 emissiveBlink2Image = null;
                class_2960 emissiveIdentifier = null;
                class_2960 blinkEmissiveIdentifier = null;
                class_2960 blink2EmissiveIdentifier = null;
                this.hasEmissives = markerChoices.contains(1);
                if (this.hasEmissives) {
                    boxChosenBounds = ETFPlayerTexture.getSkinPixelBounds("marker" + (markerChoices.indexOf(1) + 1));
                    emissiveImage = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds);
                    if (emissiveImage != null) {
                        class_1011 checkNose;
                        class_1011 checkCoat;
                        emissiveIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_e.png");
                        ETFUtils2.registerNativeImageToIdentifier(emissiveImage, emissiveIdentifier);
                        if (blinkSkinFile != null && (emissiveBlinkImage = ETFPlayerTexture.returnMatchPixels(blinkSkinFile, boxChosenBounds)) != null) {
                            blinkEmissiveIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(emissiveBlinkImage, blinkEmissiveIdentifier);
                        }
                        if (blinkSkinFile2 != null && (emissiveBlink2Image = ETFPlayerTexture.returnMatchPixels(blinkSkinFile2, boxChosenBounds)) != null) {
                            blink2EmissiveIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink2_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(emissiveBlink2Image, blink2EmissiveIdentifier);
                        }
                        if (coatSkin != null && (checkCoat = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, coatSkin)) != null) {
                            this.coatEmissiveIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_coat_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCoat, this.coatEmissiveIdentifier);
                        }
                        if (noseTexture != null && (checkNose = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, noseTexture)) != null) {
                            this.texturedNoseIdentifierEmissive = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_nose_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkNose, this.texturedNoseIdentifierEmissive);
                        }
                    } else {
                        this.hasEmissives = false;
                    }
                }
                this.hasEnchant = markerChoices.contains(2);
                if (this.hasEnchant) {
                    boxChosenBounds = ETFPlayerTexture.getSkinPixelBounds("marker" + (markerChoices.indexOf(2) + 1));
                    class_1011 check = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds);
                    if (check != null) {
                        class_1011 checkNose;
                        class_1011 checkCoat;
                        class_1011 checkBlink;
                        this.baseEnchantIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_enchant.png");
                        ETFUtils2.registerNativeImageToIdentifier(check, this.baseEnchantIdentifier);
                        if (blinkSkinFile != null && (checkBlink = ETFPlayerTexture.returnMatchPixels(blinkSkinFile, boxChosenBounds)) != null) {
                            this.baseEnchantBlinkIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkBlink, this.baseEnchantBlinkIdentifier);
                        }
                        if (blinkSkinFile2 != null && (checkBlink = ETFPlayerTexture.returnMatchPixels(blinkSkinFile2, boxChosenBounds)) != null) {
                            this.baseEnchantBlink2Identifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink2_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkBlink, this.baseEnchantBlink2Identifier);
                        }
                        if (coatSkin != null && (checkCoat = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, coatSkin)) != null) {
                            this.coatEnchantedIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_coat_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCoat, this.coatEnchantedIdentifier);
                        }
                        if (noseTexture != null && (checkNose = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, noseTexture)) != null) {
                            this.texturedNoseIdentifierEnchanted = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_nose_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkNose, this.texturedNoseIdentifierEnchanted);
                        }
                    } else {
                        this.hasEnchant = false;
                    }
                }
                class_2960 modifiedSkinBlinkPatchedIdentifier = null;
                class_2960 modifiedSkinPatchedIdentifier = null;
                class_2960 modifiedSkinBlink2PatchedIdentifier = null;
                if (this.hasEmissives && emissiveImage != null) {
                    modifiedSkinPatchedIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_e_patched.png");
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(modifiedSkin, emissiveImage);
                    ETFUtils2.registerNativeImageToIdentifier(modifiedSkin, modifiedSkinPatchedIdentifier);
                    if (blinkSkinFile != null) {
                        modifiedSkinBlinkPatchedIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink_e_patched.png");
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(blinkSkinFile, emissiveBlinkImage);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, modifiedSkinBlinkPatchedIdentifier);
                    }
                    if (blinkSkinFile2 != null) {
                        modifiedSkinBlink2PatchedIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + "_blink2_e_patched.png");
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(blinkSkinFile2, emissiveBlink2Image);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, modifiedSkinBlink2PatchedIdentifier);
                    }
                }
                class_2960 modifiedSkinIdentifier = new class_2960(SKIN_NAMESPACE, String.valueOf(id) + ".png");
                ETFUtils2.registerNativeImageToIdentifier(modifiedSkin, modifiedSkinIdentifier);
                this.etfTextureOfFinalBaseSkin = new ETFTexture(modifiedSkinIdentifier, blinkIdentifier, blink2Identifier, emissiveIdentifier, blinkEmissiveIdentifier, blink2EmissiveIdentifier, this.baseEnchantIdentifier, this.baseEnchantBlinkIdentifier, this.baseEnchantBlink2Identifier, modifiedSkinPatchedIdentifier, modifiedSkinBlinkPatchedIdentifier, modifiedSkinBlink2PatchedIdentifier);
                if (this.normalVanillaSkinIdentifier != null) {
                    ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.normalVanillaSkinIdentifier, (Object)this.etfTextureOfFinalBaseSkin);
                }
            } else {
                this.skinFailed();
            }
        } else {
            this.skinFailed();
        }
        this.isTextureReady = true;
    }

    public void changeSkinToThisForTool(class_1011 image) {
        this.baseEnchantBlinkIdentifier = null;
        this.baseEnchantIdentifier = null;
        this.coatEmissiveIdentifier = null;
        this.coatEnchantedIdentifier = null;
        this.baseEnchantBlink2Identifier = null;
        this.etfTextureOfFinalBaseSkin = null;
        this.coatIdentifier = null;
        this.hasEmissives = false;
        this.hasEnchant = false;
        this.hasFatCoat = false;
        this.hasFeatures = false;
        this.hasVillagerNose = false;
        this.isTextureReady = false;
        this.coatStyle = 0;
        this.coatLength = 1;
        this.blinkHeight = 1;
        this.blinkType = 0;
        this.texturedNoseIdentifier = null;
        this.texturedNoseIdentifierEmissive = null;
        this.texturedNoseIdentifierEnchanted = null;
        this.noseType = ETFConfigScreenSkinTool.NoseType.NONE;
        this.originalSkin = image;
        this.checkTexture(true);
        if (this.etfTextureOfFinalBaseSkin != null) {
            this.etfTextureOfFinalBaseSkin.setGUIBlink();
        }
    }

    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                image.method_4305(i, j, image.method_4315(i, j) | 0xFF000000);
            }
        }
    }
}

