/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import me.flashyreese.mods.fabricskyboxes_interop.utils.ResourceManagerHelper;
import net.minecraft.class_151;
import net.minecraft.class_2960;

public final class Utils {
    private static final Pattern OPTIFINE_RANGE_SEPARATOR = Pattern.compile("(\\d|\\))-(\\d|\\()");

    public static JsonObject convertOptiFineSkyProperties(ResourceManagerHelper resourceManagerHelper, Properties properties, class_2960 propertiesIdentifier) {
        List<MinMaxEntry> minMaxEntries;
        List<MinMaxEntry> minMaxEntries2;
        String blend;
        JsonObject jsonObject = new JsonObject();
        class_2960 sourceTexture = Utils.parseSourceTexture(properties.getProperty("source", null), resourceManagerHelper, propertiesIdentifier);
        if (sourceTexture == null) {
            return null;
        }
        jsonObject.addProperty("source", sourceTexture.toString());
        if (properties.containsKey("blend") && (blend = properties.getProperty("blend")) != null) {
            jsonObject.addProperty("blend", blend);
        }
        JsonObject fade = new JsonObject();
        if (properties.containsKey("startFadeIn") && properties.containsKey("endFadeIn") && properties.containsKey("endFadeOut")) {
            int startFadeOut;
            int startFadeIn = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("startFadeIn"))).intValue();
            int endFadeIn = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("endFadeIn"))).intValue();
            int endFadeOut = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("endFadeOut"))).intValue();
            if (properties.containsKey("startFadeOut")) {
                startFadeOut = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("startFadeOut"))).intValue();
            } else {
                startFadeOut = endFadeOut - (endFadeIn - startFadeIn);
                if (startFadeIn <= startFadeOut && endFadeIn >= startFadeOut) {
                    startFadeOut = endFadeOut;
                }
            }
            fade.addProperty("startFadeIn", (Number)Utils.normalizeTickTime(startFadeIn));
            fade.addProperty("endFadeIn", (Number)Utils.normalizeTickTime(endFadeIn));
            fade.addProperty("startFadeOut", (Number)Utils.normalizeTickTime(startFadeOut));
            fade.addProperty("endFadeOut", (Number)Utils.normalizeTickTime(endFadeOut));
        } else {
            fade.addProperty("alwaysOn", Boolean.valueOf(true));
        }
        jsonObject.add("fade", (JsonElement)fade);
        if (properties.containsKey("speed")) {
            float speed = Float.parseFloat(properties.getProperty("speed", "1")) * -1.0f;
            jsonObject.addProperty("speed", (Number)Float.valueOf(speed));
        }
        if (properties.containsKey("rotate")) {
            boolean rotate = Boolean.parseBoolean(properties.getProperty("rotate", "true"));
            jsonObject.addProperty("rotate", Boolean.valueOf(rotate));
        }
        if (properties.containsKey("transition")) {
            int transition = Integer.parseInt(properties.getProperty("transition", "1"));
            jsonObject.addProperty("transition", (Number)transition);
        }
        JsonArray jsonAxis = new JsonArray();
        if (properties.containsKey("axis")) {
            String[] axis = properties.getProperty("axis").trim().replaceAll(" +", " ").split(" ");
            List<String> rev = Arrays.asList(axis);
            for (String a : axis = rev.toArray(axis)) {
                jsonAxis.add((Number)Float.valueOf(Float.parseFloat(a)));
            }
            jsonObject.add("axis", (JsonElement)jsonAxis);
        }
        if (properties.containsKey("weather")) {
            String[] weathers = properties.getProperty("weather").split(" ");
            JsonArray jsonWeather = new JsonArray();
            if (weathers.length > 0) {
                for (String weather : weathers) {
                    jsonWeather.add(weather);
                }
            } else {
                jsonWeather.add("clear");
            }
            jsonObject.add("weathers", (JsonElement)jsonWeather);
        }
        if (properties.containsKey("biomes")) {
            String[] biomes;
            String biomesString = properties.getProperty("biomes");
            if (biomesString.startsWith("!")) {
                jsonObject.addProperty("biomeInclusion", Boolean.valueOf(false));
                biomesString = biomesString.substring(1);
            }
            if ((biomes = biomesString.split(" ")).length > 0) {
                JsonArray jsonBiomes = new JsonArray();
                for (String biome : biomes) {
                    jsonBiomes.add(biome);
                }
                jsonObject.add("biomes", (JsonElement)jsonBiomes);
            }
        }
        if (properties.containsKey("heights") && !(minMaxEntries2 = Utils.parseMinMaxEntriesNegative(properties.getProperty("heights"))).isEmpty()) {
            JsonArray jsonYRanges = new JsonArray();
            minMaxEntries2.forEach(minMaxEntry -> {
                JsonObject minMax = new JsonObject();
                minMax.addProperty("min", (Number)Float.valueOf(minMaxEntry.getMin()));
                minMax.addProperty("max", (Number)Float.valueOf(minMaxEntry.getMax()));
                jsonYRanges.add((JsonElement)minMax);
            });
            jsonObject.add("heights", (JsonElement)jsonYRanges);
        }
        if (properties.containsKey("days") && !(minMaxEntries = Utils.parseMinMaxEntries(properties.getProperty("days"))).isEmpty()) {
            JsonObject loopObject = new JsonObject();
            JsonArray loopRange = new JsonArray();
            minMaxEntries.forEach(minMaxEntry -> {
                JsonObject minMax = new JsonObject();
                minMax.addProperty("min", (Number)Float.valueOf(minMaxEntry.getMin()));
                minMax.addProperty("max", (Number)Float.valueOf(minMaxEntry.getMax()));
                loopRange.add((JsonElement)minMax);
            });
            int value = 8;
            if (properties.containsKey("daysLoop")) {
                value = Utils.parseInt(properties.getProperty("daysLoop"), 8);
            }
            loopObject.addProperty("days", (Number)value);
            loopObject.add("ranges", (JsonElement)loopRange);
            jsonObject.add("loop", (JsonElement)loopObject);
        }
        return jsonObject;
    }

    public static class_2960 parseSourceTexture(String source, ResourceManagerHelper resourceManagerHelper, class_2960 propertiesId) {
        class_2960 textureId;
        String path;
        String namespace;
        if (source == null) {
            namespace = propertiesId.method_12836();
            path = propertiesId.method_12832().replace(".properties", ".png");
        } else if (source.startsWith("./")) {
            namespace = propertiesId.method_12836();
            String fileName = propertiesId.method_12832().split("/")[propertiesId.method_12832().split("/").length - 1];
            path = propertiesId.method_12832().replace(fileName, source.substring(2));
        } else {
            String[] parts = source.split("/", 3);
            if (parts.length == 3 && parts[0].equals("assets")) {
                namespace = parts[1];
                path = parts[2];
            } else {
                class_2960 sourceIdentifier = class_2960.method_12829((String)source);
                if (sourceIdentifier != null) {
                    namespace = sourceIdentifier.method_12836();
                    path = sourceIdentifier.method_12832();
                } else {
                    return null;
                }
            }
        }
        try {
            textureId = new class_2960(namespace, path);
        }
        catch (class_151 e) {
            return null;
        }
        InputStream textureInputStream = resourceManagerHelper.getInputStream(textureId);
        if (textureInputStream == null) {
            return null;
        }
        return textureId;
    }

    public static Number toTickTime(String time) {
        String[] parts = time.split(":");
        if (parts.length != 2) {
            return null;
        }
        int h = Integer.parseInt(parts[0]);
        int m = Integer.parseInt(parts[1]);
        return Float.valueOf((float)(h * 1000) + (float)m / 0.06f - 6000.0f);
    }

    public static int normalizeTickTime(int tickTime) {
        int result = tickTime % 24000;
        if (result < 0) {
            result += 24000;
        }
        return result;
    }

    public static List<MinMaxEntry> parseMinMaxEntries(String str) {
        String[] strings;
        ArrayList<MinMaxEntry> minMaxEntries = new ArrayList<MinMaxEntry>();
        for (String s : strings = str.split(" ,")) {
            MinMaxEntry minMaxEntry = Utils.parseMinMaxEntry(s);
            if (minMaxEntry == null) continue;
            minMaxEntries.add(minMaxEntry);
        }
        return minMaxEntries;
    }

    private static MinMaxEntry parseMinMaxEntry(String str) {
        if (str != null) {
            if (str.contains("-")) {
                String[] strings = str.split("-");
                if (strings.length == 2) {
                    int min = Utils.parseInt(strings[0], -1);
                    int max = Utils.parseInt(strings[1], -1);
                    if (min >= 0 && max >= 0) {
                        return new MinMaxEntry((float)min, (float)max);
                    }
                }
            } else {
                int value = Utils.parseInt(str, -1);
                if (value >= 0) {
                    return new MinMaxEntry((float)value, (float)value);
                }
            }
        }
        return null;
    }

    public static List<MinMaxEntry> parseMinMaxEntriesNegative(String str) {
        String[] strings;
        ArrayList<MinMaxEntry> minMaxEntries = new ArrayList<MinMaxEntry>();
        for (String s : strings = str.split(" ,")) {
            MinMaxEntry minMaxEntry = Utils.parseMinMaxEntryNegative(s);
            if (minMaxEntry == null) continue;
            minMaxEntries.add(minMaxEntry);
        }
        return minMaxEntries;
    }

    private static MinMaxEntry parseMinMaxEntryNegative(String str) {
        if (str != null) {
            String s = OPTIFINE_RANGE_SEPARATOR.matcher(str).replaceAll("$1=$2");
            if (s.contains("=")) {
                String[] strings = s.split("=");
                if (strings.length == 2) {
                    int j = Utils.parseInt(Utils.stripBrackets(strings[0]), Integer.MIN_VALUE);
                    int k = Utils.parseInt(Utils.stripBrackets(strings[1]), Integer.MIN_VALUE);
                    if (j != Integer.MIN_VALUE && k != Integer.MIN_VALUE) {
                        int min = Math.min(j, k);
                        int max = Math.max(j, k);
                        return new MinMaxEntry((float)min, (float)max);
                    }
                }
            } else {
                int i = Utils.parseInt(Utils.stripBrackets(str), Integer.MIN_VALUE);
                if (i != Integer.MIN_VALUE) {
                    return new MinMaxEntry((float)i, (float)i);
                }
            }
        }
        return null;
    }

    private static String stripBrackets(String str) {
        return str.startsWith("(") && str.endsWith(")") ? str.substring(1, str.length() - 1) : str;
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

