/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.amerebagatelle.fabricskyboxes.SkyboxManager;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.flashyreese.mods.fabricskyboxes_interop.client.config.FSBInteropConfig;
import me.flashyreese.mods.fabricskyboxes_interop.client.config.FSBInteropMode;
import me.flashyreese.mods.fabricskyboxes_interop.mixin.SkyboxManagerAccessor;
import me.flashyreese.mods.fabricskyboxes_interop.sky.OptiFineCustomSky;
import me.flashyreese.mods.fabricskyboxes_interop.utils.BlenderUtil;
import me.flashyreese.mods.fabricskyboxes_interop.utils.ResourceManagerHelper;
import me.flashyreese.mods.fabricskyboxes_interop.utils.Utils;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBInterop {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String OPTIFINE_SKY_PARENT = "optifine/sky";
    private static final Pattern OPTIFINE_SKY_PATTERN = Pattern.compile("optifine/sky/(?<world>\\w+)/(?<name>\\w+).properties$");
    private static final String MCPATCHER_SKY_PARENT = "mcpatcher/sky";
    private static final Pattern MCPATCHER_SKY_PATTERN = Pattern.compile("mcpatcher/sky/(?<world>\\w+)/(?<name>\\w+).properties$");
    private static FSBInterop INSTANCE;
    private final Map<class_2960, String> convertedSkyMap = new HashMap<class_2960, String>();
    private final Logger logger = LoggerFactory.getLogger((String)"FSB-Interop");

    public static FSBInterop getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FSBInterop();
        }
        return INSTANCE;
    }

    public Map<class_2960, String> getConvertedSkyMap() {
        return this.convertedSkyMap;
    }

    public void inject(class_3300 manager) {
        this.convertedSkyMap.clear();
        if (FSBInteropConfig.INSTANCE.interoperability) {
            if (FSBInteropConfig.INSTANCE.preferFSBNative) {
                if (!((SkyboxManagerAccessor)SkyboxManager.getInstance()).getSkyboxes().isEmpty()) {
                    this.logger.info("FSB Native is preferred and existing skyboxes already detected! No longer converting MCP/OptiFine formats!");
                    return;
                }
            } else {
                this.logger.warn("FSB-Interop is preventing native FabricSkyBoxes resource packs from loading!");
            }
            this.logger.warn("Removing existing FSB skies...");
            this.logger.warn("FSB-Interop is converting MCPatcher/OptiFine custom skies resource packs! Any visual bugs are likely caused by FSB-Interop. Please do not report these issues to FabricSkyBoxes nor Resource Pack creators!");
            SkyboxManager.getInstance().clearSkyboxes();
            this.logger.info("Looking for OptiFine/MCPatcher Skies...");
            this.convert(new ResourceManagerHelper(manager));
        }
    }

    public void convert(ResourceManagerHelper managerAccessor) {
        if (FSBInteropConfig.INSTANCE.processOptiFine) {
            this.convertNamespace(managerAccessor, OPTIFINE_SKY_PARENT, OPTIFINE_SKY_PATTERN);
        }
        if (FSBInteropConfig.INSTANCE.processMCPatcher) {
            this.convertNamespace(managerAccessor, MCPATCHER_SKY_PARENT, MCPATCHER_SKY_PATTERN);
        }
    }

    private void convertNamespace(ResourceManagerHelper resourceManagerHelper, String skyParent, Pattern pattern) {
        AtomicBoolean hasGeneratedOverworldSky = new AtomicBoolean();
        AtomicBoolean hasGeneratedEndSky = new AtomicBoolean();
        JsonArray overworldLayers = new JsonArray();
        JsonArray endLayers = new JsonArray();
        resourceManagerHelper.searchIn(skyParent).filter(id -> id.method_12832().endsWith(".properties")).sorted(Comparator.comparing(class_2960::method_12832, (id1, id2) -> {
            Matcher matcherId1 = pattern.matcher((CharSequence)id1);
            Matcher matcherId2 = pattern.matcher((CharSequence)id2);
            if (matcherId1.find() && matcherId2.find()) {
                int id1No = Utils.parseInt(matcherId1.group("name").replace("sky", ""), -1);
                int id2No = Utils.parseInt(matcherId2.group("name").replace("sky", ""), -1);
                if (id1No >= 0 && id2No >= 0) {
                    return id1No - id2No;
                }
            }
            return 0;
        })).forEach(id -> {
            Matcher matcher = pattern.matcher(id.method_12832());
            if (matcher.find()) {
                JsonObject json;
                String world = matcher.group("world");
                String name = matcher.group("name");
                if (world == null || name == null) {
                    return;
                }
                if (name.equals("moon_phases") || name.equals("sun")) {
                    this.logger.info("Skipping {}, moon_phases/sun aren't supported!", id);
                    return;
                }
                this.logger.info("Converting {} to FSB Format...", id);
                InputStream inputStream = resourceManagerHelper.getInputStream((class_2960)id);
                if (inputStream == null) {
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.error("Error trying to read namespaced identifier: {}", id);
                    }
                    return;
                }
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.error("Error trying to read namespaced identifier: {}", id);
                    }
                    return;
                }
                finally {
                    block26: {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            if (!FSBInteropConfig.INSTANCE.debugMode) break block26;
                            this.logger.error("Error trying to close input stream at namespaced identifier: {}", id);
                        }
                    }
                }
                if (FSBInteropConfig.INSTANCE.mode == FSBInteropMode.CONVERSION) {
                    if (!hasGeneratedOverworldSky.get() && world.equals("world0")) {
                        this.generateSky("minecraft:overworld", "overworld");
                        this.generateOverworldDecorations();
                        hasGeneratedOverworldSky.set(true);
                    }
                    if (!hasGeneratedEndSky.get() && world.equals("world1")) {
                        this.generateSky("minecraft:the_end", "end");
                        hasGeneratedEndSky.set(true);
                    }
                    this.convert(resourceManagerHelper, skyParent, name, (class_2960)id, properties, world);
                } else if (FSBInteropConfig.INSTANCE.mode == FSBInteropMode.NATIVE && (json = Utils.convertOptiFineSkyProperties(resourceManagerHelper, properties, id)) != null) {
                    if (world.equals("world0")) {
                        overworldLayers.add((JsonElement)json);
                    } else if (world.equals("world1")) {
                        endLayers.add((JsonElement)json);
                    }
                }
            }
        });
        if (FSBInteropConfig.INSTANCE.mode == FSBInteropMode.NATIVE) {
            Skybox skybox;
            if (!overworldLayers.isEmpty()) {
                JsonObject overworldJson = new JsonObject();
                overworldJson.addProperty("schemaVersion", (Number)2);
                overworldJson.addProperty("type", "optifine-custom-sky");
                overworldJson.add("layers", (JsonElement)overworldLayers);
                overworldJson.addProperty("world", "minecraft:overworld");
                skybox = (Skybox)((Pair)OptiFineCustomSky.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)overworldJson).getOrThrow()).getFirst();
                SkyboxManager.getInstance().addSkybox(class_2960.method_43902((String)"fsb-interop", (String)"native-optifine-custom-sky-overworld"), skybox);
            }
            if (!endLayers.isEmpty()) {
                JsonObject endJson = new JsonObject();
                endJson.addProperty("schemaVersion", (Number)2);
                endJson.addProperty("type", "optifine-custom-sky");
                endJson.add("layers", (JsonElement)endLayers);
                endJson.addProperty("world", "minecraft:the_end");
                skybox = (Skybox)((Pair)OptiFineCustomSky.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)endJson).getOrThrow()).getFirst();
                SkyboxManager.getInstance().addSkybox(class_2960.method_43902((String)"fsb-interop", (String)"native-optifine-custom-sky-end"), skybox);
            }
        }
    }

    private void convert(ResourceManagerHelper resourceManagerHelper, String skyParent, String skyName, class_2960 propertiesId, Properties properties, String world) {
        class_2960 textureId;
        Object path;
        String namespace;
        JsonObject blend = new JsonObject();
        String blendType = properties.getProperty("blend", "add");
        blend.addProperty("type", "custom");
        blend.add("blender", (JsonElement)GSON.toJsonTree((Object)BlenderUtil.getInstance().BLEND_MAP.getOrDefault(blendType, BlenderUtil.getInstance().BLEND_MAP.get("add"))).getAsJsonObject());
        String source = properties.getProperty("source");
        if (source == null) {
            namespace = propertiesId.method_12836();
            path = String.format("%s/%s/%s.png", skyParent, world, skyName);
        } else if (source.startsWith("./")) {
            namespace = propertiesId.method_12836();
            path = skyParent + String.format("/%s/%s", world, source.substring(2));
        } else {
            String[] parts = source.split("/", 3);
            if (parts.length == 3 && parts[0].equals("assets")) {
                namespace = parts[1];
                path = parts[2];
            } else {
                class_2960 sourceIdentifier = class_2960.method_12829((String)source);
                if (sourceIdentifier != null) {
                    namespace = sourceIdentifier.method_12836();
                    path = sourceIdentifier.method_12832();
                } else {
                    this.logger.error("Invalid source format: {}", (Object)source);
                    return;
                }
            }
        }
        try {
            textureId = new class_2960(namespace, (String)path);
        }
        catch (class_151 e) {
            this.logger.error("Illegal character in namespaced identifier: {}", (Object)source);
            return;
        }
        InputStream textureInputStream = resourceManagerHelper.getInputStream(textureId);
        if (textureInputStream == null) {
            this.logger.error("Unable to find/read namespaced identifier: {}", (Object)textureId);
            return;
        }
        JsonObject propertiesObject = new JsonObject();
        this.processProperties(propertiesObject, properties, skyName);
        JsonObject conditionsObject = new JsonObject();
        this.processConditions(conditionsObject, properties, world);
        JsonObject json = new JsonObject();
        json.addProperty("schemaVersion", (Number)2);
        json.addProperty("type", "single-sprite-square-textured");
        json.addProperty("texture", textureId.toString());
        json.add("blend", (JsonElement)blend);
        json.add("properties", (JsonElement)propertiesObject);
        json.add("conditions", (JsonElement)conditionsObject);
        if (FSBInteropConfig.INSTANCE.debugMode) {
            this.logger.info("Output for {} conversion:\n{}", (Object)propertiesId, (Object)GSON.toJson((JsonElement)json));
        }
        SkyboxManager.getInstance().addSkybox(propertiesId, json);
        this.convertedSkyMap.put(propertiesId, GSON.toJson((JsonElement)json));
        this.logger.info("Converted & Added Skybox from {}!", (Object)propertiesId);
    }

    private void generateSky(String dimension, String type) {
        JsonObject fade = new JsonObject();
        fade.addProperty("alwaysOn", Boolean.valueOf(true));
        JsonArray worlds = new JsonArray();
        worlds.add(dimension);
        JsonObject conditions = new JsonObject();
        conditions.add("worlds", (JsonElement)worlds);
        JsonObject properties = new JsonObject();
        properties.addProperty("priority", (Number)Integer.MIN_VALUE);
        properties.add("fade", (JsonElement)fade);
        JsonObject json = new JsonObject();
        json.addProperty("schemaVersion", (Number)2);
        json.addProperty("type", type);
        json.add("properties", (JsonElement)properties);
        json.add("conditions", (JsonElement)conditions);
        if (FSBInteropConfig.INSTANCE.debugMode) {
            this.logger.info("Generated {} skybox:\n{}", (Object)dimension, (Object)GSON.toJson((JsonElement)json));
        }
        class_2960 identifier = class_2960.method_43902((String)"fabricskyboxes-interop", (String)type);
        SkyboxManager.getInstance().addSkybox(identifier, json);
        this.convertedSkyMap.put(identifier, GSON.toJson((JsonElement)json));
        this.logger.info("Added generated {} skybox!", (Object)dimension);
    }

    private void generateOverworldDecorations() {
        JsonObject blend = new JsonObject();
        blend.addProperty("type", "replace");
        blend.add("blender", (JsonElement)GSON.toJsonTree((Object)BlenderUtil.getInstance().BLEND_MAP.get("replace")).getAsJsonObject());
        JsonObject fade = new JsonObject();
        fade.addProperty("alwaysOn", Boolean.valueOf(true));
        JsonArray worlds = new JsonArray();
        worlds.add("minecraft:overworld");
        JsonArray weather = new JsonArray();
        weather.add("clear");
        weather.add("snow");
        JsonObject conditions = new JsonObject();
        conditions.add("worlds", (JsonElement)worlds);
        conditions.add("weather", (JsonElement)weather);
        JsonObject properties = new JsonObject();
        properties.addProperty("priority", (Number)Integer.MAX_VALUE);
        properties.add("fade", (JsonElement)fade);
        JsonObject decorations = new JsonObject();
        decorations.addProperty("showSun", Boolean.valueOf(true));
        decorations.addProperty("showMoon", Boolean.valueOf(true));
        decorations.addProperty("showStars", Boolean.valueOf(true));
        JsonObject json = new JsonObject();
        json.addProperty("schemaVersion", (Number)2);
        json.addProperty("type", "monocolor");
        json.add("blend", (JsonElement)blend);
        json.add("properties", (JsonElement)properties);
        json.add("conditions", (JsonElement)conditions);
        json.add("decorations", (JsonElement)decorations);
        if (FSBInteropConfig.INSTANCE.debugMode) {
            this.logger.info("Generated Overworld decorations:\n{}", (Object)GSON.toJson((JsonElement)json));
        }
        class_2960 identifier = class_2960.method_43902((String)"fabricskyboxes-interop", (String)"overworld-decorations");
        SkyboxManager.getInstance().addSkybox(identifier, json);
        this.convertedSkyMap.put(identifier, GSON.toJson((JsonElement)json));
        this.logger.info("Added generated Overworld decorations!");
    }

    private void processProperties(JsonObject json, Properties properties, String skyName) {
        String skyNumberString = skyName.replace("sky", "");
        int skyNumber = Utils.parseInt(skyNumberString, 0);
        JsonObject fade = new JsonObject();
        if (properties.containsKey("startFadeIn") && properties.containsKey("endFadeIn") && properties.containsKey("endFadeOut")) {
            int startFadeOut;
            int startFadeIn = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("startFadeIn"))).intValue();
            int endFadeIn = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("endFadeIn"))).intValue();
            int endFadeOut = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("endFadeOut"))).intValue();
            if (properties.containsKey("startFadeOut")) {
                startFadeOut = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("startFadeOut"))).intValue();
            } else {
                startFadeOut = endFadeOut - (endFadeIn - startFadeIn);
                if (startFadeIn <= startFadeOut && endFadeIn >= startFadeOut) {
                    startFadeOut = endFadeOut;
                }
            }
            fade.addProperty("startFadeIn", (Number)Utils.normalizeTickTime(startFadeIn));
            fade.addProperty("endFadeIn", (Number)Utils.normalizeTickTime(endFadeIn));
            fade.addProperty("startFadeOut", (Number)Utils.normalizeTickTime(startFadeOut));
            fade.addProperty("endFadeOut", (Number)Utils.normalizeTickTime(endFadeOut));
        } else {
            fade.addProperty("alwaysOn", Boolean.valueOf(true));
        }
        JsonArray jsonAxis = new JsonArray();
        if (properties.containsKey("axis")) {
            String[] axis = properties.getProperty("axis").trim().replaceAll(" +", " ").split(" ");
            List<String> rev = Arrays.asList(axis);
            Collections.reverse(rev);
            for (String a : axis = rev.toArray(axis)) {
                jsonAxis.add((Number)Float.valueOf(Float.parseFloat(a) * 90.0f));
            }
        } else {
            jsonAxis.add((Number)Float.valueOf(0.0f));
            jsonAxis.add((Number)Float.valueOf(90.0f));
            jsonAxis.add((Number)Float.valueOf(0.0f));
        }
        float speed = Float.parseFloat(properties.getProperty("speed", "1")) * -1.0f;
        JsonObject rotation = new JsonObject();
        rotation.add("axis", (JsonElement)jsonAxis);
        rotation.addProperty("rotationSpeedY", (Number)Float.valueOf(speed));
        int transitionDuration = Integer.parseInt(properties.getProperty("transition", "1")) * 20;
        if (skyNumberString.equals(String.valueOf(skyNumber))) {
            json.addProperty("priority", (Number)skyNumber);
        }
        json.add("fade", (JsonElement)fade);
        json.add("rotation", (JsonElement)rotation);
        json.addProperty("transitionInDuration", (Number)transitionDuration);
        json.addProperty("transitionOutDuration", (Number)transitionDuration);
    }

    private void processConditions(JsonObject json, Properties properties, String world) {
        List<MinMaxEntry> minMaxEntries;
        String[] biomes;
        if (properties.containsKey("weather")) {
            String[] weathers = properties.getProperty("weather").split(" ");
            JsonArray jsonWeather = new JsonArray();
            if (weathers.length > 0) {
                for (String weather : weathers) {
                    jsonWeather.add(weather);
                }
            } else {
                jsonWeather.add("clear");
                jsonWeather.add("snow");
            }
            json.add("weather", (JsonElement)jsonWeather);
        } else {
            JsonArray jsonWeather = new JsonArray();
            jsonWeather.add("clear");
            jsonWeather.add("snow");
            json.add("weather", (JsonElement)jsonWeather);
        }
        if (properties.containsKey("biomes") && (biomes = properties.getProperty("biomes").split(" ")).length > 0) {
            JsonArray jsonBiomes = new JsonArray();
            for (String biome : biomes) {
                jsonBiomes.add(biome);
            }
            json.add("biomes", (JsonElement)jsonBiomes);
        }
        JsonArray worlds = new JsonArray();
        worlds.add(world.equals("world0") ? "minecraft:overworld" : (world.equals("world1") ? "minecraft:the_end" : world));
        json.add("worlds", (JsonElement)worlds);
        if (properties.containsKey("heights") && !(minMaxEntries = Utils.parseMinMaxEntriesNegative(properties.getProperty("heights"))).isEmpty()) {
            JsonArray jsonYRanges = new JsonArray();
            minMaxEntries.forEach(minMaxEntry -> {
                JsonObject minMax = new JsonObject();
                minMax.addProperty("min", (Number)Float.valueOf(minMaxEntry.getMin()));
                minMax.addProperty("max", (Number)Float.valueOf(minMaxEntry.getMax()));
                jsonYRanges.add((JsonElement)minMax);
            });
            json.add("yRanges", (JsonElement)jsonYRanges);
        }
        if (properties.containsKey("days") && !(minMaxEntries = Utils.parseMinMaxEntries(properties.getProperty("days"))).isEmpty()) {
            JsonObject loopObject = new JsonObject();
            JsonArray loopRange = new JsonArray();
            minMaxEntries.forEach(minMaxEntry -> {
                JsonObject minMax = new JsonObject();
                minMax.addProperty("min", (Number)Float.valueOf(minMaxEntry.getMin()));
                minMax.addProperty("max", (Number)Float.valueOf(minMaxEntry.getMax()));
                loopRange.add((JsonElement)minMax);
            });
            int value = 8;
            if (properties.containsKey("daysLoop")) {
                value = Utils.parseInt(properties.getProperty("daysLoop"), 8);
            }
            loopObject.addProperty("days", (Number)value);
            loopObject.add("ranges", (JsonElement)loopRange);
            json.add("loop", (JsonElement)loopObject);
        }
    }
}

