/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.admiral.MinecraftAdmiral;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeConverter;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeSupplier;
import de.maxhenkel.admiral.permissions.PermissionManager;
import de.maxhenkel.enhancedgroups.EnhancedGroupPermissionManager;
import de.maxhenkel.enhancedgroups.command.AutoJoinGroupCommands;
import de.maxhenkel.enhancedgroups.command.ForceJoinCommands;
import de.maxhenkel.enhancedgroups.command.GroupTypeArgumentSupplier;
import de.maxhenkel.enhancedgroups.command.GroupTypeArgumentTypeSupplier;
import de.maxhenkel.enhancedgroups.command.InstantGroupCommands;
import de.maxhenkel.enhancedgroups.command.PersistentGroupCommands;
import de.maxhenkel.enhancedgroups.config.AutoJoinGroupStore;
import de.maxhenkel.enhancedgroups.config.CommonConfig;
import de.maxhenkel.enhancedgroups.config.PersistentGroupStore;
import de.maxhenkel.enhancedgroups.events.GroupSummaryEvents;
import de.maxhenkel.instantgroup.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.api.Group;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_7157;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedGroups
implements ModInitializer {
    public static final String MOD_ID = "enhancedgroups";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"enhancedgroups");
    public static CommonConfig CONFIG;
    public static PersistentGroupStore PERSISTENT_GROUP_STORE;
    public static AutoJoinGroupStore AUTO_JOIN_GROUP_STORE;
    public static EnhancedGroupPermissionManager PERMISSION_MANAGER;

    public void onInitialize() {
        Path configFolder = Paths.get(".", "config").resolve(MOD_ID);
        CONFIG = ConfigBuilder.builder(CommonConfig::new).path(configFolder.resolve("%s.properties".formatted(MOD_ID))).build();
        PERSISTENT_GROUP_STORE = new PersistentGroupStore(configFolder.resolve("persistent-groups.json").toFile());
        AUTO_JOIN_GROUP_STORE = new AutoJoinGroupStore(configFolder.resolve("auto-join-groups.json").toFile());
        PERMISSION_MANAGER = new EnhancedGroupPermissionManager();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MinecraftAdmiral.builder((CommandDispatcher)dispatcher, (class_7157)registryAccess).addCommandClasses(new Class[]{AutoJoinGroupCommands.class, ForceJoinCommands.class, InstantGroupCommands.class, PersistentGroupCommands.class}).setPermissionManager((PermissionManager)PERMISSION_MANAGER).addArgumentTypes(argumentTypeRegistry -> argumentTypeRegistry.register(Group.Type.class, (ArgumentTypeSupplier)new GroupTypeArgumentSupplier(), (ArgumentTypeConverter)new GroupTypeArgumentTypeSupplier())).build());
        GroupSummaryEvents.init();
    }
}

