/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.mixin;

import de.linusdev.SodiumCoreShaderSupport;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderLoader.class})
public class MixinShaderLoader {
    @Inject(at={@At(value="HEAD")}, method={"loadShader"})
    private static void loadShaderInject(ShaderType type, class_2960 name, ShaderConstants constants, CallbackInfoReturnable<GlShader> cir) {
        SodiumCoreShaderSupport.LOGGER.info("Start loading shader in namespace '" + name.method_12836() + "': " + name.method_12832());
    }

    @Overwrite
    public static String getShaderSource(class_2960 name) {
        Map<String, class_3298> nameSpace = SodiumCoreShaderSupport.shaders.get(name.method_12836());
        if (nameSpace == null) {
            throw new RuntimeException("No Shaders available for namespace '" + name.method_12836() + "'");
        }
        class_3298 shaderResource = nameSpace.get(name.method_12832());
        if (shaderResource == null) {
            throw new RuntimeException("No Shader found in namespace '" + name.method_12836() + "' for shader '" + name.method_12832() + "'");
        }
        try {
            SodiumCoreShaderSupport.LOGGER.info("Loaded Shader '" + name.method_12836() + ":" + name.method_12832() + "' from pack '" + shaderResource.method_45304().method_56926().comp_2330().getString() + "'.");
            return IOUtils.toString((InputStream)shaderResource.method_14482(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while reading shader source in namespace '" + name.method_12836() + "' for shader '" + name.method_12832() + "'", e);
        }
    }
}

