/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.rebind_all_the_keys.mixin;

import com.google.common.collect.Maps;
import com.minenash.rebind_all_the_keys.RebindAllTheKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_304.class})
public class KeyBindingMixin {
    @Shadow
    @Final
    private static Map<class_3675.class_306, class_304> field_1658;
    @Shadow
    private class_3675.class_306 field_1655;
    @Shadow
    @Final
    private static Map<String, class_304> field_1657;
    @Shadow
    private int field_1661;
    private static final Map<class_3675.class_306, List<class_304>> KEY_TO_MULTI_BINDINGS;

    @Inject(method={"onKeyPressed"}, at={@At(value="RETURN")})
    private static void onKeyPressedMultiBindings(class_3675.class_306 key, CallbackInfo _info) {
        List<class_304> bindings = KEY_TO_MULTI_BINDINGS.get(key);
        if (bindings == null) {
            return;
        }
        class_304 vanilla = field_1658.get(key);
        for (class_304 binding : bindings) {
            if (binding == vanilla) continue;
            ++((KeyBindingMixin)binding).field_1661;
        }
    }

    @Inject(method={"setKeyPressed"}, at={@At(value="RETURN")})
    private static void setKeyPressedMultiBindings(class_3675.class_306 key, boolean pressed, CallbackInfo _info) {
        List<class_304> bindings = KEY_TO_MULTI_BINDINGS.get(key);
        if (bindings == null) {
            return;
        }
        class_304 vanilla = field_1658.get(key);
        for (class_304 binding : bindings) {
            if (binding == vanilla) continue;
            binding.method_23481(pressed);
        }
    }

    @Inject(method={"updateKeysByCode"}, at={@At(value="RETURN")})
    private static void updateKeysByCodeMultiBindings(CallbackInfo _info) {
        KEY_TO_MULTI_BINDINGS.clear();
        for (class_304 binding : field_1657.values()) {
            class_3675.class_306 boundKey = ((KeyBindingMixin)binding).field_1655;
            KEY_TO_MULTI_BINDINGS.putIfAbsent(boundKey, new ArrayList());
            KEY_TO_MULTI_BINDINGS.get(boundKey).add(binding);
        }
    }

    @Inject(method={"<init>(Ljava/lang/String;Lnet/minecraft/client/util/InputUtil$Type;ILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void init(String translationKey, class_3675.class_307 type, int code, String category, CallbackInfo _info) {
        KEY_TO_MULTI_BINDINGS.putIfAbsent(this.field_1655, new ArrayList());
        KEY_TO_MULTI_BINDINGS.get(this.field_1655).add((class_304)this);
    }

    @Inject(method={"updateKeysByCode"}, at={@At(value="TAIL")})
    private static void generateDebugRebinds(CallbackInfo _info) {
        RebindAllTheKeys.updateDebugKeybinds();
    }

    static {
        KEY_TO_MULTI_BINDINGS = Maps.newHashMap();
    }
}

