/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.panel.impl;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.client.gui.stats.panel.ActionBarPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.MenuBarPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatFiltersPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatsTabPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.MenuBarPanelProxyImpl;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.StatFiltersPanelProxyImpl;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.StatsTabPanelProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsPanel
extends BSComponentPanel {
    protected final BetterStatsPanelProxy proxy;
    @Nullable
    protected MenuBarPanel panel_menu;
    @Nullable
    protected StatFiltersPanel panel_filters;
    @Nullable
    protected ActionBarPanel panel_actionBar;
    @Nullable
    protected StatsTabPanel panel_stats;

    public BetterStatsPanel(int x, int y, int width, int height, BetterStatsPanelProxy proxy) {
        super(x, y, Math.max(width, 100), Math.max(height, 100));
        this.outlineColor = 0;
        this.backgroundColor = 0;
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final void refreshStatsTab() {
        if (this.panel_stats != null) {
            this.panel_stats.refresh();
        }
    }

    @ApiStatus.Internal
    public final double getStatsTabVerticalScrollAmount() {
        return this.panel_stats != null ? this.panel_stats.getVerticalScrollBarValue() : 0.0;
    }

    protected final void init() {
        int gap = 5;
        int panelX = this.getWidth() / 18;
        int panelW = this.getWidth() - panelX * 2;
        int panelY = 20;
        int panelH = this.getHeight() - 25;
        this.panel_menu = new MenuBarPanel(panelX, 0, panelW, new MenuBarPanelProxyImpl(this));
        this.addChild((TElement)this.panel_menu, true);
        this.panel_filters = new StatFiltersPanel(panelX, 20, panelW / 3 - 5, panelH - 27, new StatFiltersPanelProxyImpl(this));
        this.addChild((TElement)this.panel_filters, true);
        this.panel_actionBar = new ActionBarPanel(panelX, 20 + panelH - 22, this.panel_filters.getWidth(), new ActionBarPanel.ActionBarPanelProxy(){

            @Override
            public void setSelectedStatsTab(StatsTab statsTab) {
                BetterStatsPanel.this.proxy.setSelectedStatsTab(statsTab);
            }
        });
        this.addChild((TElement)this.panel_actionBar, true);
        this.panel_stats = new StatsTabPanel(panelX + this.panel_filters.getWidth() + 5, 20, panelW - (this.panel_filters.getWidth() + 5), panelH, new StatsTabPanelProxyImpl(this));
        this.addChild((TElement)this.panel_stats, true);
    }

    public static interface BetterStatsPanelProxy {
        public IStatsProvider getStatsProvider();

        public StatsTab getSelectedStatsTab();

        public void setSelectedStatsTab(StatsTab var1);

        public StatFilterSettings getFilterSettings();
    }
}

