/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.earthcomputer.clientcommands.event.ClientLevelEvents;
import net.earthcomputer.clientcommands.features.Relogger;
import net.earthcomputer.clientcommands.task.LongTask;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.slf4j.Logger;

public class TaskManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, LongTask> tasks;
    private static long nextTaskId;
    private static String forceAddedTaskName;

    private static void tick(class_310 mc) {
        if (tasks.isEmpty()) {
            return;
        }
        HashSet<Object> mutexKeys = new HashSet<Object>();
        int iterationCount = 0;
        ArrayList<Map.Entry<String, LongTask>> iteratingTasks = new ArrayList<Map.Entry<String, LongTask>>(tasks.entrySet());
        while (!iteratingTasks.isEmpty()) {
            Iterator<Map.Entry<String, LongTask>> itr = iteratingTasks.iterator();
            boolean tickedAnyTask = false;
            while (itr.hasNext()) {
                Map.Entry<String, LongTask> taskEntry = itr.next();
                LongTask task = taskEntry.getValue();
                Set<Object> taskMutexKeys = task.getMutexKeys();
                if (mutexKeys.stream().anyMatch(taskMutexKeys::contains)) continue;
                tickedAnyTask = true;
                mutexKeys.addAll(taskMutexKeys);
                if (!task.isInitialized) {
                    task.initialize();
                    task.isInitialized = true;
                }
                if (task.isCompleted()) {
                    forceAddedTaskName = null;
                    task.onCompleted();
                    if (!taskEntry.getKey().equals(forceAddedTaskName)) {
                        tasks.remove(taskEntry.getKey());
                    }
                    itr.remove();
                    mutexKeys.removeAll(taskMutexKeys);
                    continue;
                }
                task.body();
                if (!task.isCompleted()) {
                    task.increment();
                }
                if (!task.isDelayScheduled()) continue;
                task.unscheduleDelay();
                itr.remove();
            }
            if (!tickedAnyTask) break;
            if (!FabricLoader.getInstance().isDevelopmentEnvironment() || ++iterationCount != 1000) continue;
            LOGGER.warn("A LongTask is taking an exceptionally long time. Task list: {}", tasks);
            LOGGER.warn("Remember you can use ctrl+F2 in IntelliJ to terminate the game while it has your cursor grabbed.");
        }
    }

    private static void onLevelUnload(boolean isDisconnect) {
        ArrayList<Map.Entry<String, LongTask>> oldTasks = new ArrayList<Map.Entry<String, LongTask>>();
        Iterator<Map.Entry<String, LongTask>> itr = tasks.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, LongTask> entry = itr.next();
            if (!entry.getValue().stopOnLevelUnload(isDisconnect)) continue;
            itr.remove();
            oldTasks.add(entry);
        }
        if (isDisconnect && Relogger.isRelogging) {
            Relogger.relogSuccessTasks.add(() -> {
                for (Map.Entry oldTask : oldTasks) {
                    tasks.put((String)oldTask.getKey(), (LongTask)oldTask.getValue());
                }
            });
        } else {
            for (Map.Entry entry : oldTasks) {
                ((LongTask)entry.getValue()).onCompleted();
            }
        }
    }

    public static String addTask(String name, LongTask task) {
        String actualName = nextTaskId++ + "." + name;
        tasks.put(actualName, task);
        return actualName;
    }

    public static void forceAddTask(String fullName, LongTask task) {
        tasks.put(fullName, task);
        forceAddedTaskName = fullName;
    }

    public static int getTaskCount() {
        return tasks.size();
    }

    public static Iterable<String> getTaskNames() {
        return tasks.keySet();
    }

    public static void removeTask(String name) {
        LongTask task = tasks.get(name);
        if (task != null) {
            task._break();
        }
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(TaskManager::tick);
        ClientLevelEvents.UNLOAD_LEVEL.register(TaskManager::onLevelUnload);
        tasks = new LinkedHashMap<String, LongTask>();
        nextTaskId = 1L;
        forceAddedTaskName = null;
    }
}

