/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.mixin.c2c;

import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Optional;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.c2c.C2CPacketHandler;
import net.earthcomputer.clientcommands.c2c.ConversionHelper;
import net.earthcomputer.clientcommands.c2c.OutgoingPacketFilter;
import net.earthcomputer.clientcommands.command.ListenCommand;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_7427;
import net.minecraft.class_7434;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import net.minecraft.class_7853;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class})
public class ChatComponentMixin {
    @Shadow
    @Final
    private class_310 field_2062;

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onC2CPacket(class_2561 message, class_7469 signature, class_7591 tag, CallbackInfo ci) {
        this.handleIfPacket(message, ci);
    }

    @Unique
    private void handleIfPacket(class_2561 content, CallbackInfo ci) {
        String string = content.getString();
        int index = string.indexOf("CCENC:");
        if (index == -1) {
            return;
        }
        String packetString = string.substring(index + 6);
        if (!Configs.acceptC2CPackets) {
            if (OutgoingPacketFilter.removeIfContains(packetString)) {
                this.field_2062.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"c2cpacket.sentC2CPacket"));
            } else {
                this.field_2062.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"c2cpacket.receivedC2CPacket").method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)content))));
            }
            ci.cancel();
            return;
        }
        if (OutgoingPacketFilter.removeIfContains(packetString)) {
            ci.cancel();
            return;
        }
        if (ChatComponentMixin.handleC2CPacket(packetString)) {
            ci.cancel();
        } else {
            this.field_2062.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"c2cpacket.malformedPacket").method_27692(class_124.field_1061));
        }
    }

    @Unique
    private static boolean handleC2CPacket(String content) {
        byte[] encrypted = ConversionHelper.BaseUTF8.fromUnicode(content);
        int length = encrypted.length & 0xFFFFFF00;
        byte[][] encryptedArrays = new byte[length / 256][];
        for (int i = 0; i < length; i += 256) {
            encryptedArrays[i / 256] = Arrays.copyOfRange(encrypted, i, i + 256);
        }
        class_7853 class_78532 = class_310.method_1551().method_43590();
        if (!(class_78532 instanceof class_7434)) {
            return false;
        }
        class_7434 profileKeyPairManager = (class_7434)class_78532;
        Optional keyPair = (Optional)profileKeyPairManager.field_39959.join();
        if (keyPair.isEmpty()) {
            return false;
        }
        int len = 0;
        byte[][] decryptedArrays = new byte[encryptedArrays.length][];
        for (int i = 0; i < encryptedArrays.length; ++i) {
            decryptedArrays[i] = ConversionHelper.RsaEcb.decrypt(encryptedArrays[i], ((class_7427)keyPair.get()).comp_741());
            if (decryptedArrays[i] == null) {
                return false;
            }
            len += decryptedArrays[i].length;
        }
        byte[] decrypted = new byte[len];
        int pos = 0;
        for (byte[] decryptedArray : decryptedArrays) {
            System.arraycopy(decryptedArray, 0, decrypted, pos, decryptedArray.length);
            pos += decryptedArray.length;
        }
        byte[] uncompressed = ConversionHelper.Gzip.uncompress(decrypted);
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])uncompressed));
        class_2596 packet = (class_2596)C2CPacketHandler.C2C.comp_2236().decode((Object)buf);
        if (buf.readableBytes() > 0) {
            return false;
        }
        ListenCommand.onPacket(packet, ListenCommand.PacketFlow.C2C_INBOUND);
        try {
            packet.method_11054((class_2547)C2CPacketHandler.getInstance());
        }
        catch (Exception e) {
            class_310.method_1551().field_1705.method_1743().method_1812(class_2561.method_30163((String)e.getMessage()));
            e.printStackTrace();
        }
        return true;
    }
}

