/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.seedfinding.mcbiome.biome.Biome;
import com.seedfinding.mcbiome.biome.Biomes;
import com.seedfinding.mccore.util.data.Pair;
import com.seedfinding.mccore.version.MCVersion;
import com.seedfinding.mcfeature.loot.enchantment.Enchantments;
import com.seedfinding.mcfeature.loot.item.Item;
import com.seedfinding.mcfeature.loot.item.ItemStack;
import java.util.Objects;
import net.earthcomputer.clientcommands.MultiVersionCompat;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SeedfindingUtil {
    private SeedfindingUtil() {
    }

    @Nullable
    public static Biome toSeedfindingBiome(class_1937 level, class_6880<class_1959> biome) {
        class_2960 name = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biome.comp_349()));
        if (name == null || !"minecraft".equals(name.method_12836())) {
            return null;
        }
        for (Biome b : Biomes.REGISTRY.values()) {
            if (!name.method_12832().equals(b.getName())) continue;
            return b;
        }
        return null;
    }

    public static class_1799 fromSeedfindingItem(Item item) {
        return SeedfindingUtil.fromSeedfindingItem(new ItemStack(item));
    }

    public static class_1799 fromSeedfindingItem(ItemStack stack) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(stack.getItem().getName()));
        if (!stack.getItem().getEnchantments().isEmpty() && item == class_1802.field_8529) {
            item = class_1802.field_8598;
        }
        class_1799 ret = new class_1799((class_1935)item, stack.getCount());
        for (Pair<String, Integer> enchAndLevel : stack.getItem().getEnchantments()) {
            class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(new class_2960(enchAndLevel.getFirst()));
            if (enchantment == null) continue;
            ret.method_7978(enchantment, enchAndLevel.getSecond().intValue());
        }
        return ret;
    }

    public static boolean doesEnchantmentExist(class_1887 enchantment) {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() == class_155.method_31372()) {
            return true;
        }
        class_2960 id = class_7923.field_41176.method_10221((Object)enchantment);
        if (id == null || !id.method_12836().equals("minecraft")) {
            return false;
        }
        String name = id.method_12832();
        return Enchantments.getFor(SeedfindingUtil.getMCVersion()).stream().anyMatch(ench -> ench.getName().equals(name));
    }

    public static MCVersion getMCVersion() {
        return Objects.requireNonNullElseGet(MCVersion.fromString(MultiVersionCompat.INSTANCE.getProtocolName()), MCVersion::latest);
    }
}

