/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.google.common.collect.Streams;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.channel.ChannelPipeline;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.earthcomputer.clientcommands.c2c.C2CPacketHandler;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2543;
import net.minecraft.class_2545;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_9127;
import net.minecraft.class_9136;
import net.minecraft.class_9145;
import org.jetbrains.annotations.Nullable;

public class PacketTypeArgument
implements ArgumentType<class_2960> {
    private static final Collection<String> EXAMPLES = Arrays.asList("add_entity", "minecraft:add_entity", "commands");
    private static final DynamicCommandExceptionType UNKNOWN_PACKET_EXCEPTION = new DynamicCommandExceptionType(packet -> class_2561.method_43469((String)"commands.clisten.unknownPacket", (Object[])new Object[]{packet}));

    public static PacketTypeArgument packet() {
        return new PacketTypeArgument();
    }

    public static class_2960 getPacket(CommandContext<FabricClientCommandSource> context, String name) {
        return (class_2960)context.getArgument(name, class_2960.class);
    }

    public class_2960 parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        class_2960 packetId = class_2960.method_12835((StringReader)reader);
        PacketTypes types = PacketTypes.get();
        if (types == null || !types.clientbound.contains(packetId) && !types.serverbound.contains(packetId) && !types.c2cbound.contains(packetId)) {
            reader.setCursor(start);
            throw UNKNOWN_PACKET_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)packetId);
        }
        return packetId;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        PacketTypes types = PacketTypes.get();
        if (types == null) {
            return builder.buildFuture();
        }
        return class_2172.method_9257((Stream)Streams.concat((Stream[])new Stream[]{types.clientbound.stream(), types.serverbound.stream(), types.c2cbound.stream()}), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private record PacketTypes(Set<class_2960> clientbound, Set<class_2960> serverbound, Set<class_2960> c2cbound) {
        private static final Map<Object, Set<class_2960>> packetTypesCache = new WeakHashMap<Object, Set<class_2960>>();

        private static Set<class_2960> getPacketTypes(class_9127<?> protocolInfo) {
            return ((class_9136)protocolInfo.comp_2236()).field_48579.keySet().stream().map(class_9145::comp_2231).collect(Collectors.toSet());
        }

        @Nullable
        private static PacketTypes get() {
            class_634 connection = class_310.method_1551().method_1562();
            if (connection == null) {
                return null;
            }
            ChannelPipeline pipeline = connection.method_48296().field_11651.pipeline();
            class_2543 decoder = (class_2543)pipeline.get("decoder");
            Set clientbound = packetTypesCache.computeIfAbsent(decoder, k -> PacketTypes.getPacketTypes(decoder.field_48536));
            class_2545 encoder = (class_2545)pipeline.get("encoder");
            Set serverbound = packetTypesCache.computeIfAbsent(encoder, k -> PacketTypes.getPacketTypes(encoder.field_48537));
            Set c2cbound = packetTypesCache.computeIfAbsent("c2c", k -> PacketTypes.getPacketTypes(C2CPacketHandler.C2C));
            return new PacketTypes(clientbound, serverbound, c2cbound);
        }
    }
}

