/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CItemPredicateArgument;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.command.arguments.ItemAndEnchantmentsPredicateArgument;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2293;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class ClientItemPredicateArgument
implements ArgumentType<ClientItemPredicate> {
    private static final DynamicCommandExceptionType INVALID_ITEM_ID_EXCEPTION = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"argument.item.id.invalid", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType UNKNOWN_ITEM_TAG_EXCEPTION = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.item.tag.unknown", (Object[])new Object[]{object}));
    private final CItemPredicateArgument delegate;
    private final class_7225<class_1792> holderLookup;

    private ClientItemPredicateArgument(class_7157 context) {
        this.delegate = CItemPredicateArgument.itemPredicate((class_7157)context);
        this.holderLookup = context.method_46762(class_7924.field_41197);
    }

    @Deprecated
    public static class_2293 itemPredicate(class_7157 context) {
        return class_2293.method_9801((class_7157)context);
    }

    public static ClientItemPredicateArgument clientItemPredicate(class_7157 context) {
        return new ClientItemPredicateArgument(context);
    }

    public static ClientItemPredicate getClientItemPredicate(CommandContext<FabricClientCommandSource> ctx, String name) {
        return (ClientItemPredicate)ctx.getArgument(name, ClientItemPredicate.class);
    }

    public ClientItemPredicate parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        if (reader.canRead() && reader.peek() == '#') {
            reader.skip();
            reader.skipWhitespace();
            int tagStart = reader.getCursor();
            class_2960 tagId = class_2960.method_12835((StringReader)reader);
            reader.setCursor(start);
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
            class_6885 tag = (class_6885)this.holderLookup.method_46733(tagKey).orElseThrow(() -> {
                reader.setCursor(tagStart);
                return UNKNOWN_ITEM_TAG_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)tagId);
            });
            return new TagPredicate((class_6885<class_1792>)tag, (Predicate<class_1799>)this.delegate.parse(reader));
        }
        class_2960 itemId = class_2960.method_12835((StringReader)reader);
        reader.setCursor(start);
        class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)itemId);
        class_6880 item = (class_6880)this.holderLookup.method_46746(itemKey).orElseThrow(() -> INVALID_ITEM_ID_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)itemId));
        return new ItemPredicate((class_6880<class_1792>)item, (Predicate<class_1799>)this.delegate.parse(reader));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return this.delegate.listSuggestions(context, builder);
    }

    public Collection<String> getExamples() {
        return this.delegate.getExamples();
    }

    public static abstract sealed class ClientItemPredicate
    implements Predicate<class_1799>
    permits TagPredicate, ItemPredicate, EnchantedItemPredicate {
        private final Predicate<class_1799> delegate;

        protected ClientItemPredicate(Predicate<class_1799> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(class_1799 stack) {
            return this.delegate.test(stack);
        }

        public abstract Collection<class_1792> getPossibleItems();
    }

    static final class TagPredicate
    extends ClientItemPredicate {
        private final class_6885<class_1792> tag;

        TagPredicate(class_6885<class_1792> tag, Predicate<class_1799> delegate) {
            super(delegate);
            this.tag = tag;
        }

        @Override
        public Collection<class_1792> getPossibleItems() {
            return this.tag.method_40239().map(class_6880::comp_349).toList();
        }
    }

    static final class ItemPredicate
    extends ClientItemPredicate {
        private final class_6880<class_1792> item;

        ItemPredicate(class_6880<class_1792> item, Predicate<class_1799> delegate) {
            super(delegate);
            this.item = item;
        }

        @Override
        public Collection<class_1792> getPossibleItems() {
            return Collections.singletonList((class_1792)this.item.comp_349());
        }
    }

    public static final class EnchantedItemPredicate
    extends ClientItemPredicate {
        public final ItemAndEnchantmentsPredicateArgument.ItemAndEnchantmentsPredicate predicate;

        public EnchantedItemPredicate(ItemAndEnchantmentsPredicateArgument.ItemAndEnchantmentsPredicate predicate) {
            super(predicate);
            this.predicate = predicate;
        }

        public boolean isEnchantedBook() {
            return this.predicate.item() == class_1802.field_8598 || this.predicate.item() == class_1802.field_8529;
        }

        @Override
        public Collection<class_1792> getPossibleItems() {
            if (this.predicate.item() == class_1802.field_8529 || this.predicate.item() == class_1802.field_8598) {
                return Arrays.asList(class_1802.field_8529, class_1802.field_8598);
            }
            return Collections.singletonList(this.predicate.item());
        }
    }
}

