/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.earthcomputer.clientcommands.features.ClientCommandFunctions;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import org.slf4j.Logger;

public class StartupCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType COULD_NOT_CREATE_FILE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cstartup.couldNotCreateFile"));
    private static final SimpleCommandExceptionType COULD_NOT_EDIT_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cstartup.couldNotEdit"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cstartup").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"local").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> StartupCommand.addStartupCommand((FabricClientCommandSource)ctx.getSource(), false, StringArgumentType.getString((CommandContext)ctx, (String)"command")))))).then(ClientCommandManager.literal((String)"edit").executes(ctx -> StartupCommand.editStartupCommand(false))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"global").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> StartupCommand.addStartupCommand((FabricClientCommandSource)ctx.getSource(), true, StringArgumentType.getString((CommandContext)ctx, (String)"command")))))).then(ClientCommandManager.literal((String)"edit").executes(ctx -> StartupCommand.editStartupCommand(true)))));
    }

    private static int addStartupCommand(FabricClientCommandSource source, boolean global, String command) throws CommandSyntaxException {
        Path file;
        StartupCommand.ensureStartupFileExists(global);
        Path path = file = global ? ClientCommandFunctions.getGlobalStartupFunction() : ClientCommandFunctions.getLocalStartupFunction();
        if (file == null) {
            throw COULD_NOT_CREATE_FILE_EXCEPTION.create();
        }
        try {
            Files.writeString(file, (CharSequence)(command + System.lineSeparator()), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LOGGER.error("Failed to append command to startup file", (Throwable)e);
            throw COULD_NOT_EDIT_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cstartup.add.success"));
        return 1;
    }

    private static int editStartupCommand(boolean global) throws CommandSyntaxException {
        Path file;
        StartupCommand.ensureStartupFileExists(global);
        Path path = file = global ? ClientCommandFunctions.getGlobalStartupFunction() : ClientCommandFunctions.getLocalStartupFunction();
        if (file == null) {
            throw COULD_NOT_CREATE_FILE_EXCEPTION.create();
        }
        class_156.method_668().method_672(file.toFile());
        return 1;
    }

    private static void ensureStartupFileExists(boolean global) throws CommandSyntaxException {
        boolean result = true;
        try {
            if (global) {
                ClientCommandFunctions.ensureGlobalStartupFunctionExists();
            } else {
                result = ClientCommandFunctions.ensureLocalStartupFunctionExists();
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to create startup command file", (Throwable)e);
            result = false;
        }
        if (!result) {
            throw COULD_NOT_CREATE_FILE_EXCEPTION.create();
        }
    }
}

