/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CEnumArgument;
import dev.xpple.clientarguments.arguments.CGameProfileArgument;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_640;

public class CGameModeCommand {
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cgamemode.playerNotFound"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cgamemode").then(ClientCommandManager.literal((String)"query").then(ClientCommandManager.argument((String)"player", (ArgumentType)CGameProfileArgument.gameProfile()).executes(ctx -> CGameModeCommand.getPlayerGameMode((FabricClientCommandSource)ctx.getSource(), CGameProfileArgument.getProfileArgument((CommandContext)ctx, (String)"player")))))).then(ClientCommandManager.literal((String)"list").then(ClientCommandManager.argument((String)"gameMode", (ArgumentType)CEnumArgument.enumArg(class_1934.class)).executes(ctx -> CGameModeCommand.listWithGameMode((FabricClientCommandSource)ctx.getSource(), (class_1934)CEnumArgument.getEnum((CommandContext)ctx, (String)"gameMode"))))));
    }

    private static int getPlayerGameMode(FabricClientCommandSource source, Collection<GameProfile> profiles) throws CommandSyntaxException {
        if (profiles.size() != 1) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        class_640 player = source.getClient().method_1562().method_2880().stream().filter(p -> p.method_2966().getName().equalsIgnoreCase(((GameProfile)profiles.iterator().next()).getName())).findAny().orElseThrow(() -> ((SimpleCommandExceptionType)PLAYER_NOT_FOUND_EXCEPTION).create());
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cgamemode.playerGameMode", (Object[])new Object[]{player.method_2966().getName(), player.method_2958().method_32763()}));
        return 1;
    }

    private static int listWithGameMode(FabricClientCommandSource source, class_1934 gameMode) {
        Set<class_640> playersWithGameMode = source.getClient().method_1562().method_2880().stream().filter(p -> p.method_2958() == gameMode).collect(Collectors.toSet());
        if (playersWithGameMode.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cgamemode.noneWithGameMode", (Object[])new Object[]{gameMode.method_32763()}));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cgamemode.listWithGameMode", (Object[])new Object[]{gameMode.method_32763()}));
            playersWithGameMode.forEach(p -> source.sendFeedback((class_2561)class_2561.method_43470((String)p.method_2966().getName())));
        }
        return playersWithGameMode.size();
    }
}

