/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.earthcomputer.clientcommands.MultiVersionCompat;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2820;
import net.minecraft.class_746;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9334;

public class BookCommand {
    private static final SimpleCommandExceptionType NO_BOOK = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cbook.commandException"));
    private static final int DEFAULT_LIMIT = 50;

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() >= 573) {
            return;
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cbook").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fill").executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.fill(), 50))).then(ClientCommandManager.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)BookCommand.getMaxLimit())).executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.fill(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit")))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"random").executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.random(new Random()), 50))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)BookCommand.getMaxLimit())).executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.random(new Random()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit")))).then(ClientCommandManager.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.random(new Random(LongArgumentType.getLong((CommandContext)ctx, (String)"seed"))), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit"))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ascii").executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.ascii(new Random()), 50))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)BookCommand.getMaxLimit())).executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.ascii(new Random()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit")))).then(ClientCommandManager.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(ctx -> BookCommand.fillBook((FabricClientCommandSource)ctx.getSource(), BookCommand.ascii(new Random(LongArgumentType.getLong((CommandContext)ctx, (String)"seed"))), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit")))))));
    }

    private static IntStream fill() {
        return IntStream.generate(() -> 0x10FFFF);
    }

    private static IntStream random(Random rand) {
        return rand.ints(128, 1112063).map(i -> i < 55296 ? i : i + 2048);
    }

    private static IntStream ascii(Random rand) {
        return rand.ints(32, 127);
    }

    private static int fillBook(FabricClientCommandSource source, IntStream characterGenerator, int limit) throws CommandSyntaxException {
        class_746 player = source.getPlayer();
        assert (player != null);
        class_1799 heldItem = player.method_6047();
        class_1268 hand = class_1268.field_5808;
        if (heldItem.method_7909() != class_1802.field_8674) {
            heldItem = player.method_6079();
            hand = class_1268.field_5810;
            if (heldItem.method_7909() != class_1802.field_8674) {
                throw NO_BOOK.create();
            }
        }
        int slot = hand == class_1268.field_5808 ? player.method_31548().field_7545 : 40;
        String joinedPages = characterGenerator.limit((long)BookCommand.getMaxLimit() * 210L).mapToObj(i -> String.valueOf((char)i)).collect(Collectors.joining());
        ArrayList<String> pages = new ArrayList<String>(limit);
        ArrayList<class_9262> filterablePages = new ArrayList<class_9262>();
        for (int pageIndex = 0; pageIndex < limit; ++pageIndex) {
            String page = joinedPages.substring(pageIndex * 210, (pageIndex + 1) * 210);
            pages.add(page);
            filterablePages.add(class_9262.method_57137((Object)page));
        }
        heldItem.method_57379(class_9334.field_49653, (Object)new class_9301(filterablePages));
        player.field_3944.method_52787((class_2596)new class_2820(slot, pages, Optional.empty()));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cbook.success"));
        return 1;
    }

    private static int getMaxLimit() {
        return MultiVersionCompat.INSTANCE.getProtocolVersion() < 477 ? 50 : 100;
    }
}

