/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.common.collect.Streams;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CBlockPosArgument;
import net.earthcomputer.clientcommands.command.arguments.ClientBlockPredicateArgument;
import net.earthcomputer.clientcommands.command.arguments.ListArgument;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_7225;

public class AreaStatsCommand {
    private static final SimpleCommandExceptionType NOT_LOADED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.careastats.notLoaded"));
    private static class_2802 chunkSource;

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"careastats").then(ClientCommandManager.argument((String)"pos1", (ArgumentType)CBlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos2", (ArgumentType)CBlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"predicates", ListArgument.list(ClientBlockPredicateArgument.blockPredicate(context).disallowNbt(), 1)).executes(ctx -> AreaStatsCommand.areaStats((FabricClientCommandSource)ctx.getSource(), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos1"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos2"), ClientBlockPredicateArgument.getBlockPredicateList((CommandContext<FabricClientCommandSource>)ctx, "predicates"))))).executes(ctx -> AreaStatsCommand.areaStats((FabricClientCommandSource)ctx.getSource(), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos1"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos2"), ClientBlockPredicateArgument.ClientBlockPredicate.simple(state -> !state.method_26215()))))));
    }

    private static int areaStats(FabricClientCommandSource source, class_2338 pos1, class_2338 pos2, ClientBlockPredicateArgument.ClientBlockPredicate blockPredicate) throws CommandSyntaxException {
        int chunks;
        class_638 level = source.getWorld();
        chunkSource = level.method_2935();
        AreaStatsCommand.assertChunkIsLoaded(pos1.method_10263() >> 4, pos1.method_10260() >> 4);
        AreaStatsCommand.assertChunkIsLoaded(pos2.method_10263() >> 4, pos2.method_10260() >> 4);
        long startTime = System.nanoTime();
        class_2818 chunk1 = level.method_8500(pos1);
        class_2818 chunk2 = level.method_8500(pos2);
        int minX = Math.min(pos1.method_10263(), pos2.method_10263());
        int maxX = Math.max(pos1.method_10263(), pos2.method_10263());
        int minZ = Math.min(pos1.method_10260(), pos2.method_10260());
        int maxZ = Math.max(pos1.method_10260(), pos2.method_10260());
        int minY = Math.min(pos1.method_10264(), pos2.method_10264());
        int maxY = Math.max(pos1.method_10264(), pos2.method_10264());
        int minXShifted = minX >> 4;
        int maxXShifted = maxX >> 4;
        int minZShifted = minZ >> 4;
        int maxZShifted = maxZ >> 4;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int blocks = 0;
        if (chunk1.method_12004().equals((Object)chunk2.method_12004())) {
            chunks = 1;
            blocks += AreaStatsCommand.loop(level, minX, maxX, minZ, maxZ, minY, maxY, blockPredicate, chunk1, mutablePos);
        } else if (chunk1.method_12004().field_9181 == chunk2.method_12004().field_9181) {
            chunks = 2;
            minMinChunk = level.method_8497(minXShifted, minZShifted);
            blocks += AreaStatsCommand.loop(level, minX, maxX, minZ, minZShifted * 16 + 15, minY, maxY, blockPredicate, minMinChunk, mutablePos);
            class_2818 minMaxChunk = level.method_8497(minXShifted, maxZShifted);
            blocks += AreaStatsCommand.loop(level, minX, maxX, maxZShifted * 16, maxZ, minY, maxY, blockPredicate, minMaxChunk, mutablePos);
            for (int chunkZ = minMinChunk.method_12004().field_9180 + 1; chunkZ < minMaxChunk.method_12004().field_9180; ++chunkZ) {
                AreaStatsCommand.assertChunkIsLoaded(minMinChunk.method_12004().field_9181, chunkZ);
                ++chunks;
                chunk = level.method_8497(minMinChunk.method_12004().field_9181, chunkZ);
                blocks += AreaStatsCommand.loop(level, minX, maxX, 16 * chunkZ, 16 * chunkZ + 15, minY, maxY, blockPredicate, chunk, mutablePos);
            }
        } else if (chunk1.method_12004().field_9180 == chunk2.method_12004().field_9180) {
            chunks = 2;
            minMinChunk = level.method_8497(minXShifted, minZShifted);
            blocks += AreaStatsCommand.loop(level, minX, minXShifted * 16 + 15, minZ, maxZ, minY, maxY, blockPredicate, minMinChunk, mutablePos);
            class_2818 maxMinChunk = level.method_8497(maxXShifted, minZShifted);
            blocks += AreaStatsCommand.loop(level, maxXShifted * 16, maxX, minZ, maxZ, minY, maxY, blockPredicate, maxMinChunk, mutablePos);
            for (int chunkX = minMinChunk.method_12004().field_9181 + 1; chunkX < maxMinChunk.method_12004().field_9181; ++chunkX) {
                AreaStatsCommand.assertChunkIsLoaded(chunkX, minMinChunk.method_12004().field_9180);
                ++chunks;
                chunk = level.method_8497(chunkX, minMinChunk.method_12004().field_9180);
                blocks += AreaStatsCommand.loop(level, 16 * chunkX, 16 * chunkX + 15, minZ, maxZ, minY, maxY, blockPredicate, chunk, mutablePos);
            }
        } else {
            class_2818 chunk;
            chunks = 4;
            AreaStatsCommand.assertChunkIsLoaded(minXShifted, minZShifted);
            AreaStatsCommand.assertChunkIsLoaded(minXShifted, maxZShifted);
            AreaStatsCommand.assertChunkIsLoaded(maxXShifted, minZShifted);
            AreaStatsCommand.assertChunkIsLoaded(maxXShifted, maxZShifted);
            minMinChunk = level.method_8497(minXShifted, minZShifted);
            class_2818 minMaxChunk = level.method_8497(minXShifted, maxZShifted);
            class_2818 maxMinChunk = level.method_8497(maxXShifted, minZShifted);
            class_2818 maxMaxChunk = level.method_8497(maxXShifted, maxZShifted);
            blocks += AreaStatsCommand.loop(level, minX, minXShifted * 16 + 15, minZ, minZShifted * 16 + 15, minY, maxY, blockPredicate, minMinChunk, mutablePos);
            blocks += AreaStatsCommand.loop(level, minX, minXShifted * 16 + 15, maxZShifted * 16, maxZ, minY, maxY, blockPredicate, minMaxChunk, mutablePos);
            blocks += AreaStatsCommand.loop(level, maxXShifted * 16, maxX, minZ, minZShifted * 16 + 15, minY, maxY, blockPredicate, maxMinChunk, mutablePos);
            blocks += AreaStatsCommand.loop(level, maxXShifted * 16, maxX, maxZShifted * 16, maxZ, minY, maxY, blockPredicate, maxMaxChunk, mutablePos);
            for (int minMinMaxMin = minMinChunk.method_12004().field_9181 + 1; minMinMaxMin < maxMinChunk.method_12004().field_9181; ++minMinMaxMin) {
                AreaStatsCommand.assertChunkIsLoaded(minMinMaxMin, minMinChunk.method_12004().field_9180);
                ++chunks;
                chunk = level.method_8497(minMinMaxMin, minMinChunk.method_12004().field_9180);
                blocks += AreaStatsCommand.loop(level, 16 * minMinMaxMin, 16 * minMinMaxMin + 15, minZ, minZShifted * 16 + 15, minY, maxY, blockPredicate, chunk, mutablePos);
            }
            for (int minMinMinMax = minMinChunk.method_12004().field_9180 + 1; minMinMinMax < minMaxChunk.method_12004().field_9180; ++minMinMinMax) {
                AreaStatsCommand.assertChunkIsLoaded(minMinChunk.method_12004().field_9181, minMinMinMax);
                ++chunks;
                chunk = level.method_8497(minMinChunk.method_12004().field_9181, minMinMinMax);
                blocks += AreaStatsCommand.loop(level, minX, minXShifted * 16 + 15, 16 * minMinMinMax, 16 * minMinMinMax + 15, minY, maxY, blockPredicate, chunk, mutablePos);
            }
            for (int minMaxMaxMax = minMaxChunk.method_12004().field_9181 + 1; minMaxMaxMax < maxMaxChunk.method_12004().field_9181; ++minMaxMaxMax) {
                AreaStatsCommand.assertChunkIsLoaded(minMaxMaxMax, minMaxChunk.method_12004().field_9180);
                ++chunks;
                chunk = level.method_8497(minMaxMaxMax, minMaxChunk.method_12004().field_9180);
                blocks += AreaStatsCommand.loop(level, 16 * minMaxMaxMax, 16 * minMaxMaxMax + 15, maxZShifted * 16, maxZ, minY, maxY, blockPredicate, chunk, mutablePos);
            }
            for (int maxMinMaxMax = maxMinChunk.method_12004().field_9180 + 1; maxMinMaxMax < maxMaxChunk.method_12004().field_9180; ++maxMinMaxMax) {
                AreaStatsCommand.assertChunkIsLoaded(maxMinChunk.method_12004().field_9181, maxMinMaxMax);
                ++chunks;
                chunk = level.method_8497(maxMinChunk.method_12004().field_9181, maxMinMaxMax);
                blocks += AreaStatsCommand.loop(level, maxXShifted * 16, maxX, 16 * maxMinMaxMax, 16 * maxMinMaxMax + 15, minY, maxY, blockPredicate, chunk, mutablePos);
            }
            for (int chunkX = minMinChunk.method_12004().field_9181 + 1; chunkX < maxMinChunk.method_12004().field_9181; ++chunkX) {
                for (int chunkZ = minMinChunk.method_12004().field_9180 + 1; chunkZ < minMaxChunk.method_12004().field_9180; ++chunkZ) {
                    AreaStatsCommand.assertChunkIsLoaded(chunkX, chunkZ);
                    ++chunks;
                    class_2818 chunk3 = level.method_8497(chunkX, chunkZ);
                    blocks += AreaStatsCommand.loop(level, 16 * chunkX, 16 * chunkX + 15, 16 * chunkZ, 16 * chunkZ + 15, minY, maxY, blockPredicate, chunk3, mutablePos);
                }
            }
        }
        long entities = Streams.stream((Iterable)level.method_18112()).filter(entity -> entity.method_23317() >= (double)minX && entity.method_23317() <= (double)maxX && entity.method_23321() >= (double)minZ && entity.method_23321() <= (double)maxZ && entity.method_23318() >= (double)minY && entity.method_23318() <= (double)maxY).count();
        class_238 box = new class_238((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
        RenderQueue.addCuboid(RenderQueue.Layer.ON_TOP, box, box, -65536, 1200);
        long endTime = System.nanoTime();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.careastats.output.chunksScanned", (Object[])new Object[]{chunks, endTime - startTime, (endTime - startTime) / 1000000L}));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.careastats.output.blocksMatched", (Object[])new Object[]{blocks, (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1)}));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.careastats.output.entitiesFound", (Object[])new Object[]{entities}));
        return blocks;
    }

    private static int loop(class_638 level, int start1, int end1, int start2, int end2, int start3, int end3, ClientBlockPredicateArgument.ClientBlockPredicate predicate, class_2818 chunk, class_2338.class_2339 mutablePos) {
        int counter = 0;
        for (int x = start1; x <= end1; ++x) {
            mutablePos.method_33097(x);
            for (int z = start2; z <= end2; ++z) {
                mutablePos.method_33099(z);
                for (int y = start3; y <= end3; ++y) {
                    mutablePos.method_33098(y);
                    if (!predicate.test((class_7225.class_7874)level.method_30349(), (class_1922)chunk, (class_2338)mutablePos)) continue;
                    ++counter;
                }
            }
        }
        return counter;
    }

    private static void assertChunkIsLoaded(int x, int z) throws CommandSyntaxException {
        if (chunkSource.method_12123(x, z)) {
            return;
        }
        throw NOT_LOADED_EXCEPTION.create();
    }
}

