/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.c2c;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.security.PublicKey;
import net.earthcomputer.clientcommands.c2c.C2CPacketListener;
import net.earthcomputer.clientcommands.c2c.ConversionHelper;
import net.earthcomputer.clientcommands.c2c.OutgoingPacketFilter;
import net.earthcomputer.clientcommands.c2c.packets.MessageC2CPacket;
import net.earthcomputer.clientcommands.command.ListenCommand;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_640;
import net.minecraft.class_7428;
import net.minecraft.class_7822;
import net.minecraft.class_9127;
import net.minecraft.class_9129;
import net.minecraft.class_9147;

public class C2CPacketHandler
implements C2CPacketListener {
    private static final DynamicCommandExceptionType MESSAGE_TOO_LONG_EXCEPTION = new DynamicCommandExceptionType(d -> class_2561.method_43469((String)"c2cpacket.messageTooLong", (Object[])new Object[]{d}));
    private static final SimpleCommandExceptionType PUBLIC_KEY_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"c2cpacket.publicKeyNotFound"));
    private static final SimpleCommandExceptionType ENCRYPTION_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"c2cpacket.encryptionFailed"));
    public static final class_9127<C2CPacketListener> C2C = class_9147.method_56456((class_2539)class_2539.field_20591, (class_2598)class_2598.field_11942, builder -> builder.method_56454(MessageC2CPacket.ID, MessageC2CPacket.CODEC)).bind(class_9129.method_56350((class_5455)class_310.method_1551().method_1562().method_29091()));
    private static final C2CPacketHandler instance = new C2CPacketHandler();

    private C2CPacketHandler() {
    }

    public static C2CPacketHandler getInstance() {
        return instance;
    }

    public void sendPacket(class_2596<C2CPacketListener> packet, class_640 recipient) throws CommandSyntaxException {
        class_7822 session = recipient.method_45741();
        if (session == null) {
            throw PUBLIC_KEY_NOT_FOUND_EXCEPTION.create();
        }
        class_7428 ppk = session.comp_1086();
        if (ppk == null) {
            throw PUBLIC_KEY_NOT_FOUND_EXCEPTION.create();
        }
        PublicKey key = ppk.comp_767().comp_770();
        class_2540 buf = PacketByteBufs.create();
        C2C.comp_2236().encode((Object)buf, packet);
        byte[] uncompressed = new byte[buf.readableBytes()];
        buf.method_52952(0, uncompressed);
        byte[] compressed = ConversionHelper.Gzip.compress(uncompressed);
        int chunks = (compressed.length + 244) / 245;
        byte[][] chunked = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            int start = i * 245;
            int end = Math.min(start + 245, compressed.length);
            chunked[i] = new byte[end - start];
            System.arraycopy(compressed, start, chunked[i], 0, end - start);
        }
        byte[][] encrypted = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            encrypted[i] = ConversionHelper.RsaEcb.encrypt(chunked[i], key);
            if (encrypted[i] != null && encrypted[i].length != 0) continue;
            throw ENCRYPTION_FAILED_EXCEPTION.create();
        }
        byte[] joined = new byte[encrypted.length * 256];
        for (int i = 0; i < encrypted.length; ++i) {
            System.arraycopy(encrypted[i], 0, joined, i * 256, 256);
        }
        String packetString = ConversionHelper.BaseUTF8.toUnicode(joined);
        String commandString = "w " + recipient.method_2966().getName() + " CCENC:" + packetString;
        if (commandString.length() >= 256) {
            throw MESSAGE_TOO_LONG_EXCEPTION.create((Object)commandString.length());
        }
        ListenCommand.onPacket(packet, ListenCommand.PacketFlow.C2C_OUTBOUND);
        class_310.method_1551().method_1562().method_45730(commandString);
        OutgoingPacketFilter.addPacket(packetString);
    }

    @Override
    public void onMessageC2CPacket(MessageC2CPacket packet) {
        String sender = packet.sender();
        String message = packet.message();
        class_5250 prefix = class_2561.method_43473();
        prefix.method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063));
        prefix.method_10852((class_2561)class_2561.method_43470((String)"/cwe").method_27692(class_124.field_1075));
        prefix.method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1063));
        prefix.method_10852((class_2561)class_2561.method_43470((String)" "));
        class_5250 component = prefix.method_10852((class_2561)class_2561.method_43469((String)"c2cpacket.messageC2CPacket.incoming", (Object[])new Object[]{sender, message}).method_27692(class_124.field_1080));
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)component);
    }

    public class_2598 method_52895() {
        return C2C.comp_2235();
    }

    public class_2539 method_52280() {
        return C2C.comp_2234();
    }

    public void method_10839(class_2561 reason) {
    }

    public boolean method_48106() {
        return true;
    }
}

