/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcfeature.loot.effect.attribute;

import com.seedfinding.mcfeature.loot.effect.attribute.Attribute;
import com.seedfinding.mcterrain.utils.MathHelper;

public class RangedAttribute
extends Attribute {
    private final double minValue;
    private final double maxValue;

    public RangedAttribute(String name, double value, double minValue, double maxValue) {
        super(name, value);
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (minValue > maxValue) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (value < minValue) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (value > maxValue) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double sanitizeValue(double current) {
        return MathHelper.clamp(current, this.minValue, this.maxValue);
    }
}

