/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcbiome.biome.surface.builder;

import com.seedfinding.mcbiome.biome.Biome;
import com.seedfinding.mcbiome.biome.surface.SurfaceConfig;
import com.seedfinding.mcbiome.biome.surface.builder.DefaultSurfaceBuilder;
import com.seedfinding.mcbiome.source.BiomeSource;
import com.seedfinding.mcbiome.source.StaticNoiseSource;
import com.seedfinding.mccore.block.Block;
import com.seedfinding.mccore.rand.ChunkRand;

public class SwampSurfaceBuilder
extends DefaultSurfaceBuilder {
    public SwampSurfaceBuilder(SurfaceConfig surfaceConfig) {
        super(surfaceConfig);
    }

    @Override
    public Block[] applyToColumn(BiomeSource source, ChunkRand rand, Block[] column, Biome biome, int x, int z, int maxY, int minY, double noise, int seaLevel, Block defaultBlock, Block defaultFluid) {
        double d0 = StaticNoiseSource.BIOME_INFO_NOISE.sample((double)x * 0.25, (double)z * 0.25, false);
        if (d0 > 0.0) {
            for (int y = maxY; y >= minY; --y) {
                if (Block.IS_AIR.test(source.getVersion(), column[y])) continue;
                if (y != 62 || column[y] == defaultFluid) break;
                column[y] = defaultFluid;
                break;
            }
        }
        return super.applyToColumn(source, rand, column, biome, x, z, maxY, minY, noise, seaLevel, defaultBlock, defaultFluid);
    }
}

