/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.vivecraft.client.utils.UpdateChecker;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.ServerConfig;

public class ServerUtil {
    public static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void scheduleWelcomeMessageOrKick(class_3222 serverPlayer) {
        if (((Boolean)ServerConfig.messagesEnabled.get()).booleanValue() || ((Boolean)ServerConfig.vive_only.get()).booleanValue() || ((Boolean)ServerConfig.vr_only.get()).booleanValue()) {
            scheduler.schedule(() -> {
                if (!serverPlayer.method_14239()) {
                    boolean isOpAndAllowed;
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    String message = "";
                    boolean bl = isOpAndAllowed = (Boolean)ServerConfig.allow_op.get() != false && serverPlayer.field_13995.method_3760().method_14569(serverPlayer.method_7334());
                    if (!(isOpAndAllowed || !((Boolean)ServerConfig.vr_only.get()).booleanValue() || vivePlayer != null && vivePlayer.isVR())) {
                        String kickMessage = (String)ServerConfig.messagesKickVROnly.get();
                        try {
                            kickMessage = kickMessage.formatted(serverPlayer.method_5477().getString());
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("KickVROnly message '{}' has errors: {}", (Object)kickMessage, (Object)e.toString());
                        }
                        serverPlayer.field_13987.method_52396((class_2561)class_2561.method_43470((String)kickMessage));
                        return;
                    }
                    if (!isOpAndAllowed && ((Boolean)ServerConfig.vive_only.get()).booleanValue() && vivePlayer == null) {
                        String kickMessage = (String)ServerConfig.messagesKickViveOnly.get();
                        try {
                            kickMessage = kickMessage.formatted(serverPlayer.method_5477().getString());
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("KickViveOnly message '{}' has errors: {}", (Object)kickMessage, (Object)e.toString());
                        }
                        serverPlayer.field_13987.method_52396((class_2561)class_2561.method_43470((String)kickMessage));
                        return;
                    }
                    if (((Boolean)ServerConfig.messagesEnabled.get()).booleanValue() && !(message = vivePlayer == null ? (String)ServerConfig.messagesWelcomeVanilla.get() : (!vivePlayer.isVR() ? (String)ServerConfig.messagesWelcomeNonVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.messagesWelcomeSeated.get() : (String)ServerConfig.messagesWelcomeVR.get()))).isEmpty()) {
                        try {
                            serverPlayer.field_13995.method_3760().method_43514((class_2561)class_2561.method_43470((String)message.formatted(serverPlayer.method_5477().getString())), false);
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("Welcome message '{}' has errors: {}", (Object)message, (Object)e.toString());
                        }
                    }
                }
            }, (long)((Double)ServerConfig.messageKickDelay.get() * 1000.0), TimeUnit.MILLISECONDS);
        }
    }

    public static void sendUpdateNotificationIfOP(class_3222 serverPlayer) {
        if (((Boolean)ServerConfig.checkForUpdate.get()).booleanValue() && serverPlayer.field_13995.method_3816() && serverPlayer.field_13995.method_3760().method_14569(serverPlayer.method_7334())) {
            scheduler.schedule(() -> {
                if (UpdateChecker.checkForUpdates()) {
                    serverPlayer.method_43496((class_2561)class_2561.method_43470((String)("Vivecraft update available: \u00a7a" + UpdateChecker.newestVersion)));
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(context -> {
            ServerConfig.init((action, path, incorrectValue, correctedValue) -> ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Corrected \u00a7a[" + String.join((CharSequence)"\u00a7r.\u00a7a", path) + "]\u00a7r: was '(" + incorrectValue.getClass().getSimpleName() + ")" + String.valueOf(incorrectValue) + "', is now '(" + correctedValue.getClass().getSimpleName() + ")" + String.valueOf(correctedValue) + "'"))));
            return 1;
        })));
        for (ConfigBuilder.ConfigValue setting : ServerConfig.getConfigValues()) {
            IntegerArgumentType argument;
            String argumentName;
            Class<?> clazz = setting.get().getClass();
            if (clazz == Integer.class) {
                argumentName = "int";
                argument = IntegerArgumentType.integer();
            } else if (clazz == Double.class) {
                argumentName = "double";
                argument = DoubleArgumentType.doubleArg();
            } else if (clazz == Boolean.class) {
                argumentName = "bool";
                argument = BoolArgumentType.bool();
            } else {
                argumentName = "string";
                argument = StringArgumentType.string();
            }
            if (setting instanceof ConfigBuilder.InListValue) {
                ConfigBuilder.InListValue inListValue = (ConfigBuilder.InListValue)setting;
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)inListValue.getPath()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Object value : inListValue.getValidValues()) {
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    try {
                        Object newValue = context.getArgument(argumentName, clazz);
                        setting.set(newValue);
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("set \u00a7a[" + setting.getPath() + "]\u00a7r to '" + String.valueOf(newValue) + "'")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return 1;
                })))));
            } else if (!(setting.get() instanceof List)) {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)setting.getPath()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)argumentName, (ArgumentType)argument).executes(context -> {
                    try {
                        Object newValue = context.getArgument(argumentName, clazz);
                        setting.set(newValue);
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("set \u00a7a[" + setting.getPath() + "]\u00a7r to '" + String.valueOf(newValue) + "'")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return 1;
                })))));
            } else {
                ConfigBuilder.ConfigValue listConfig = setting;
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)setting.getPath()).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (class_2960 block : class_7923.field_41175.method_10235()) {
                        builder.suggest(block.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.add(newValue);
                    listConfig.set(list);
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("added '" + newValue + "' to \u00a7a[" + setting.getPath() + "]\u00a7r")));
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("is now '" + String.valueOf(setting.get()))));
                    return 1;
                })))));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)setting.getPath()).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (String block : (List)listConfig.get()) {
                        builder.suggest(block);
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.remove(newValue);
                    listConfig.set(list);
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("removed '" + newValue + "' from \u00a7a[" + setting.getPath() + "]\u00a7r")));
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("is now '" + String.valueOf(setting.get()))));
                    return 1;
                })))));
            }
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)setting.getPath()).then(class_2170.method_9247((String)"reset").executes(context -> {
                Object newValue = setting.reset();
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("reset \u00a7a[" + setting.getPath() + "]\u00a7r to '" + String.valueOf(newValue) + "'")));
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)setting.getPath()).executes(context -> {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[" + setting.getPath() + "]\u00a7r is set to '" + String.valueOf(setting.get()) + "'")));
                return 1;
            })));
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }
}

