/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.common.network.BufferSerializable;
import org.vivecraft.common.network.Pose;
import org.vivecraft.common.utils.lwjgl.Matrix4f;
import org.vivecraft.common.utils.math.Quaternion;

public record VrPlayerState(boolean seated, Pose hmd, boolean reverseHands, Pose controller0, boolean reverseHands1legacy, Pose controller1) implements BufferSerializable
{
    public static VrPlayerState create(VRPlayer vrPlayer) {
        return new VrPlayerState(ClientDataHolderVR.getInstance().vrSettings.seated, VrPlayerState.hmdPose(vrPlayer), ClientDataHolderVR.getInstance().vrSettings.reverseHands, VrPlayerState.controllerPose(vrPlayer, 0), ClientDataHolderVR.getInstance().vrSettings.reverseHands, VrPlayerState.controllerPose(vrPlayer, 1));
    }

    private static Pose hmdPose(VRPlayer vrPlayer) {
        FloatBuffer floatbuffer = vrPlayer.vrdata_world_post.hmd.getMatrix().toFloatBuffer();
        ((Buffer)floatbuffer).rewind();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.load(floatbuffer);
        class_243 vec3 = vrPlayer.vrdata_world_post.getEye(RenderPass.CENTER).getPosition().method_1020(class_310.method_1551().field_1724.method_19538());
        Quaternion quaternion = new Quaternion(matrix4f);
        return new Pose(vec3, quaternion);
    }

    private static Pose controllerPose(VRPlayer vrPlayer, int i) {
        class_243 position = vrPlayer.vrdata_world_post.getController(i).getPosition().method_1020(class_310.method_1551().field_1724.method_19538());
        FloatBuffer floatbuffer1 = vrPlayer.vrdata_world_post.getController(i).getMatrix().toFloatBuffer();
        ((Buffer)floatbuffer1).rewind();
        Matrix4f matrix4f1 = new Matrix4f();
        matrix4f1.load(floatbuffer1);
        Quaternion orientation = new Quaternion(matrix4f1);
        return new Pose(position, orientation);
    }

    public static VrPlayerState deserialize(class_2540 byteBuf) {
        return new VrPlayerState(byteBuf.readBoolean(), Pose.deserialize(byteBuf), byteBuf.readBoolean(), Pose.deserialize(byteBuf), byteBuf.readBoolean(), Pose.deserialize(byteBuf));
    }

    @Override
    public void serialize(class_2540 buffer) {
        buffer.method_52964(this.seated);
        this.hmd.serialize(buffer);
        buffer.method_52964(this.reverseHands);
        this.controller0.serialize(buffer);
        buffer.method_52964(this.reverseHands);
        this.controller1.serialize(buffer);
    }
}

