/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_156;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4063;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5294;
import net.minecraft.class_5365;
import net.minecraft.class_5636;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_6491;
import net.minecraft.class_6854;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7134;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.extensions.BufferBuilderExtension;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.menuworlds.MenuWorldDownloader;
import org.vivecraft.client_vr.menuworlds.MenuWorldExporter;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client.renderer.RenderStateShardAccessor;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.sodium.SodiumHelper;

public class MenuWorldRenderer {
    private static final class_2960 MOON_LOCATION = new class_2960("textures/environment/moon_phases.png");
    private static final class_2960 SUN_LOCATION = new class_2960("textures/environment/sun.png");
    private static final class_2960 CLOUDS_LOCATION = new class_2960("textures/environment/clouds.png");
    private static final class_2960 END_SKY_LOCATION = new class_2960("textures/environment/end_sky.png");
    private static final class_2960 FORCEFIELD_LOCATION = new class_2960("textures/misc/forcefield.png");
    private static final class_2960 RAIN_LOCATION = new class_2960("textures/environment/rain.png");
    private static final class_2960 SNOW_LOCATION = new class_2960("textures/environment/snow.png");
    private final class_310 mc;
    private class_5294 dimensionInfo;
    private FakeBlockAccess blockAccess;
    private final class_1043 lightTexture;
    private final class_1011 lightPixels;
    private final class_2960 lightTextureLocation;
    private boolean lightmapUpdateNeeded;
    private float blockLightRedFlicker;
    private int waterVisionTime;
    public int ticks = 0;
    public long time = 1000L;
    public boolean fastTime;
    private HashMap<class_1921, List<class_291>> vertexBuffers;
    private class_291 starVBO;
    private class_291 skyVBO;
    private class_291 sky2VBO;
    private class_291 cloudVBO;
    private int renderDistance;
    private int renderDistanceChunks;
    public MenuFogRenderer fogRenderer;
    public Set<class_1058> animatedSprites;
    private final Random rand;
    private boolean ready;
    private class_4063 prevCloudsType;
    private int prevCloudX;
    private int prevCloudY;
    private int prevCloudZ;
    private class_243 prevCloudColor;
    private boolean generateClouds = true;
    private int skyFlashTime;
    private float rainLevel;
    private float thunderLevel;
    private float worldRotation;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private CompletableFuture<FakeBlockAccess> getWorldTask;
    public int renderMaxTime = 40;
    public class_2382 segmentSize = new class_2382(64, 64, 64);
    private boolean building = false;
    private long buildStartTime;
    private Map<Pair<class_1921, class_2338>, class_287> bufferBuilders;
    private Map<Pair<class_1921, class_2338>, class_2338.class_2339> currentPositions;
    private Map<Pair<class_1921, class_2338>, Integer> blockCounts;
    private Map<Pair<class_1921, class_2338>, Long> renderTimes;
    private final List<CompletableFuture<Void>> builderFutures = new ArrayList<CompletableFuture<Void>>();
    private final Queue<Thread> builderThreads = new ConcurrentLinkedQueue<Thread>();
    private Throwable builderError;
    private static boolean firstRenderDone;

    public MenuWorldRenderer() {
        this.mc = class_310.method_1551();
        this.lightTexture = new class_1043(16, 16, false);
        this.lightTextureLocation = this.mc.method_1531().method_4617("vivecraft_light_map", this.lightTexture);
        this.lightPixels = this.lightTexture.method_4525();
        this.fogRenderer = new MenuFogRenderer(this);
        this.rand = new Random();
        this.rand.nextInt();
    }

    public void init() {
        if (ClientDataHolderVR.getInstance().vrSettings.menuWorldSelection == VRSettings.MenuWorld.NONE) {
            return;
        }
        try {
            VRSettings.logger.info("MenuWorlds: Initializing main menu world renderer...");
            this.loadRenderers();
            this.getWorldTask = CompletableFuture.supplyAsync(() -> {
                FakeBlockAccess fakeBlockAccess;
                block8: {
                    InputStream inputStream = MenuWorldDownloader.getRandomWorld();
                    try {
                        VRSettings.logger.info("MenuWorlds: Loading world data...");
                        FakeBlockAccess fakeBlockAccess2 = fakeBlockAccess = inputStream != null ? MenuWorldExporter.loadWorld(inputStream) : null;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            VRSettings.logger.error("Exception thrown when loading main menu world, falling back to old menu room. \n {}", (Object)e.getMessage());
                            e.printStackTrace();
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return fakeBlockAccess;
            }, class_156.method_18349());
        }
        catch (Exception e) {
            VRSettings.logger.error("Exception thrown when initializing main menu world renderer, falling back to old menu room. \n {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public void checkTask() {
        if (this.getWorldTask == null || !this.getWorldTask.isDone()) {
            return;
        }
        try {
            FakeBlockAccess world = this.getWorldTask.get();
            if (world != null) {
                this.setWorld(world);
                this.prepare();
            } else {
                VRSettings.logger.warn("Failed to load any main menu world, falling back to old menu room");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.getWorldTask = null;
        }
    }

    public void render(Matrix4fStack poseStack) {
        class_5365 current = (class_5365)this.mc.field_1690.method_42534().method_41753();
        if (current == class_5365.field_25429) {
            this.mc.field_1690.method_42534().method_41748((Object)class_5365.field_25428);
        }
        this.turnOnLightLayer();
        poseStack.pushMatrix();
        poseStack.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(this.worldRotation));
        poseStack.translate(-0.5f, -this.blockAccess.getGround() + (float)((int)this.blockAccess.getGround()), -0.5f);
        class_243 offset = new class_243(0.5, (double)(-this.blockAccess.getGround() + (float)((int)this.blockAccess.getGround())), 0.5).method_1024(this.worldRotation * 0.0174533f);
        class_243 eyePosition = this.getEyePos().method_1019(offset).method_1024(-this.worldRotation * 0.0174533f);
        this.fogRenderer.levelFogColor();
        this.renderSky(poseStack, eyePosition);
        this.fogRenderer.setupFog(class_758.class_4596.field_20946);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableBlend();
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        RenderSystem.disableBlend();
        this.renderChunkLayer(class_1921.method_23577(), (Matrix4f)poseStack, projection);
        this.renderChunkLayer(class_1921.method_23579(), (Matrix4f)poseStack, projection);
        this.renderChunkLayer(class_1921.method_23581(), (Matrix4f)poseStack, projection);
        RenderSystem.enableBlend();
        float cloudHeight = this.dimensionInfo.method_28108();
        if (OptifineHelper.isOptifineLoaded()) {
            cloudHeight = (float)((double)cloudHeight + OptifineHelper.getCloudHeight() * 128.0);
        }
        if (eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607() < (double)cloudHeight) {
            this.renderClouds(poseStack, eyePosition.field_1352, eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607(), eyePosition.field_1350);
        }
        this.renderChunkLayer(class_1921.method_23583(), (Matrix4f)poseStack, projection);
        this.renderChunkLayer(class_1921.method_29997(), (Matrix4f)poseStack, projection);
        if (eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607() >= (double)cloudHeight) {
            this.renderClouds(poseStack, eyePosition.field_1352, eyePosition.field_1351 + (double)this.blockAccess.getGround() + (double)this.blockAccess.method_31607(), eyePosition.field_1350);
        }
        RenderSystem.depthMask((boolean)false);
        this.renderSnowAndRain(poseStack, eyePosition.field_1352, 0.0, eyePosition.field_1350);
        RenderSystem.depthMask((boolean)true);
        poseStack.popMatrix();
        this.turnOffLightLayer();
        this.mc.field_1690.method_42534().method_41748((Object)current);
    }

    private void renderChunkLayer(class_1921 layer, Matrix4f modelView, Matrix4f Projection) {
        List<class_291> buffers = this.vertexBuffers.get(layer);
        if (buffers.size() == 0) {
            return;
        }
        layer.method_23516();
        class_5944 shaderInstance = RenderSystem.getShader();
        shaderInstance.method_34586();
        this.turnOnLightLayer();
        for (class_291 vertexBuffer : buffers) {
            vertexBuffer.method_1353();
            vertexBuffer.method_34427(modelView, Projection, shaderInstance);
        }
        this.turnOffLightLayer();
    }

    public void prepare() {
        if (this.vertexBuffers == null && !this.building) {
            VRSettings.logger.info("MenuWorlds: Building geometry...");
            if (this.rand.nextInt(1000) == 0) {
                this.blockAccess.setGroundOffset(100.0f);
            }
            this.fastTime = new Random().nextInt(10) == 0;
            this.animatedSprites = ConcurrentHashMap.newKeySet();
            this.blockCounts = new ConcurrentHashMap<Pair<class_1921, class_2338>, Integer>();
            this.renderTimes = new ConcurrentHashMap<Pair<class_1921, class_2338>, Long>();
            try {
                this.vertexBuffers = new HashMap();
                this.bufferBuilders = new HashMap<Pair<class_1921, class_2338>, class_287>();
                this.currentPositions = new HashMap<Pair<class_1921, class_2338>, class_2338.class_2339>();
                for (class_1921 layer : class_1921.method_22720()) {
                    this.vertexBuffers.put(layer, new LinkedList());
                    for (int x = -this.blockAccess.getXSize() / 2; x < this.blockAccess.getXSize() / 2; x += this.segmentSize.method_10263()) {
                        for (int y = (int)(-this.blockAccess.getGround()); y < this.blockAccess.getYSize() - (int)this.blockAccess.getGround(); y += this.segmentSize.method_10264()) {
                            for (int z = -this.blockAccess.getZSize() / 2; z < this.blockAccess.getZSize() / 2; z += this.segmentSize.method_10260()) {
                                class_2338 pos = new class_2338(x, y, z);
                                Pair pair = Pair.of((Object)layer, (Object)pos);
                                class_287 vertBuffer = new class_287(32768);
                                vertBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
                                this.bufferBuilders.put((Pair<class_1921, class_2338>)pair, vertBuffer);
                                this.currentPositions.put((Pair<class_1921, class_2338>)pair, pos.method_25503());
                            }
                        }
                    }
                }
            }
            catch (OutOfMemoryError e) {
                VRSettings.logger.error("OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?");
                this.destroy();
                return;
            }
            this.buildStartTime = Utils.milliTime();
            this.building = true;
        }
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void buildNext() {
        if (!this.builderFutures.stream().allMatch(CompletableFuture::isDone) || this.builderError != null) {
            return;
        }
        this.builderFutures.clear();
        if (this.currentPositions.entrySet().stream().allMatch(entry2 -> ((class_2338.class_2339)entry2.getValue()).method_10264() >= Math.min(this.segmentSize.method_10264() + ((class_2338)((Pair)entry2.getKey()).getRight()).method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()))) {
            this.finishBuilding();
            return;
        }
        long startTime = Utils.milliTime();
        for (Pair<class_1921, class_2338> pair : this.bufferBuilders.keySet()) {
            if (this.currentPositions.get(pair).method_10264() >= Math.min(this.segmentSize.method_10264() + ((class_2338)pair.getRight()).method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) continue;
            if (firstRenderDone || !SodiumHelper.isLoaded() || !SodiumHelper.hasIssuesWithParallelBlockBuilding()) {
                this.builderFutures.add(CompletableFuture.runAsync(() -> this.buildGeometry(pair, startTime, this.renderMaxTime), class_156.method_18349()));
                continue;
            }
            this.buildGeometry(pair, startTime, this.renderMaxTime);
            if (this.blockCounts.getOrDefault(pair, 0) <= 0) continue;
            firstRenderDone = true;
        }
        CompletableFuture.allOf(this.builderFutures.toArray(new CompletableFuture[0])).thenRunAsync(this::handleError, class_156.method_18349());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGeometry(Pair<class_1921, class_2338> pair, long startTime, int maxTime) {
        if (Utils.milliTime() - startTime >= (long)maxTime) {
            return;
        }
        class_1921 layer = (class_1921)pair.getLeft();
        class_2338 offset = (class_2338)pair.getRight();
        this.builderThreads.add(Thread.currentThread());
        long realStartTime = Utils.milliTime();
        try {
            class_4587 thisPose = new class_4587();
            int renderDistSquare = (this.renderDistance + 1) * (this.renderDistance + 1);
            class_776 blockRenderer = this.mc.method_1541();
            class_287 vertBuffer = this.bufferBuilders.get(pair);
            class_2338.class_2339 pos = this.currentPositions.get(pair);
            class_5819 randomSource = class_5819.method_43047();
            int count = 0;
            while (Utils.milliTime() - startTime < (long)maxTime && pos.method_10264() < Math.min(this.segmentSize.method_10264() + offset.method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()) && this.building) {
                class_2680 state;
                if (class_3532.method_15382((int)pos.method_10264()) <= this.renderDistance + 1 && class_3532.method_41189((double)pos.method_10263(), (double)pos.method_10260()) <= (double)renderDistSquare && (state = this.blockAccess.method_8320((class_2338)pos)) != null) {
                    class_3610 fluidState = state.method_26227();
                    if (!fluidState.method_15769() && class_4696.method_23680((class_3610)fluidState) == layer) {
                        for (class_1058 sprite : Xplat.getFluidTextures((class_1920)this.blockAccess, (class_2338)pos, fluidState)) {
                            if (sprite == null || sprite.method_45851().method_45817().sum() <= 1) continue;
                            this.animatedSprites.add(sprite);
                        }
                        blockRenderer.method_3352((class_2338)pos, (class_1920)this.blockAccess, (class_4588)vertBuffer, state, (class_3610)new FluidStateWrapper(fluidState));
                        ++count;
                    }
                    if (state.method_26217() != class_2464.field_11455 && class_4696.method_23679((class_2680)state) == layer) {
                        for (class_777 quad : this.mc.method_1554().method_4743().method_3335(state).method_4707(state, null, randomSource)) {
                            if (quad.method_35788().method_45851().method_45817().sum() <= 1) continue;
                            this.animatedSprites.add(quad.method_35788());
                        }
                        thisPose.method_22903();
                        thisPose.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                        blockRenderer.method_3355(state, (class_2338)pos, (class_1920)this.blockAccess, thisPose, (class_4588)vertBuffer, true, randomSource);
                        ++count;
                        thisPose.method_22909();
                    }
                }
                pos.method_33097(pos.method_10263() + 1);
                if (pos.method_10263() < Math.min(this.segmentSize.method_10263() + offset.method_10263(), this.blockAccess.getXSize() / 2)) continue;
                pos.method_33097(offset.method_10263());
                pos.method_33099(pos.method_10260() + 1);
                if (pos.method_10260() < Math.min(this.segmentSize.method_10260() + offset.method_10260(), this.blockAccess.getZSize() / 2)) continue;
                pos.method_33099(offset.method_10260());
                pos.method_33098(pos.method_10264() + 1);
            }
            this.blockCounts.put(pair, this.blockCounts.getOrDefault(pair, 0) + count);
            this.renderTimes.put(pair, this.renderTimes.getOrDefault(pair, 0L) + (Utils.milliTime() - realStartTime));
            if (pos.method_10264() >= Math.min(this.segmentSize.method_10264() + offset.method_10264(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) {
                VRSettings.logger.debug("MenuWorlds: Built {} blocks on {} layer at {},{},{} in {} ms", new Object[]{this.blockCounts.get(pair), ((RenderStateShardAccessor)layer).getName(), offset.method_10263(), offset.method_10264(), offset.method_10260(), this.renderTimes.get(pair)});
            }
        }
        catch (Throwable e) {
            this.builderError = e;
        }
        finally {
            this.builderThreads.remove(Thread.currentThread());
        }
    }

    private void finishBuilding() {
        this.building = false;
        ArrayList<Map.Entry<Pair<class_1921, class_2338>, class_287>> entryList = new ArrayList<Map.Entry<Pair<class_1921, class_2338>, class_287>>(this.bufferBuilders.entrySet());
        entryList.sort(Comparator.comparing(entry2 -> (class_2338)((Pair)entry2.getKey()).getRight(), (posA, posB) -> {
            class_2382 center = new class_2382(this.segmentSize.method_10263() / 2, this.segmentSize.method_10264() / 2, this.segmentSize.method_10260() / 2);
            double distA = posA.method_10081(center).method_10262((class_2382)class_2338.field_10980);
            double distB = posB.method_10081(center).method_10262((class_2382)class_2338.field_10980);
            return Double.compare(distA, distB);
        }));
        int totalMemory = 0;
        int count = 0;
        for (Map.Entry<Pair<class_1921, class_2338>, class_287> entry3 : entryList) {
            class_287.class_7433 renderedBuffer;
            class_1921 layer = (class_1921)entry3.getKey().getLeft();
            class_287 vertBuffer = entry3.getValue();
            if (layer == class_1921.method_23583()) {
                vertBuffer.method_49904(class_8251.method_49906((float)0.0f, (float)class_3532.method_22450((float)this.blockAccess.getGround()), (float)0.0f));
            }
            if (!(renderedBuffer = vertBuffer.method_1326()).method_43584()) {
                this.uploadGeometry(layer, renderedBuffer);
                ++count;
            }
            totalMemory += ((BufferBuilderExtension)vertBuffer).vivecraft$getBufferSize();
            ((BufferBuilderExtension)vertBuffer).vivecraft$freeBuffer();
        }
        this.bufferBuilders = null;
        this.currentPositions = null;
        this.ready = true;
        VRSettings.logger.info("MenuWorlds: Built {} blocks in {} ms ({} ms CPU time)", new Object[]{this.blockCounts.values().stream().reduce(Integer::sum).orElse(0), Utils.milliTime() - this.buildStartTime, this.renderTimes.values().stream().reduce(Long::sum).orElse(0L)});
        VRSettings.logger.info("MenuWorlds: Used {} temporary buffers ({} MiB), uploaded {} non-empty buffers", new Object[]{entryList.size(), totalMemory / 0x100000, count});
    }

    public boolean isOnBuilderThread() {
        return this.builderThreads.contains(Thread.currentThread());
    }

    private void handleError() {
        if (this.builderError == null) {
            return;
        }
        if (this.builderError instanceof OutOfMemoryError || this.builderError.getCause() instanceof OutOfMemoryError) {
            VRSettings.logger.error("OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?");
        } else {
            VRSettings.logger.error("Exception thrown when building main menu world, falling back to old menu room. \n {}", (Object)this.builderError.getMessage());
        }
        this.builderError.printStackTrace();
        this.destroy();
        this.setWorld(null);
        this.builderError = null;
    }

    private void uploadGeometry(class_1921 layer, class_287.class_7433 renderedBuffer) {
        class_291 buffer = new class_291(class_291.class_8555.field_44793);
        buffer.method_1353();
        buffer.method_1352(renderedBuffer);
        class_291.method_1354();
        this.vertexBuffers.get(layer).add(buffer);
    }

    public void cancelBuilding() {
        this.building = false;
        this.builderFutures.forEach(CompletableFuture::join);
        this.builderFutures.clear();
        if (this.bufferBuilders != null) {
            for (class_287 vertBuffer : this.bufferBuilders.values()) {
                ((BufferBuilderExtension)vertBuffer).vivecraft$freeBuffer();
            }
            this.bufferBuilders = null;
        }
        this.currentPositions = null;
    }

    public void destroy() {
        this.cancelBuilding();
        if (this.vertexBuffers != null) {
            for (List<class_291> buffers : this.vertexBuffers.values()) {
                for (class_291 vertexBuffer : buffers) {
                    if (vertexBuffer == null) continue;
                    vertexBuffer.close();
                }
            }
            this.vertexBuffers = null;
        }
        this.animatedSprites = null;
        this.ready = false;
    }

    public void completeDestroy() {
        this.destroy();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        if (this.cloudVBO != null) {
            this.cloudVBO.close();
        }
        this.ready = false;
    }

    public void tick() {
        ++this.ticks;
        this.updateTorchFlicker();
        if (this.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517)) {
            int i = 1;
            this.waterVisionTime = class_3532.method_15340((int)(this.waterVisionTime + i), (int)0, (int)600);
        } else if (this.waterVisionTime > 0) {
            this.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517);
            this.waterVisionTime = class_3532.method_15340((int)(this.waterVisionTime - 10), (int)0, (int)600);
        }
        if (SodiumHelper.isLoaded() && this.animatedSprites != null) {
            for (class_1058 sprite : this.animatedSprites) {
                SodiumHelper.markTextureAsActive(sprite);
            }
        }
        if (OptifineHelper.isOptifineLoaded()) {
            for (class_1058 sprite : this.animatedSprites) {
                OptifineHelper.markTextureAsActive(sprite);
            }
        }
    }

    public FakeBlockAccess getLevel() {
        return this.blockAccess;
    }

    public void setWorld(FakeBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
        if (blockAccess != null) {
            this.dimensionInfo = blockAccess.getDimensionReaderInfo();
            this.lightmapUpdateNeeded = true;
            this.renderDistance = blockAccess.getXSize() / 2;
            this.renderDistanceChunks = this.renderDistance / 16;
            this.rainLevel = blockAccess.getRain() ? 1.0f : 0.0f;
            this.thunderLevel = blockAccess.getThunder() ? 1.0f : 0.0f;
            this.worldRotation = blockAccess.getRotation();
        }
    }

    public void loadRenderers() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float g = i - 16;
                float h = class_3532.method_15355((float)(f * f + g * g));
                this.rainSizeX[i << 5 | j] = -g / h;
                this.rainSizeZ[i << 5 | j] = f / h;
            }
        }
        this.generateSky();
        this.generateSky2();
        this.generateStars();
    }

    public boolean isReady() {
        return this.ready;
    }

    private void copyVisibleTextures() {
    }

    public void pushVisibleTextures() {
    }

    public void renderSky(Matrix4fStack poseStack, class_243 position) {
        if (this.dimensionInfo.method_29992() == class_5294.class_5401.field_25641) {
            this.renderEndSky(poseStack);
        } else if (this.dimensionInfo.method_29992() == class_5294.class_5401.field_25640) {
            float starBrightness;
            RenderSystem.setShader(class_757::method_34539);
            this.fogRenderer.setupFog(class_758.class_4596.field_20945);
            class_5944 skyShader = RenderSystem.getShader();
            class_243 skyColor = this.getSkyColor(position);
            if (OptifineHelper.isOptifineLoaded()) {
                skyColor = OptifineHelper.getCustomSkyColor(skyColor, (class_1920)this.blockAccess, position.field_1352, position.field_1351, position.field_1350);
            }
            this.fogRenderer.levelFogColor();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)((float)skyColor.field_1352), (float)((float)skyColor.field_1351), (float)((float)skyColor.field_1350), (float)1.0f);
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
                this.skyVBO.method_1353();
                this.skyVBO.method_34427((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), skyShader);
                class_291.method_1354();
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            float[] sunriseColor = this.dimensionInfo.method_28109(this.getTimeOfDay(), 0.0f);
            if (sunriseColor != null && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled())) {
                RenderSystem.setShader(class_757::method_34540);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.pushMatrix();
                poseStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                poseStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)this.getSunAngle()) < 0.0f ? 180.0f : 0.0f));
                poseStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f));
                Matrix4fStack modelView = poseStack;
                bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                bufferBuilder.method_22918((Matrix4f)modelView, 0.0f, 100.0f, 0.0f).method_22915(sunriseColor[0], sunriseColor[1], sunriseColor[2], sunriseColor[3]).method_1344();
                for (int j = 0; j <= 16; ++j) {
                    float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f7 = class_3532.method_15374((float)f6);
                    float f8 = class_3532.method_15362((float)f6);
                    bufferBuilder.method_22918((Matrix4f)modelView, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * sunriseColor[3]).method_22915(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f).method_1344();
                }
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
                poseStack.popMatrix();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            poseStack.pushMatrix();
            float f10 = 1.0f - this.getRainLevel();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f10);
            poseStack.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
            Matrix4fStack modelView = poseStack;
            poseStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(this.getTimeOfDay() * 360.0f));
            float size = 30.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)SUN_LOCATION);
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                bufferBuilder.method_22918((Matrix4f)modelView, -size, 100.0f, -size).method_22913(0.0f, 0.0f).method_1344();
                bufferBuilder.method_22918((Matrix4f)modelView, size, 100.0f, -size).method_22913(1.0f, 0.0f).method_1344();
                bufferBuilder.method_22918((Matrix4f)modelView, size, 100.0f, size).method_22913(1.0f, 1.0f).method_1344();
                bufferBuilder.method_22918((Matrix4f)modelView, -size, 100.0f, size).method_22913(0.0f, 1.0f).method_1344();
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            }
            size = 20.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                RenderSystem.setShaderTexture((int)0, (class_2960)MOON_LOCATION);
                int moonPhase = this.getMoonPhase();
                int l = moonPhase % 4;
                int i1 = moonPhase / 4 % 2;
                float u0 = (float)l / 4.0f;
                float v0 = (float)i1 / 2.0f;
                float u1 = (float)(l + 1) / 4.0f;
                float v1 = (float)(i1 + 1) / 2.0f;
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                bufferBuilder.method_22918((Matrix4f)modelView, -size, -100.0f, size).method_22913(u0, v1).method_1344();
                bufferBuilder.method_22918((Matrix4f)modelView, size, -100.0f, size).method_22913(u1, v1).method_1344();
                bufferBuilder.method_22918((Matrix4f)modelView, size, -100.0f, -size).method_22913(u1, v0).method_1344();
                bufferBuilder.method_22918((Matrix4f)modelView, -size, -100.0f, -size).method_22913(u0, v0).method_1344();
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            }
            if ((starBrightness = this.getStarBrightness() * f10) > 0.0f && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isStarsEnabled())) {
                RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                this.fogRenderer.setupNoFog();
                this.starVBO.method_1353();
                this.starVBO.method_34427((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), class_757.method_34539());
                class_291.method_1354();
                this.fogRenderer.setupFog(class_758.class_4596.field_20945);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.popMatrix();
            double horizonDistance = position.field_1351 - this.blockAccess.getHorizon();
            if (horizonDistance < 0.0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                poseStack.pushMatrix();
                poseStack.translate(0.0f, 12.0f, 0.0f);
                this.sky2VBO.method_1353();
                this.sky2VBO.method_34427((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), skyShader);
                class_291.method_1354();
                poseStack.popMatrix();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
    }

    private void renderEndSky(Matrix4fStack poseStack) {
        if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)END_SKY_LOCATION);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            for (int i = 0; i < 6; ++i) {
                poseStack.pushMatrix();
                switch (i) {
                    case 1: {
                        poseStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                        break;
                    }
                    case 2: {
                        poseStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
                        break;
                    }
                    case 3: {
                        poseStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
                        break;
                    }
                    case 4: {
                        poseStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f));
                        break;
                    }
                    case 5: {
                        poseStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(-90.0f));
                    }
                }
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                int r = 40;
                int g = 40;
                int b = 40;
                if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isCustomColors()) {
                    class_243 newSkyColor = new class_243((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
                    newSkyColor = OptifineHelper.getCustomSkyColorEnd(newSkyColor);
                    r = (int)(newSkyColor.field_1352 * 255.0);
                    g = (int)(newSkyColor.field_1351 * 255.0);
                    b = (int)(newSkyColor.field_1350 * 255.0);
                }
                bufferBuilder.method_22918((Matrix4f)poseStack, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, 255).method_1344();
                bufferBuilder.method_22918((Matrix4f)poseStack, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_1336(r, g, b, 255).method_1344();
                bufferBuilder.method_22918((Matrix4f)poseStack, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_1336(r, g, b, 255).method_1344();
                bufferBuilder.method_22918((Matrix4f)poseStack, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_1336(r, g, b, 255).method_1344();
                tesselator.method_1350();
                poseStack.popMatrix();
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    public void renderClouds(Matrix4fStack poseStack, double x, double y, double z) {
        float cloudHeight = this.dimensionInfo.method_28108();
        if (!Float.isNaN(cloudHeight) && this.mc.field_1690.method_1632() != class_4063.field_18162) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            float cloudSizeXZ = 12.0f;
            float cloudSizeY = 4.0f;
            double cloudOffset = ((float)this.ticks + this.mc.method_1488()) * 0.03f;
            double cloudX = (x + cloudOffset) / 12.0;
            double cloudY = (double)cloudHeight - y + 0.33;
            if (OptifineHelper.isOptifineLoaded()) {
                cloudY += OptifineHelper.getCloudHeight() * 128.0;
            }
            double cloudZ = z / 12.0 + 0.33;
            cloudX -= (double)(class_3532.method_15357((double)(cloudX / 2048.0)) * 2048);
            cloudZ -= (double)(class_3532.method_15357((double)(cloudZ / 2048.0)) * 2048);
            float cloudXfract = (float)(cloudX - (double)class_3532.method_15357((double)cloudX));
            float cloudYfract = (float)(cloudY / 4.0 - (double)class_3532.method_15357((double)(cloudY / 4.0))) * 4.0f;
            float cloudZfract = (float)(cloudZ - (double)class_3532.method_15357((double)cloudZ));
            class_243 cloudColor = this.getCloudColour();
            int cloudXfloor = (int)Math.floor(cloudX);
            int cloudYfloor = (int)Math.floor(cloudY / 4.0);
            int cloudZfloor = (int)Math.floor(cloudZ);
            if (cloudXfloor != this.prevCloudX || cloudYfloor != this.prevCloudY || cloudZfloor != this.prevCloudZ || this.mc.field_1690.method_1632() != this.prevCloudsType || this.prevCloudColor.method_1025(cloudColor) > 2.0E-4) {
                this.prevCloudX = cloudXfloor;
                this.prevCloudY = cloudYfloor;
                this.prevCloudZ = cloudZfloor;
                this.prevCloudColor = cloudColor;
                this.prevCloudsType = this.mc.field_1690.method_1632();
                this.generateClouds = true;
            }
            if (this.generateClouds) {
                this.generateClouds = false;
                class_287 bufferBuilder = class_289.method_1348().method_1349();
                if (this.cloudVBO != null) {
                    this.cloudVBO.close();
                }
                this.cloudVBO = new class_291(class_291.class_8555.field_44793);
                class_287.class_7433 renderedBuffer = this.buildClouds(bufferBuilder, cloudX, cloudY, cloudZ, cloudColor);
                this.cloudVBO.method_1353();
                this.cloudVBO.method_1352(renderedBuffer);
                class_291.method_1354();
            }
            RenderSystem.setShader(class_757::method_56846);
            RenderSystem.setShaderTexture((int)0, (class_2960)CLOUDS_LOCATION);
            this.fogRenderer.levelFogColor();
            poseStack.pushMatrix();
            poseStack.scale(12.0f, 1.0f, 12.0f);
            poseStack.translate(-cloudXfract, cloudYfract, -cloudZfract);
            if (this.cloudVBO != null) {
                int w;
                this.cloudVBO.method_1353();
                int n = w = this.prevCloudsType == class_4063.field_18164 ? 0 : 1;
                while (w < 2) {
                    if (w == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    this.cloudVBO.method_34427((Matrix4f)poseStack, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                    ++w;
                }
                class_291.method_1354();
            }
            poseStack.popMatrix();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    private class_287.class_7433 buildClouds(class_287 bufferBuilder, double cloudX, double cloudY, double cloudZ, class_243 cloudColor) {
        float l = (float)class_3532.method_15357((double)cloudX) * 0.00390625f;
        float m = (float)class_3532.method_15357((double)cloudZ) * 0.00390625f;
        float redTop = (float)cloudColor.field_1352;
        float greenTop = (float)cloudColor.field_1351;
        float blueTop = (float)cloudColor.field_1350;
        float redX = redTop * 0.9f;
        float greenX = greenTop * 0.9f;
        float blueX = blueTop * 0.9f;
        float redBottom = redTop * 0.7f;
        float greenBottom = greenTop * 0.7f;
        float blueBottom = blueTop * 0.7f;
        float redZ = redTop * 0.8f;
        float greenZ = greenTop * 0.8f;
        float blueZ = blueTop * 0.8f;
        RenderSystem.setShader(class_757::method_56846);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1577);
        float z = (float)Math.floor(cloudY / 4.0) * 4.0f;
        if (this.prevCloudsType == class_4063.field_18164) {
            for (int aa = -3; aa <= 4; ++aa) {
                for (int ab = -3; ab <= 4; ++ab) {
                    int ae;
                    float ac = aa * 8;
                    float ad = ab * 8;
                    if (z > -5.0f) {
                        bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + 8.0f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redBottom, greenBottom, blueBottom, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + 8.0f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redBottom, greenBottom, blueBottom, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + 0.0f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redBottom, greenBottom, blueBottom, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + 0.0f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redBottom, greenBottom, blueBottom, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    }
                    if (z <= 5.0f) {
                        bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 8.0f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 8.0f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 0.0f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 0.0f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                    }
                    if (aa > -1) {
                        for (ae = 0; ae < 8; ++ae) {
                            bufferBuilder.method_22912((double)(ac + (float)ae + 0.0f), (double)(z + 0.0f), (double)(ad + 8.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + (float)ae + 0.0f), (double)(z + 4.0f), (double)(ad + 8.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + (float)ae + 0.0f), (double)(z + 4.0f), (double)(ad + 0.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + (float)ae + 0.0f), (double)(z + 0.0f), (double)(ad + 0.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                        }
                    }
                    if (aa <= 1) {
                        for (ae = 0; ae < 8; ++ae) {
                            bufferBuilder.method_22912((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 0.0f), (double)(ad + 8.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 4.0f), (double)(ad + 8.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 4.0f), (double)(ad + 0.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 0.0f), (double)(ad + 0.0f)).method_22913((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).method_22915(redX, greenX, blueX, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                        }
                    }
                    if (ab > -1) {
                        for (ae = 0; ae < 8; ++ae) {
                            bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 0.0f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 0.0f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 0.0f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                            bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 0.0f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                        }
                    }
                    if (ab > 1) continue;
                    for (ae = 0; ae < 8; ++ae) {
                        bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).method_22913((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                        bufferBuilder.method_22912((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).method_22913((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).method_22915(redZ, greenZ, blueZ, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                    }
                }
            }
        } else {
            boolean aa = true;
            int ab = 32;
            for (int af = -32; af < 32; af += 32) {
                for (int ag = -32; ag < 32; ag += 32) {
                    bufferBuilder.method_22912((double)af, (double)z, (double)(ag + 32)).method_22913((float)af * 0.00390625f + l, (float)(ag + 32) * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    bufferBuilder.method_22912((double)(af + 32), (double)z, (double)(ag + 32)).method_22913((float)(af + 32) * 0.00390625f + l, (float)(ag + 32) * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    bufferBuilder.method_22912((double)(af + 32), (double)z, (double)ag).method_22913((float)(af + 32) * 0.00390625f + l, (float)ag * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    bufferBuilder.method_22912((double)af, (double)z, (double)ag).method_22913((float)af * 0.00390625f + l, (float)ag * 0.00390625f + m).method_22915(redTop, greenTop, blueTop, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                }
            }
        }
        return bufferBuilder.method_1326();
    }

    private void renderSnowAndRain(Matrix4fStack poseStack, double inX, double inY, double inZ) {
        if (this.getRainLevel() <= 0.0f) {
            return;
        }
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)poseStack);
        RenderSystem.applyModelViewMatrix();
        int xFloor = class_3532.method_15357((double)inX);
        int yFloor = class_3532.method_15357((double)inY);
        int zFloor = class_3532.method_15357((double)inZ);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int rainDistance = 5;
        if (class_310.method_1517()) {
            rainDistance = 10;
        }
        RenderSystem.depthMask((boolean)true);
        int count = -1;
        float rainAnimationTime = (float)this.ticks + this.mc.method_1488();
        RenderSystem.setShader(class_757::method_34546);
        this.turnOnLightLayer();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int rainZ = zFloor - rainDistance; rainZ <= zFloor + rainDistance; ++rainZ) {
            for (int rainX = xFloor - rainDistance; rainX <= xFloor + rainDistance; ++rainX) {
                float blend;
                int upper;
                int blockingHeight;
                int lower;
                int q = (rainZ - zFloor + 16) * 32 + rainX - xFloor + 16;
                double r = (double)this.rainSizeX[q] * 0.5;
                double s = (double)this.rainSizeZ[q] * 0.5;
                mutableBlockPos.method_10102((double)rainX, inY, (double)rainZ);
                class_1959 biome = (class_1959)this.blockAccess.method_23753((class_2338)mutableBlockPos).comp_349();
                if (!biome.method_48163() || (lower = Math.max(yFloor - rainDistance, blockingHeight = this.blockAccess.getHeightBlocking(rainX, rainZ))) == (upper = Math.max(yFloor + rainDistance, blockingHeight))) continue;
                int rainY = Math.max(blockingHeight, yFloor);
                class_5819 randomSource = class_5819.method_43049((long)((long)(rainX * rainX) * 3121L + (long)rainX * 45238971L ^ (long)(rainZ * rainZ) * 418711L + (long)rainZ * 13761L));
                mutableBlockPos.method_33098(lower);
                class_1959.class_1963 precipitation = biome.method_48162((class_2338)mutableBlockPos);
                if (precipitation == class_1959.class_1963.field_9384) continue;
                mutableBlockPos.method_33098(rainY);
                double localX = (double)rainX + 0.5;
                double localZ = (double)rainZ + 0.5;
                float distance = (float)Math.sqrt(localX * localX + localZ * localZ) / (float)rainDistance;
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                int skyLight = this.blockAccess.method_8314(class_1944.field_9284, (class_2338)mutableBlockPos) << 4;
                int blockLight = this.blockAccess.method_8314(class_1944.field_9282, (class_2338)mutableBlockPos) << 4;
                if (precipitation == class_1959.class_1963.field_9382) {
                    if (count != 0) {
                        if (count >= 0) {
                            tesselator.method_1350();
                        }
                        count = 0;
                        RenderSystem.setShaderTexture((int)0, (class_2960)RAIN_LOCATION);
                        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    blend = (1.0f - distance * distance) * 0.5f + 0.5f;
                    int x = this.ticks + rainX * rainX * 3121 + rainX * 45238971 + rainZ * rainZ * 418711 + rainZ * 13761 & 0x1F;
                    yOffset = -((float)x + this.mc.method_1488()) / 32.0f * (3.0f + randomSource.method_43057());
                } else {
                    if (precipitation != class_1959.class_1963.field_9383) continue;
                    if (count != 1) {
                        if (count >= 0) {
                            tesselator.method_1350();
                        }
                        count = 1;
                        RenderSystem.setShaderTexture((int)0, (class_2960)SNOW_LOCATION);
                        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    blend = (1.0f - distance * distance) * 0.3f + 0.5f;
                    xOffset = (float)(randomSource.method_43058() + (double)rainAnimationTime * 0.01 * (double)((float)randomSource.method_43059()));
                    float ae = -((float)(this.ticks & 0x1FF) + this.mc.method_1488()) / 512.0f;
                    float af = (float)(randomSource.method_43058() + (double)(rainAnimationTime * (float)randomSource.method_43059()) * 0.001);
                    yOffset = ae + af;
                    skyLight = (skyLight * 3 + 240) / 4;
                    blockLight = (blockLight * 3 + 240) / 4;
                }
                bufferBuilder.method_22912(localX - r, (double)upper - inY, localZ - s).method_22913(0.0f + xOffset, (float)lower * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight).method_1344();
                bufferBuilder.method_22912(localX + r, (double)upper - inY, localZ + s).method_22913(1.0f + xOffset, (float)lower * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight).method_1344();
                bufferBuilder.method_22912(localX + r, (double)lower - inY, localZ + s).method_22913(1.0f + xOffset, (float)upper * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight).method_1344();
                bufferBuilder.method_22912(localX - r, (double)lower - inY, localZ - s).method_22913(0.0f + xOffset, (float)upper * 0.25f + yOffset).method_22915(1.0f, 1.0f, 1.0f, blend).method_22921(blockLight, skyLight).method_1344();
            }
        }
        if (count >= 0) {
            tesselator.method_1350();
        }
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        this.turnOffLightLayer();
    }

    public static int getLightColor(class_1920 blockAndTintGetter, class_2338 blockPos) {
        int i = blockAndTintGetter.method_8314(class_1944.field_9284, blockPos);
        int j = blockAndTintGetter.method_8314(class_1944.field_9282, blockPos);
        return i << 20 | j << 4;
    }

    public float getTimeOfDay() {
        return this.blockAccess.method_8597().method_28528(this.time);
    }

    public float getSunAngle() {
        float dayTime = this.getTimeOfDay();
        return dayTime * ((float)Math.PI * 2);
    }

    public int getMoonPhase() {
        return this.blockAccess.method_8597().method_28531(this.time);
    }

    public float getSkyDarken() {
        float dayTime = this.getTimeOfDay();
        float h = 1.0f - (class_3532.method_15362((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        h = class_3532.method_15363((float)h, (float)0.0f, (float)1.0f);
        h = 1.0f - h;
        h *= 1.0f - this.getRainLevel() * 5.0f / 16.0f;
        return (h *= 1.0f - this.getThunderLevel() * 5.0f / 16.0f) * 0.8f + 0.2f;
    }

    public float getRainLevel() {
        return this.rainLevel;
    }

    public float getThunderLevel() {
        return this.thunderLevel * this.getRainLevel();
    }

    public float getStarBrightness() {
        float f = this.getTimeOfDay();
        float f1 = 1.0f - (class_3532.method_15362((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = class_3532.method_15363((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public class_243 getSkyColor(class_243 position) {
        float f;
        float darkening;
        float luminance;
        float dayTime = this.getTimeOfDay();
        class_243 samplePosition = position.method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        class_243 skyColor = class_6491.method_24895((class_243)samplePosition, (i, j, k) -> class_243.method_24457((int)((class_1959)this.blockAccess.method_22385().method_24854(i, j, k).comp_349()).method_8697()));
        float h = class_3532.method_15362((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        h = class_3532.method_15363((float)h, (float)0.0f, (float)1.0f);
        float skyColorR = (float)skyColor.field_1352 * h;
        float skyColorG = (float)skyColor.field_1351 * h;
        float skyColorB = (float)skyColor.field_1350 * h;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.6f;
            darkening = 1.0f - rain * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        float thunder = this.getThunderLevel();
        if (f > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.2f;
            darkening = 1.0f - thunder * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        if (!((Boolean)this.mc.field_1690.method_41784().method_41753()).booleanValue() && this.skyFlashTime > 0) {
            float flash = (float)this.skyFlashTime - this.mc.method_1488();
            if (flash > 1.0f) {
                flash = 1.0f;
            }
            skyColorR = skyColorR * (1.0f - (flash *= 0.45f)) + 0.8f * flash;
            skyColorG = skyColorG * (1.0f - flash) + 0.8f * flash;
            skyColorB = skyColorB * (1.0f - flash) + flash;
        }
        return new class_243((double)skyColorR, (double)skyColorG, (double)skyColorB);
    }

    public class_243 getFogColor(class_243 pos) {
        float f = class_3532.method_15363((float)(class_3532.method_15362((float)(this.getTimeOfDay() * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        class_243 scaledPos = pos.method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        return class_6491.method_24895((class_243)scaledPos, (x, y, z) -> this.dimensionInfo.method_28112(class_243.method_24457((int)((class_1959)this.blockAccess.method_22385().method_24854(x, y, z).comp_349()).method_24376()), f));
    }

    public class_243 getCloudColour() {
        float dayTime = this.getTimeOfDay();
        float f1 = class_3532.method_15362((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = class_3532.method_15363((float)f1, (float)0.0f, (float)1.0f);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            float luma = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float dark = 1.0f - rain * 0.95f;
            r = r * dark + luma * (1.0f - dark);
            g = g * dark + luma * (1.0f - dark);
            b = b * dark + luma * (1.0f - dark);
        }
        r *= f1 * 0.9f + 0.1f;
        g *= f1 * 0.9f + 0.1f;
        b *= f1 * 0.85f + 0.15f;
        float thunder = this.getThunderLevel();
        if (thunder > 0.0f) {
            float luma = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float dark = 1.0f - thunder * 0.95f;
            r = r * dark + luma * (1.0f - dark);
            g = g * dark + luma * (1.0f - dark);
            b = b * dark + luma * (1.0f - dark);
        }
        return new class_243((double)r, (double)g, (double)b);
    }

    private void generateSky() {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        this.skyVBO = new class_291(class_291.class_8555.field_44793);
        class_287.class_7433 renderedBuffer = MenuWorldRenderer.buildSkyDisc(bufferBuilder, 16.0f);
        this.skyVBO.method_1353();
        this.skyVBO.method_1352(renderedBuffer);
        class_291.method_1354();
    }

    private void generateSky2() {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.sky2VBO = new class_291(class_291.class_8555.field_44793);
        class_287.class_7433 renderedBuffer = MenuWorldRenderer.buildSkyDisc(bufferBuilder, -16.0f);
        this.sky2VBO.method_1353();
        this.sky2VBO.method_1352(renderedBuffer);
        class_291.method_1354();
    }

    private static class_287.class_7433 buildSkyDisc(class_287 bufferBuilder, float posY) {
        float g = Math.signum(posY) * 512.0f;
        float h = 512.0f;
        RenderSystem.setShader(class_757::method_34539);
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1592);
        bufferBuilder.method_22912(0.0, (double)posY, 0.0).method_1344();
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.method_22912((double)(g * class_3532.method_15362((float)((float)i * ((float)Math.PI / 180)))), (double)posY, (double)(512.0f * class_3532.method_15374((float)((float)i * ((float)Math.PI / 180))))).method_1344();
        }
        return bufferBuilder.method_1326();
    }

    private void generateStars() {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = new class_291(class_291.class_8555.field_44793);
        class_287.class_7433 renderedBuffer = this.buildStars(bufferBuilder);
        this.starVBO.method_1353();
        this.starVBO.method_1352(renderedBuffer);
        class_291.method_1354();
    }

    private class_287.class_7433 buildStars(class_287 bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.method_22912(d5 + d25, d6 + d23, d7 + d26).method_1344();
            }
        }
        return bufferBuilderIn.method_1326();
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture((int)2, (int)0);
    }

    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture((int)2, (class_2960)this.lightTextureLocation);
        this.mc.method_1531().method_22813(this.lightTextureLocation);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
    }

    public void updateTorchFlicker() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.lightmapUpdateNeeded = true;
    }

    public void updateLightmap() {
        if (this.lightmapUpdateNeeded) {
            float skyLight = this.getSkyDarken();
            float effectiveSkyLight = this.skyFlashTime > 0 ? 1.0f : skyLight * 0.95f + 0.05f;
            float waterVision = this.getWaterVision();
            float nightVision = 0.0f;
            Vector3f skylightColor = new Vector3f(skyLight, skyLight, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f finalColor = new Vector3f();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    float skyBrightness = class_765.method_23284((class_2874)this.blockAccess.method_8597(), (int)i) * effectiveSkyLight;
                    float blockBrightnessRed = class_765.method_23284((class_2874)this.blockAccess.method_8597(), (int)j) * (this.blockLightRedFlicker + 1.5f);
                    float blockBrightnessGreen = blockBrightnessRed * ((blockBrightnessRed * 0.6f + 0.4f) * 0.6f + 0.4f);
                    float blockBrightnessBlue = blockBrightnessRed * (blockBrightnessRed * blockBrightnessRed * 0.6f + 0.4f);
                    finalColor.set(blockBrightnessRed, blockBrightnessGreen, blockBrightnessBlue);
                    if (this.dimensionInfo.method_28114()) {
                        finalColor.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                        finalColor.set(class_3532.method_15363((float)finalColor.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)finalColor.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)finalColor.z, (float)0.0f, (float)1.0f));
                    } else {
                        finalColor.add((Vector3fc)new Vector3f((Vector3fc)skylightColor).mul(skyBrightness));
                        finalColor.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                    }
                    if (!this.dimensionInfo.method_28114()) {
                        finalColor.set(class_3532.method_15363((float)finalColor.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)finalColor.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)finalColor.z, (float)0.0f, (float)1.0f));
                    }
                    float gamma = ((Double)this.mc.field_1690.method_42473().method_41753()).floatValue();
                    Vector3f vector3f5 = new Vector3f(this.notGamma(finalColor.x), this.notGamma(finalColor.y), this.notGamma(finalColor.z));
                    finalColor.lerp((Vector3fc)vector3f5, Math.max(0.0f, gamma));
                    finalColor.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                    finalColor.set(class_3532.method_15363((float)finalColor.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)finalColor.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)finalColor.z, (float)0.0f, (float)1.0f));
                    finalColor.mul(255.0f);
                    int r = (int)finalColor.x();
                    int g = (int)finalColor.y();
                    int b = (int)finalColor.z();
                    this.lightPixels.method_4305(j, i, 0xFF000000 | b << 16 | g << 8 | r);
                }
            }
            this.lightTexture.method_4524();
            this.lightmapUpdateNeeded = false;
        }
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }

    public float getWaterVision() {
        if (!this.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517)) {
            return 0.0f;
        }
        if ((float)this.waterVisionTime >= 600.0f) {
            return 1.0f;
        }
        float f2 = class_3532.method_15363((float)((float)this.waterVisionTime / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.waterVisionTime < 100.0f ? 0.0f : class_3532.method_15363((float)(((float)this.waterVisionTime - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    public boolean areEyesInFluid(class_6862<class_3611> tagIn) {
        if (this.blockAccess == null) {
            return false;
        }
        class_243 pos = this.getEyePos();
        class_2338 blockpos = class_2338.method_49638((class_2374)pos);
        class_3610 fluidstate = this.blockAccess.method_8316(blockpos);
        return this.isFluidTagged(fluidstate, tagIn) && pos.field_1351 < (double)((float)blockpos.method_10264() + (float)fluidstate.method_15761() + 0.11111111f);
    }

    public class_243 getEyePos() {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getPosition();
    }

    private boolean isFluidTagged(class_3611 fluid, class_6862<class_3611> tag) {
        if (tag == class_3486.field_15517) {
            return fluid == class_3612.field_15910 || fluid == class_3612.field_15909;
        }
        if (tag == class_3486.field_15518) {
            return fluid == class_3612.field_15908 || fluid == class_3612.field_15907;
        }
        return false;
    }

    private boolean isFluidTagged(class_3610 fluidState, class_6862<class_3611> tag) {
        return this.isFluidTagged(fluidState.method_15772(), tag);
    }

    public static class MenuFogRenderer {
        public float fogRed;
        public float fogGreen;
        public float fogBlue;
        private int targetBiomeFog;
        private int previousBiomeFog;
        private long biomeChangedTime;
        private final MenuWorldRenderer menuWorldRenderer;

        public MenuFogRenderer(MenuWorldRenderer menuWorldRenderer) {
            this.menuWorldRenderer = menuWorldRenderer;
        }

        public void setupFogColor() {
            class_243 eyePos = this.menuWorldRenderer.getEyePos();
            class_5636 fogType = this.getEyeFogType();
            if (fogType == class_5636.field_27886) {
                this.updateWaterFog(this.menuWorldRenderer.getLevel());
            } else if (fogType == class_5636.field_27885) {
                this.fogRed = 0.6f;
                this.fogGreen = 0.1f;
                this.fogBlue = 0.0f;
                this.biomeChangedTime = -1L;
            } else if (fogType == class_5636.field_27887) {
                this.fogRed = 0.623f;
                this.fogGreen = 0.734f;
                this.fogBlue = 0.785f;
                this.biomeChangedTime = -1L;
                RenderSystem.clearColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue, (float)0.0f);
            } else {
                this.updateSurfaceFog();
                this.biomeChangedTime = -1L;
            }
            float d0 = (float)((eyePos.field_1351 + (double)this.menuWorldRenderer.getLevel().getGround()) * this.menuWorldRenderer.getLevel().getVoidFogYFactor());
            if ((double)d0 < 1.0 && fogType != class_5636.field_27885 && fogType != class_5636.field_27887) {
                if (d0 < 0.0f) {
                    d0 = 0.0f;
                }
                d0 *= d0;
                this.fogRed *= d0;
                this.fogGreen *= d0;
                this.fogBlue *= d0;
            }
            if (fogType == class_5636.field_27886 && this.fogRed != 0.0f && this.fogGreen != 0.0f && this.fogBlue != 0.0f) {
                float f1 = this.menuWorldRenderer.getWaterVision();
                float f3 = Math.min(1.0f / this.fogRed, Math.min(1.0f / this.fogGreen, 1.0f / this.fogBlue));
                this.fogRed = this.fogRed * (1.0f - f1) + this.fogRed * f3 * f1;
                this.fogGreen = this.fogGreen * (1.0f - f1) + this.fogGreen * f3 * f1;
                this.fogBlue = this.fogBlue * (1.0f - f1) + this.fogBlue * f3 * f1;
            }
            if (OptifineHelper.isOptifineLoaded()) {
                class_243 colUnderlava;
                if (fogType == class_5636.field_27886) {
                    class_243 colUnderwater = OptifineHelper.getCustomUnderwaterColor((class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
                    if (colUnderwater != null) {
                        this.fogRed = (float)colUnderwater.field_1352;
                        this.fogGreen = (float)colUnderwater.field_1351;
                        this.fogBlue = (float)colUnderwater.field_1350;
                    }
                } else if (fogType == class_5636.field_27885 && (colUnderlava = OptifineHelper.getCustomUnderlavaColor((class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350)) != null) {
                    this.fogRed = (float)colUnderlava.field_1352;
                    this.fogGreen = (float)colUnderlava.field_1351;
                    this.fogBlue = (float)colUnderlava.field_1350;
                }
            }
            RenderSystem.clearColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue, (float)0.0f);
        }

        private void updateSurfaceFog() {
            float f7;
            float f = 0.25f + 0.75f * (float)this.menuWorldRenderer.renderDistanceChunks / 32.0f;
            f = 1.0f - (float)Math.pow(f, 0.25);
            class_243 eyePos = this.menuWorldRenderer.getEyePos();
            class_243 skyColor = this.menuWorldRenderer.getSkyColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37670)) {
                    skyColor = OptifineHelper.getCustomSkyColor(skyColor, (class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
                } else if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37672)) {
                    skyColor = OptifineHelper.getCustomSkyColorEnd(skyColor);
                }
            }
            float f1 = (float)skyColor.field_1352;
            float f2 = (float)skyColor.field_1351;
            float f3 = (float)skyColor.field_1350;
            class_243 fogColor = this.menuWorldRenderer.getFogColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37670)) {
                    fogColor = OptifineHelper.getCustomFogColor(fogColor, (class_1920)this.menuWorldRenderer.blockAccess, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
                } else if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37672)) {
                    fogColor = OptifineHelper.getCustomFogColorEnd(fogColor);
                } else if (this.menuWorldRenderer.blockAccess.method_8597().comp_655().equals((Object)class_7134.field_37671)) {
                    fogColor = OptifineHelper.getCustomFogColorNether(fogColor);
                }
            }
            this.fogRed = (float)fogColor.field_1352;
            this.fogGreen = (float)fogColor.field_1351;
            this.fogBlue = (float)fogColor.field_1350;
            if (this.menuWorldRenderer.renderDistanceChunks >= 4) {
                float[] afloat;
                float d0 = class_3532.method_15374((float)this.menuWorldRenderer.getSunAngle()) > 0.0f ? -1.0f : 1.0f;
                class_243 vec3d2 = new class_243((double)d0, 0.0, 0.0).method_1024(0.0f);
                float f5 = (float)ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getDirection().method_1024(this.menuWorldRenderer.worldRotation).method_1026(vec3d2);
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f5 > 0.0f && (afloat = this.menuWorldRenderer.dimensionInfo.method_28109(this.menuWorldRenderer.getTimeOfDay(), 0.0f)) != null) {
                    this.fogRed = this.fogRed * (1.0f - (f5 *= afloat[3])) + afloat[0] * f5;
                    this.fogGreen = this.fogGreen * (1.0f - f5) + afloat[1] * f5;
                    this.fogBlue = this.fogBlue * (1.0f - f5) + afloat[2] * f5;
                }
            }
            this.fogRed += (f1 - this.fogRed) * f;
            this.fogGreen += (f2 - this.fogGreen) * f;
            this.fogBlue += (f3 - this.fogBlue) * f;
            float f6 = this.menuWorldRenderer.getRainLevel();
            if (f6 > 0.0f) {
                float f4 = 1.0f - f6 * 0.5f;
                float f8 = 1.0f - f6 * 0.4f;
                this.fogRed *= f4;
                this.fogGreen *= f4;
                this.fogBlue *= f8;
            }
            if ((f7 = this.menuWorldRenderer.getThunderLevel()) > 0.0f) {
                float f9 = 1.0f - f7 * 0.5f;
                this.fogRed *= f9;
                this.fogGreen *= f9;
                this.fogBlue *= f9;
            }
            this.biomeChangedTime = -1L;
        }

        private void updateWaterFog(class_4538 levelIn) {
            long currentTime = class_156.method_658();
            int waterFogColor = ((class_1959)levelIn.method_23753(class_2338.method_49638((class_2374)this.menuWorldRenderer.getEyePos())).comp_349()).method_8713();
            if (this.biomeChangedTime < 0L) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = waterFogColor;
                this.biomeChangedTime = currentTime;
            }
            int k = this.targetBiomeFog >> 16 & 0xFF;
            int l = this.targetBiomeFog >> 8 & 0xFF;
            int i1 = this.targetBiomeFog & 0xFF;
            int j1 = this.previousBiomeFog >> 16 & 0xFF;
            int k1 = this.previousBiomeFog >> 8 & 0xFF;
            int l1 = this.previousBiomeFog & 0xFF;
            float f = class_3532.method_15363((float)((float)(currentTime - this.biomeChangedTime) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = class_3532.method_16439((float)f, (float)j1, (float)k);
            float f2 = class_3532.method_16439((float)f, (float)k1, (float)l);
            float f3 = class_3532.method_16439((float)f, (float)l1, (float)i1);
            this.fogRed = f1 / 255.0f;
            this.fogGreen = f2 / 255.0f;
            this.fogBlue = f3 / 255.0f;
            if (this.targetBiomeFog != waterFogColor) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = class_3532.method_15375((float)f1) << 16 | class_3532.method_15375((float)f2) << 8 | class_3532.method_15375((float)f3);
                this.biomeChangedTime = currentTime;
            }
        }

        public void setupFog(class_758.class_4596 fogMode) {
            float fogEnd;
            float fogStart;
            class_5636 fogType = this.getEyeFogType();
            class_6854 fogShape = class_6854.field_36350;
            if (fogType == class_5636.field_27885) {
                fogStart = 0.25f;
                fogEnd = 1.0f;
            } else if (fogType == class_5636.field_27887) {
                fogStart = 0.0f;
                fogEnd = 2.0f;
            } else if (fogType == class_5636.field_27886) {
                fogStart = -8.0f;
                fogEnd = 96.0f;
                class_6880 holder = this.menuWorldRenderer.blockAccess.method_23753(class_2338.method_49638((class_2374)this.menuWorldRenderer.getEyePos()));
                if (holder.method_40220(class_6908.field_37378)) {
                    fogEnd *= 0.85f;
                }
                if (fogEnd > (float)this.menuWorldRenderer.renderDistance) {
                    fogEnd = this.menuWorldRenderer.renderDistance;
                    fogShape = class_6854.field_36351;
                }
            } else if (this.menuWorldRenderer.blockAccess.getDimensionReaderInfo().method_28110(0, 0)) {
                fogStart = (float)this.menuWorldRenderer.renderDistance * 0.05f;
                fogEnd = Math.min((float)this.menuWorldRenderer.renderDistance, 192.0f) * 0.5f;
            } else if (fogMode == class_758.class_4596.field_20945) {
                fogStart = 0.0f;
                fogEnd = this.menuWorldRenderer.renderDistance;
                fogShape = class_6854.field_36351;
            } else {
                float h = class_3532.method_15363((float)((float)this.menuWorldRenderer.renderDistance / 10.0f), (float)4.0f, (float)64.0f);
                fogStart = (float)this.menuWorldRenderer.renderDistance - h;
                fogEnd = this.menuWorldRenderer.renderDistance;
                fogShape = class_6854.field_36351;
            }
            RenderSystem.setShaderFogStart((float)fogStart);
            RenderSystem.setShaderFogEnd((float)fogEnd);
            RenderSystem.setShaderFogShape((class_6854)fogShape);
        }

        private class_5636 getEyeFogType() {
            class_5636 fogType = class_5636.field_27888;
            if (this.menuWorldRenderer.areEyesInFluid((class_6862<class_3611>)class_3486.field_15517)) {
                fogType = class_5636.field_27886;
            } else if (this.menuWorldRenderer.areEyesInFluid((class_6862<class_3611>)class_3486.field_15518)) {
                fogType = class_5636.field_27885;
            } else if (this.menuWorldRenderer.blockAccess.method_8320(class_2338.method_49638((class_2374)this.menuWorldRenderer.getEyePos())).method_27852(class_2246.field_27879)) {
                fogType = class_5636.field_27887;
            }
            return fogType;
        }

        public void setupNoFog() {
            RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        }

        public void levelFogColor() {
            RenderSystem.setShaderFogColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue);
        }
    }

    private static class FluidStateWrapper
    extends class_3610 {
        private final class_3610 fluidState;

        public FluidStateWrapper(class_3610 fluidState) {
            super(fluidState.method_15772(), (Reference2ObjectArrayMap)fluidState.method_11656(), fluidState.field_24740);
            this.fluidState = fluidState;
        }

        public boolean method_15767(class_6862<class_3611> tagIn) {
            if (tagIn == class_3486.field_15517) {
                return this.method_15772() == class_3612.field_15910 || this.method_15772() == class_3612.field_15909;
            }
            if (tagIn == class_3486.field_15518) {
                return this.method_15772() == class_3612.field_15908 || this.method_15772() == class_3612.field_15907;
            }
            return this.fluidState.method_15767(tagIn);
        }
    }
}

