/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.menuworlds.MenuWorldExporter;
import org.vivecraft.client_vr.settings.VRSettings;

public class MenuWorldDownloader {
    private static final String baseUrl = "https://cache.techjargaming.com/vivecraft/115/";
    public static final String customWorldFolder = "menuworlds/custom_120";
    private static String lastWorld = "";
    private static boolean init;
    private static Random rand;

    public static void init() {
        if (init) {
            return;
        }
        rand = new Random();
        rand.nextInt();
        init = true;
    }

    public static void downloadWorld(String path) throws IOException, NoSuchAlgorithmException {
        String remoteSha1;
        String localSha1;
        File file = new File(path);
        file.getParentFile().mkdirs();
        if (file.exists() && (localSha1 = Utils.getFileChecksum(file, "SHA-1")).equals(remoteSha1 = Utils.httpReadLine("https://cache.techjargaming.com/vivecraft/115/checksum.php?file=" + path))) {
            VRSettings.logger.info("MenuWorlds: SHA-1 matches for " + path);
            return;
        }
        VRSettings.logger.info("MenuWorlds: Downloading world " + path);
        Utils.httpReadToFile(baseUrl + path, file, true);
    }

    public static InputStream getRandomWorld() {
        MenuWorldDownloader.init();
        VRSettings settings = ClientDataHolderVR.getInstance().vrSettings;
        try {
            ArrayList<MenuWorldItem> worldList = new ArrayList<MenuWorldItem>();
            if (settings.menuWorldSelection == VRSettings.MenuWorld.BOTH || settings.menuWorldSelection == VRSettings.MenuWorld.CUSTOM) {
                worldList.addAll(MenuWorldDownloader.getCustomWorlds());
            }
            if (settings.menuWorldSelection == VRSettings.MenuWorld.BOTH || settings.menuWorldSelection == VRSettings.MenuWorld.OFFICIAL || worldList.size() == 0) {
                worldList.addAll(MenuWorldDownloader.getOfficialWorlds());
            }
            if (worldList.size() > 1) {
                worldList.removeIf(world -> lastWorld.equals(world.path) || world.file != null && lastWorld.equals(world.file.getPath()));
            }
            if (worldList.size() == 0) {
                return MenuWorldDownloader.getRandomWorldFallback();
            }
            MenuWorldItem world2 = MenuWorldDownloader.getRandomWorldFromList(worldList);
            if (world2 != null) {
                lastWorld = world2.file != null ? world2.file.getPath() : world2.path;
            }
            return MenuWorldDownloader.getStreamForWorld(world2);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            try {
                return MenuWorldDownloader.getRandomWorldFallback();
            }
            catch (IOException | NoSuchAlgorithmException e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    private static InputStream getStreamForWorld(MenuWorldItem world) throws IOException, NoSuchAlgorithmException {
        if (world.file != null) {
            VRSettings.logger.info("MenuWorlds: Using world " + world.file.getName());
            return new FileInputStream(world.file);
        }
        if (world.path != null) {
            MenuWorldDownloader.downloadWorld(world.path);
            VRSettings.logger.info("MenuWorlds: Using official world " + world.path);
            return new FileInputStream(world.path);
        }
        throw new IllegalArgumentException("File or path must be assigned");
    }

    private static List<MenuWorldItem> getCustomWorlds() throws IOException {
        File dir = new File(customWorldFolder);
        if (dir.exists()) {
            return MenuWorldDownloader.getWorldsInDirectory(dir);
        }
        return new ArrayList<MenuWorldItem>();
    }

    private static List<MenuWorldItem> getOfficialWorlds() throws IOException {
        ArrayList<MenuWorldItem> list = new ArrayList<MenuWorldItem>();
        List<String> resultList = Utils.httpReadAllLines("https://cache.techjargaming.com/vivecraft/115/menuworlds_list.php?minver=2&maxver=5&mcver=1.20.5");
        for (String str : resultList) {
            list.add(new MenuWorldItem("menuworlds/" + str, null));
        }
        return list;
    }

    private static InputStream getRandomWorldFallback() throws IOException, NoSuchAlgorithmException {
        MenuWorldItem world;
        VRSettings.logger.info("MenuWorlds: Couldn't find a world, trying random file from directory");
        File dir = new File("menuworlds");
        if (dir.exists() && (world = MenuWorldDownloader.getRandomWorldFromList(MenuWorldDownloader.getWorldsInDirectory(dir))) != null) {
            return MenuWorldDownloader.getStreamForWorld(world);
        }
        return null;
    }

    private static List<MenuWorldItem> getWorldsInDirectory(File dir) throws IOException {
        ArrayList<MenuWorldItem> worlds = new ArrayList<MenuWorldItem>();
        for (File file2 : dir.listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".mmw"))) {
            int version = MenuWorldExporter.readVersion(file2);
            if (version < 2 || version > 5) continue;
            worlds.add(new MenuWorldItem(null, file2));
        }
        return worlds;
    }

    private static MenuWorldItem getRandomWorldFromList(List<MenuWorldItem> list) {
        if (list.size() > 0) {
            return list.get(rand.nextInt(list.size()));
        }
        return null;
    }

    private static class MenuWorldItem {
        final File file;
        final String path;

        public MenuWorldItem(String path, File file) {
            this.file = file;
            this.path = path;
        }
    }
}

